/*
 * Decompiled with CFR 0.152.
 */
package com.tom.storagemod.screen;

import com.google.common.base.Predicates;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.gson.JsonElement;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import com.tom.storagemod.Config;
import com.tom.storagemod.client.ClientUtil;
import com.tom.storagemod.inventory.StoredItemStack;
import com.tom.storagemod.menu.StorageTerminalMenu;
import com.tom.storagemod.screen.CraftingTerminalScreen;
import com.tom.storagemod.screen.IScreen;
import com.tom.storagemod.screen.TSContainerScreen;
import com.tom.storagemod.screen.widget.EnumCycleButton;
import com.tom.storagemod.screen.widget.TerminalSearchModeButton;
import com.tom.storagemod.screen.widget.ToggleButton;
import com.tom.storagemod.util.ComponentJoiner;
import com.tom.storagemod.util.IAutoFillTerminal;
import com.tom.storagemod.util.IDataReceiver;
import com.tom.storagemod.util.NumberFormatUtil;
import com.tom.storagemod.util.PopupMenuManager;
import com.tom.storagemod.util.TerminalSyncManager;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import net.minecraft.CrashReport;
import net.minecraft.ReportedException;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.gui.components.Tooltip;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.core.component.DataComponentPatch;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.RegistryOps;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.Container;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.HumanoidArm;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import org.lwjgl.glfw.GLFW;

public abstract class AbstractStorageTerminalScreen<T extends StorageTerminalMenu>
extends TSContainerScreen<T>
implements IDataReceiver {
    private static final ResourceLocation SCROLLER_SPRITE = ResourceLocation.parse((String)"container/creative_inventory/scroller");
    private static final ResourceLocation SCROLLER_DISABLED_SPRITE = ResourceLocation.parse((String)"container/creative_inventory/scroller_disabled");
    private static final ResourceLocation FLOATING_SLOT = ResourceLocation.tryBuild((String)"toms_storage", (String)"widget/floating_slot");
    private static final LoadingCache<StoredItemStack, List<String>> tooltipCache = CacheBuilder.newBuilder().expireAfterAccess(5L, TimeUnit.SECONDS).build(CacheLoader.from(key -> {
        Minecraft mc = Minecraft.getInstance();
        TooltipFlag.Default flag = mc.options.advancedItemTooltips ? TooltipFlag.Default.ADVANCED : TooltipFlag.Default.NORMAL;
        return key.getStack().getTooltipLines(Item.TooltipContext.of((Level)mc.level), (Player)mc.player, (TooltipFlag)flag).stream().map(Component::getString).collect(Collectors.toList());
    }));
    private static final LoadingCache<StoredItemStack, String> componentCache = CacheBuilder.newBuilder().expireAfterAccess(5L, TimeUnit.SECONDS).build(CacheLoader.from(key -> {
        RegistryOps ctx = Minecraft.getInstance().level.registryAccess().createSerializationContext((DynamicOps)JsonOps.COMPRESSED);
        return (String)DataComponentPatch.CODEC.encodeStart((DynamicOps)ctx, (Object)key.getStack().getComponentsPatch()).mapOrElse(JsonElement::toString, e -> "");
    }));
    private static final LoadingCache<StoredItemStack, List<String>> tagCache = CacheBuilder.newBuilder().expireAfterAccess(5L, TimeUnit.SECONDS).build(CacheLoader.from(key -> key.getStack().getTags().map(t -> t.location().toString()).toList()));
    protected float currentScroll;
    protected boolean isScrolling;
    private boolean refreshItemList;
    protected boolean wasClicking;
    protected EditBox searchField;
    protected int slotIDUnderMouse = -1;
    protected int controllMode;
    protected int rowCount;
    private String searchLast = "";
    protected boolean loadedSearch = false;
    protected boolean ghostItems;
    protected boolean tallMode;
    public final int textureSlotCount;
    public final int guiHeight;
    public final int slotStartX;
    public final int slotStartY;
    private StoredItemStack.IStoredItemStackComparator comparator = new StoredItemStack.ComparatorAmount(false);
    protected EnumCycleButton<StoredItemStack.SortingTypes> buttonSortingType;
    protected EnumCycleButton<ControllMode> buttonCtrlMode;
    protected TerminalSearchModeButton buttonSearchType;
    protected ToggleButton buttonDirection;
    protected ToggleButton buttonGhostMode;
    protected ToggleButton buttonTallMode;
    private Comparator<StoredItemStack> sortComp;
    protected PopupMenuManager popup = new PopupMenuManager((Screen)this);
    private FakeSlot fakeSlotUnderMouse = new FakeSlot();

    public AbstractStorageTerminalScreen(T screenContainer, Inventory inv, Component titleIn, int textureSlotCount, int guiHeight, int slotStartX, int slotStartY) {
        super(screenContainer, inv, titleIn);
        ((StorageTerminalMenu)screenContainer).onPacket = this::onPacket;
        this.textureSlotCount = textureSlotCount;
        this.guiHeight = guiHeight;
        this.slotStartX = slotStartX;
        this.slotStartY = slotStartY;
    }

    protected void onPacket() {
        boolean tallMode;
        this.controllMode = (((StorageTerminalMenu)this.menu).modes & 0xF) % ControllMode.VALUES.length;
        boolean rev = (((StorageTerminalMenu)this.menu).sorting & 0x100) > 0;
        int type = ((StorageTerminalMenu)this.menu).sorting & 0xFF;
        this.comparator = StoredItemStack.SortingTypes.VALUES[type % StoredItemStack.SortingTypes.VALUES.length].create(rev);
        int searchType = ((StorageTerminalMenu)this.menu).searchType;
        this.ghostItems = (((StorageTerminalMenu)this.menu).sorting & 0x200) == 0;
        boolean bl = tallMode = (((StorageTerminalMenu)this.menu).modes & 0x10) != 0;
        if (tallMode != this.tallMode) {
            this.tallMode = tallMode;
            this.init();
        }
        if (searchType != -1) {
            if (!this.searchField.isFocused() && (searchType & 1) > 0) {
                this.searchField.setFocused(true);
            }
            this.buttonSearchType.setSearchType(searchType);
            if (!this.loadedSearch && ((StorageTerminalMenu)this.menu).search != null) {
                this.loadedSearch = true;
                if ((searchType & 2) > 0) {
                    this.searchField.setValue(((StorageTerminalMenu)this.menu).search);
                }
            }
        }
        this.buttonSortingType.setState(StoredItemStack.SortingTypes.VALUES[type % StoredItemStack.SortingTypes.VALUES.length]);
        this.buttonDirection.setState(rev);
        this.buttonCtrlMode.setState(ControllMode.VALUES[this.controllMode]);
        this.buttonGhostMode.setState(this.ghostItems);
        this.buttonTallMode.setState(tallMode);
    }

    protected void sendUpdate() {
        CompoundTag c = new CompoundTag();
        int sort = 0;
        sort |= this.comparator.type() & 0xFF;
        sort |= this.comparator.isReversed() ? 256 : 0;
        c.putInt("s", sort |= this.ghostItems ? 0 : 512);
        c.putInt("st", this.buttonSearchType.getSearchType());
        c.putInt("m", this.writeModes());
        CompoundTag msg = new CompoundTag();
        msg.put("c", (Tag)c);
        ((StorageTerminalMenu)this.menu).sendMessage(msg);
    }

    protected int writeModes() {
        int d = 0;
        d |= this.controllMode & 0xF;
        return d |= this.tallMode ? 16 : 0;
    }

    protected void init() {
        this.clearWidgets();
        if (this.tallMode) {
            int guiSize = this.guiHeight - this.textureSlotCount * 18;
            this.rowCount = (this.height - 30 - guiSize) / 18;
            this.imageHeight = guiSize + this.rowCount * 18;
            ((StorageTerminalMenu)this.menu).setOffset(0, (this.rowCount - this.textureSlotCount) * 18);
            ((StorageTerminalMenu)this.menu).addStorageSlots(this.rowCount, this.slotStartX + 1, this.slotStartY + 1);
        } else {
            this.rowCount = this.textureSlotCount;
            ((StorageTerminalMenu)this.menu).setOffset(0, 0);
            ((StorageTerminalMenu)this.menu).addStorageSlots(this.rowCount, this.slotStartX + 1, this.slotStartY + 1);
        }
        Slot offh = ((StorageTerminalMenu)this.getMenu()).offhand;
        offh.x = this.minecraft.options.mainHand().get() == HumanoidArm.RIGHT ? -26 : 186;
        this.inventoryLabelY = this.imageHeight - 92;
        super.init();
        Font font = this.getFont();
        Objects.requireNonNull(this.getFont());
        this.searchField = new EditBox(font, this.leftPos + 82, this.topPos + 6, 89, 9, (Component)Component.translatable((String)"narrator.toms_storage.terminal_search"));
        this.searchField.setMaxLength(100);
        this.searchField.setBordered(false);
        this.searchField.setVisible(true);
        this.searchField.setTextColor(0xFFFFFF);
        this.searchField.setValue(this.searchLast);
        this.searchLast = "";
        this.addWidget((GuiEventListener)this.searchField);
        this.buttonSortingType = (EnumCycleButton)this.addRenderableWidget((GuiEventListener)new EnumCycleButton(this.leftPos - 18, this.topPos + 5, (Component)Component.translatable((String)"narrator.toms_storage.terminal_sort"), "sort", (Enum[])StoredItemStack.SortingTypes.VALUES, n -> {
            this.comparator = n.create(this.comparator.isReversed());
            this.buttonSortingType.setState((StoredItemStack.SortingTypes)((Object)n));
            this.sendUpdate();
            this.refreshItemList = true;
        }));
        this.buttonDirection = (ToggleButton)this.addRenderableWidget((GuiEventListener)ToggleButton.builder(this.leftPos - 18, this.topPos + 5 + 18).name((Component)Component.translatable((String)"narrator.toms_storage.terminal_sort_rev")).iconOff(ResourceLocation.tryBuild((String)"toms_storage", (String)"icons/sort_desc")).iconOn(ResourceLocation.tryBuild((String)"toms_storage", (String)"icons/sort_asc")).build(n -> {
            this.comparator.setReversed(n);
            this.buttonDirection.setState(n);
            this.sendUpdate();
            this.refreshItemList = true;
        }));
        this.buttonSearchType = (TerminalSearchModeButton)this.addRenderableWidget((GuiEventListener)new TerminalSearchModeButton(this.leftPos - 18, this.topPos + 5 + 36, this.popup, IAutoFillTerminal.hasSync() || this instanceof CraftingTerminalScreen, this::sendUpdate));
        this.buttonCtrlMode = (EnumCycleButton)this.addRenderableWidget((GuiEventListener)new EnumCycleButton(this.leftPos - 18, this.topPos + 5 + 54, (Component)Component.translatable((String)"narrator.toms_storage.terminal_control"), "control", (Enum[])ControllMode.VALUES, n -> {
            this.controllMode = n.ordinal();
            this.buttonCtrlMode.setState((ControllMode)((Object)n));
            this.sendUpdate();
        }));
        this.buttonGhostMode = (ToggleButton)this.addRenderableWidget((GuiEventListener)ToggleButton.builder(this.leftPos - 18, this.topPos + 5 + 72).name((Component)Component.translatable((String)"narrator.toms_storage.terminal_ghost_items")).iconOff(ResourceLocation.tryBuild((String)"toms_storage", (String)"icons/keep_last_off")).iconOn(ResourceLocation.tryBuild((String)"toms_storage", (String)"icons/keep_last_0")).build(n -> {
            this.ghostItems = n;
            this.buttonGhostMode.setState(n);
            this.sendUpdate();
        }));
        this.buttonGhostMode.setTooltip(Tooltip.create((Component)Component.translatable((String)"tooltip.toms_storage.ghostMode_off")), Tooltip.create((Component)Component.translatable((String)"tooltip.toms_storage.ghostMode_on")));
        this.buttonTallMode = (ToggleButton)this.addRenderableWidget((GuiEventListener)ToggleButton.builder(this.leftPos - 18, this.topPos + 5 + 90).name((Component)Component.translatable((String)"narrator.toms_storage.terminal_tall_mode")).iconOff(ResourceLocation.tryBuild((String)"toms_storage", (String)"icons/tall_terminal_off")).iconOn(ResourceLocation.tryBuild((String)"toms_storage", (String)"icons/tall_terminal_on")).build(n -> {
            this.tallMode = n;
            this.buttonTallMode.setState(n);
            this.sendUpdate();
            this.init();
        }));
        this.buttonTallMode.setTooltip(Tooltip.create((Component)Component.translatable((String)"tooltip.toms_storage.tallMode_off")), Tooltip.create((Component)Component.translatable((String)"tooltip.toms_storage.tallMode_on")));
        this.buttonSortingType.tooltipFactory = s -> Tooltip.create((Component)Component.translatable((String)("tooltip.toms_storage.sorting_" + s.name().toLowerCase(Locale.ROOT))));
        this.buttonCtrlMode.tooltipFactory = s -> Tooltip.create((Component)Arrays.stream(I18n.get((String)("tooltip.toms_storage.ctrlMode_" + s.name().toLowerCase(Locale.ROOT)), (Object[])new Object[0]).split("\\\\")).map(Component::literal).collect(ComponentJoiner.joining((Component)Component.empty(), (Component)Component.literal((String)"\n"))));
        this.updateSearch();
    }

    private static Pattern buildPattern(String s) {
        try {
            return Pattern.compile(s, 2);
        }
        catch (Throwable ignore) {
            try {
                return Pattern.compile(Pattern.quote(s), 2);
            }
            catch (Throwable ignored) {
                return null;
            }
        }
    }

    protected void updateSearch() {
        String searchString = this.searchField.getValue();
        if (this.refreshItemList || !this.searchLast.equals(searchString)) {
            int i;
            ((StorageTerminalMenu)this.getMenu()).itemListClientSorted.clear();
            Object pred = null;
            String[] or = searchString.split("\\|");
            for (i = 0; i < or.length; ++i) {
                String part = or[i].trim();
                if (part.isEmpty()) continue;
                String[] sp = part.split(" ");
                Object p = Predicates.alwaysTrue();
                for (int j = 0; j < sp.length; ++j) {
                    Pattern m;
                    String fs;
                    String s = sp[j].toLowerCase();
                    if (s.startsWith("@")) {
                        fs = s.substring(1);
                        p = p.and(is -> BuiltInRegistries.ITEM.getKey((Object)is.getStack().getItem()).getNamespace().contains(fs));
                        continue;
                    }
                    if (s.startsWith("#")) {
                        fs = s.substring(1);
                        p = p.and(is -> {
                            try {
                                return ((List)tagCache.get(is)).stream().anyMatch(st -> st.contains(fs));
                            }
                            catch (Exception e) {
                                return false;
                            }
                        });
                        continue;
                    }
                    if (s.startsWith("$")) {
                        m = AbstractStorageTerminalScreen.buildPattern(s.substring(1));
                        if (m == null) continue;
                        p = p.and(is -> {
                            if (is.getStack().getComponentsPatch().isEmpty()) {
                                return false;
                            }
                            try {
                                return m.matcher((CharSequence)componentCache.get(is)).find();
                            }
                            catch (Exception e) {
                                return false;
                            }
                        });
                        continue;
                    }
                    m = AbstractStorageTerminalScreen.buildPattern(s);
                    if (m == null) continue;
                    p = p.and(is -> {
                        try {
                            String dspName = is.getStack().getHoverName().getString();
                            if (m.matcher(dspName.toLowerCase()).find()) {
                                return true;
                            }
                            for (String lp : (List)tooltipCache.get(is)) {
                                if (!m.matcher(lp).find()) continue;
                                return true;
                            }
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                        return false;
                    });
                }
                pred = pred == null ? p : pred.or(p);
            }
            if (pred == null) {
                pred = Predicates.alwaysTrue();
            }
            try {
                for (i = 0; i < ((StorageTerminalMenu)this.getMenu()).itemListClient.size(); ++i) {
                    StoredItemStack is2 = ((StorageTerminalMenu)this.getMenu()).itemListClient.get(i);
                    if (is2 == null || is2.getStack() == null || !pred.test(is2)) continue;
                    this.addStackToClientList(is2);
                }
            }
            catch (Exception i2) {
                // empty catch block
            }
            Collections.sort(((StorageTerminalMenu)this.getMenu()).itemListClientSorted, ((StorageTerminalMenu)this.menu).noSort ? this.sortComp : this.comparator);
            if (!this.searchLast.equals(searchString)) {
                ((StorageTerminalMenu)this.getMenu()).scrollTo(0.0f);
                this.currentScroll = 0.0f;
                int searchType = this.buttonSearchType.getSearchType();
                if (searchType != -1) {
                    if ((searchType & 4) > 0) {
                        IAutoFillTerminal.sync(searchString);
                    }
                    if ((searchType & 2) > 0) {
                        CompoundTag nbt = new CompoundTag();
                        nbt.putString("s", searchString);
                        ((StorageTerminalMenu)this.menu).sendMessage(nbt);
                    }
                }
                this.onUpdateSearch(searchString);
            } else {
                ((StorageTerminalMenu)this.getMenu()).scrollTo(this.currentScroll);
            }
            this.refreshItemList = false;
            this.searchLast = searchString;
        }
    }

    private void addStackToClientList(StoredItemStack is) {
        ((StorageTerminalMenu)this.getMenu()).itemListClientSorted.add(is);
    }

    protected void containerTick() {
        this.updateSearch();
    }

    public void render(GuiGraphics st, int mouseX, int mouseY, float partialTicks) {
        boolean flag = GLFW.glfwGetMouseButton((long)Minecraft.getInstance().getWindow().getWindow(), (int)0) != 0;
        int i = this.leftPos;
        int j = this.topPos;
        int k = i + 174;
        int l = j + 18;
        int i1 = k + 14;
        int j1 = l + this.rowCount * 18;
        if (((StorageTerminalMenu)this.menu).itemsLoaded && this.ghostItems && AbstractStorageTerminalScreen.hasShiftDown()) {
            if (!((StorageTerminalMenu)this.menu).noSort) {
                List<StoredItemStack> list = ((StorageTerminalMenu)this.getMenu()).itemListClientSorted;
                Object2IntOpenHashMap map = new Object2IntOpenHashMap();
                map.defaultReturnValue(Integer.MAX_VALUE);
                for (int m = 0; m < list.size(); ++m) {
                    map.put((Object)list.get(m), m);
                }
                this.sortComp = Comparator.comparing(arg_0 -> ((Object2IntMap)map).getInt(arg_0));
                ((StorageTerminalMenu)this.menu).noSort = true;
            }
        } else if (((StorageTerminalMenu)this.menu).noSort) {
            this.sortComp = null;
            ((StorageTerminalMenu)this.menu).noSort = false;
            this.refreshItemList = true;
            ((StorageTerminalMenu)this.menu).itemListClient = new ArrayList<StoredItemStack>(((StorageTerminalMenu)this.menu).itemList);
        }
        if (!this.wasClicking && flag && mouseX >= k && mouseY >= l && mouseX < i1 && mouseY < j1) {
            this.isScrolling = this.needsScrollBars();
        }
        if (!flag) {
            this.isScrolling = false;
        }
        this.wasClicking = flag;
        if (this.isScrolling) {
            this.currentScroll = ((float)(mouseY - l) - 7.5f) / ((float)(j1 - l) - 15.0f);
            this.currentScroll = Mth.clamp((float)this.currentScroll, (float)0.0f, (float)1.0f);
            ((StorageTerminalMenu)this.getMenu()).scrollTo(this.currentScroll);
        }
        super.render(st, mouseX, mouseY, partialTicks);
        i = k;
        j = l;
        k = j1;
        st.blitSprite(RenderType::guiTextured, this.needsScrollBars() ? SCROLLER_SPRITE : SCROLLER_DISABLED_SPRITE, i, j + (int)((float)(k - j - 17) * this.currentScroll), 12, 15);
        this.searchField.render(st, mouseX, mouseY, partialTicks);
        if (((StorageTerminalMenu)this.menu).beaconLvl >= 0) {
            int x = 176;
            int y = 24 + this.rowCount * 18;
            st.renderItem(new ItemStack((ItemLike)Items.BEACON), this.leftPos + x, this.topPos + y);
            if (this.isHovering(x, y, 16, 16, mouseX, mouseY)) {
                Object info = Config.get().wirelessTermBeaconLvlCrossDim != -1 && ((StorageTerminalMenu)this.menu).beaconLvl >= Config.get().wirelessTermBeaconLvlCrossDim ? "\\" + I18n.get((String)"tooltip.toms_storage.terminal_beacon.anywhere", (Object[])new Object[0]) : (Config.get().wirelessTermBeaconLvl != -1 && ((StorageTerminalMenu)this.menu).beaconLvl >= Config.get().wirelessTermBeaconLvl ? "\\" + I18n.get((String)"tooltip.toms_storage.terminal_beacon.sameDim", (Object[])new Object[0]) : "");
                st.renderComponentTooltip(this.font, Arrays.stream(I18n.get((String)"tooltip.toms_storage.terminal_beacon", (Object[])new Object[]{((StorageTerminalMenu)this.menu).beaconLvl, info}).split("\\\\")).map(Component::literal).collect(Collectors.toList()), mouseX, mouseY);
            }
        }
        if (this.isHovering(176, 4, 16, 10, mouseX, mouseY)) {
            st.renderComponentTooltip(this.font, List.of(Component.translatable((String)"tooltip.toms_storage.terminal_stat.slots", (Object[])new Object[]{((StorageTerminalMenu)this.menu).slotCount == Short.MAX_VALUE ? Component.translatable((String)"tooltip.toms_storage.terminal_stat.alot") : Integer.valueOf(((StorageTerminalMenu)this.menu).slotCount)}), Component.translatable((String)"tooltip.toms_storage.terminal_stat.free", (Object[])new Object[]{((StorageTerminalMenu)this.menu).freeCount == Short.MAX_VALUE ? Component.translatable((String)"tooltip.toms_storage.terminal_stat.alot") : Integer.valueOf(((StorageTerminalMenu)this.menu).freeCount), ((StorageTerminalMenu)this.menu).freeCount == Short.MAX_VALUE || ((StorageTerminalMenu)this.menu).slotCount == Short.MAX_VALUE ? "?" : Integer.valueOf(Math.round((float)((StorageTerminalMenu)this.menu).freeCount / (float)((StorageTerminalMenu)this.menu).slotCount * 100.0f))}), Component.translatable((String)"tooltip.toms_storage.terminal_stat.unique", (Object[])new Object[]{((StorageTerminalMenu)this.menu).itemList.size()})), mouseX, mouseY);
        }
        if (this.popup.render(st, this.font, mouseX, mouseY)) {
            if (((StorageTerminalMenu)this.menu).getCarried().isEmpty() && this.slotIDUnderMouse != -1) {
                StorageTerminalMenu.SlotStorage slot = ((StorageTerminalMenu)this.getMenu()).storageSlotList.get(this.slotIDUnderMouse);
                if (slot.stack != null) {
                    if (slot.stack.getQuantity() > 9999L) {
                        ClientUtil.setTooltip(new Component[]{Component.translatable((String)"tooltip.toms_storage.amount", (Object[])new Object[]{slot.stack.getQuantity()})});
                    }
                    try {
                        st.renderTooltip(this.font, slot.stack.getQuantity() == 0L ? slot.stack.getStack() : slot.stack.getActualStack(), mouseX, mouseY);
                    }
                    catch (IllegalStateException e) {
                        ClientUtil.setTooltip(new Component[]{Component.translatable((String)"tooltip.toms_storage.amount", (Object[])new Object[]{slot.stack.getQuantity()})});
                        st.renderTooltip(this.font, slot.stack.getStack(), mouseX, mouseY);
                    }
                    ClientUtil.setTooltip(new Component[0]);
                }
            } else {
                this.renderTooltip(st, mouseX, mouseY);
            }
        } else {
            this.clearTooltipForNextRenderPass();
        }
    }

    protected void renderLabels(GuiGraphics st, int mouseX, int mouseY) {
        super.renderLabels(st, mouseX, mouseY);
        st.drawString(this.font, "i", 180, 6, 0x404040, false);
        st.pose().pushPose();
        this.slotIDUnderMouse = this.drawSlots(st, mouseX, mouseY);
        st.pose().popPose();
    }

    protected int drawSlots(GuiGraphics st, int mouseX, int mouseY) {
        StorageTerminalMenu term = (StorageTerminalMenu)this.getMenu();
        int slotHover = -1;
        for (int i = 0; i < term.storageSlotList.size(); ++i) {
            if (!this.drawSlot(st, term.storageSlotList.get(i), mouseX, mouseY)) continue;
            slotHover = i;
        }
        return slotHover;
    }

    protected boolean drawSlot(GuiGraphics st, StorageTerminalMenu.SlotStorage slot, int mouseX, int mouseY) {
        if (slot.stack != null) {
            try {
                ItemStack stack = slot.stack.getStack().copyWithCount(1);
                int i = slot.xDisplayPosition;
                int j = slot.yDisplayPosition;
                st.renderItem(stack, i, j);
                st.renderItemDecorations(this.font, stack, i, j);
                this.drawStackSize(st, this.getFont(), slot.stack.getQuantity(), i, j);
            }
            catch (Exception e) {
                CrashReport report = CrashReport.forThrowable((Throwable)e, (String)"Rendering item stack in terminal");
                report.addCategory("Item details:").setDetail("Item Id", () -> BuiltInRegistries.ITEM.getKey((Object)slot.stack.getStack().getItem()).toString()).setDetail("Item Count", (Object)slot.stack.getQuantity()).setDetail("Item Components", () -> (String)componentCache.get((Object)slot.stack));
                throw new ReportedException(report);
            }
        }
        if (mouseX >= this.getGuiLeft() + slot.xDisplayPosition - 1 && mouseY >= this.getGuiTop() + slot.yDisplayPosition - 1 && mouseX < this.getGuiLeft() + slot.xDisplayPosition + 17 && mouseY < this.getGuiTop() + slot.yDisplayPosition + 17) {
            int l = slot.xDisplayPosition;
            int t = slot.yDisplayPosition;
            st.fill(l, t, l + 16, t + 16, -2130706433);
            this.renderSlot(st, this.fakeSlotUnderMouse);
            return true;
        }
        return false;
    }

    private void drawStackSize(GuiGraphics st, Font fr, long size, int x, int y) {
        float scaleFactor = 0.6f;
        String stackSize = NumberFormatUtil.formatNumber(size);
        st.pose().pushPose();
        st.pose().scale(scaleFactor, scaleFactor, scaleFactor);
        st.pose().translate(0.0f, 0.0f, 450.0f);
        float inverseScaleFactor = 1.0f / scaleFactor;
        int X = (int)(((float)x + 0.0f + 16.0f - (float)fr.width(stackSize) * scaleFactor) * inverseScaleFactor);
        int Y = (int)(((float)y + 0.0f + 16.0f - 7.0f * scaleFactor) * inverseScaleFactor);
        st.drawString(fr, stackSize, X, Y, size == 0L ? 0xFFFF00 : 0xFFFFFF, true);
        st.pose().popPose();
    }

    protected boolean needsScrollBars() {
        return ((StorageTerminalMenu)this.getMenu()).itemListClientSorted.size() > this.rowCount * 9;
    }

    /*
     * Enabled aggressive block sorting
     */
    public boolean mouseClicked(double mouseX, double mouseY, int mouseButton) {
        if (this.popup.mouseClick(mouseX, mouseY, mouseButton)) {
            return true;
        }
        if (this.slotIDUnderMouse > -1) {
            if (this.isPullOne(mouseButton)) {
                if (((StorageTerminalMenu)this.getMenu()).getSlotByID((int)this.slotIDUnderMouse).stack == null) return true;
                if (((StorageTerminalMenu)this.getMenu()).getSlotByID((int)this.slotIDUnderMouse).stack.getQuantity() <= 0L) return true;
                this.storageSlotClick(((StorageTerminalMenu)this.getMenu()).getSlotByID((int)this.slotIDUnderMouse).stack, TerminalSyncManager.SlotAction.PULL_ONE, this.isTransferOne(mouseButton));
                return true;
            }
            if (this.pullHalf(mouseButton)) {
                if (!((StorageTerminalMenu)this.menu).getCarried().isEmpty()) {
                    this.storageSlotClick(null, AbstractStorageTerminalScreen.hasControlDown() ? TerminalSyncManager.SlotAction.GET_QUARTER : TerminalSyncManager.SlotAction.GET_HALF, false);
                    return true;
                }
                if (((StorageTerminalMenu)this.getMenu()).getSlotByID((int)this.slotIDUnderMouse).stack == null) return true;
                if (((StorageTerminalMenu)this.getMenu()).getSlotByID((int)this.slotIDUnderMouse).stack.getQuantity() <= 0L) return true;
                this.storageSlotClick(((StorageTerminalMenu)this.getMenu()).getSlotByID((int)this.slotIDUnderMouse).stack, AbstractStorageTerminalScreen.hasControlDown() ? TerminalSyncManager.SlotAction.GET_QUARTER : TerminalSyncManager.SlotAction.GET_HALF, false);
                return true;
            }
            if (!this.pullNormal(mouseButton)) return true;
            if (!((StorageTerminalMenu)this.menu).getCarried().isEmpty()) {
                this.storageSlotClick(null, TerminalSyncManager.SlotAction.PULL_OR_PUSH_STACK, false);
                return true;
            }
            if (((StorageTerminalMenu)this.getMenu()).getSlotByID((int)this.slotIDUnderMouse).stack == null) return true;
            if (((StorageTerminalMenu)this.getMenu()).getSlotByID((int)this.slotIDUnderMouse).stack.getQuantity() <= 0L) return true;
            this.storageSlotClick(((StorageTerminalMenu)this.getMenu()).getSlotByID((int)this.slotIDUnderMouse).stack, AbstractStorageTerminalScreen.hasShiftDown() ? TerminalSyncManager.SlotAction.SHIFT_PULL : TerminalSyncManager.SlotAction.PULL_OR_PUSH_STACK, false);
            return true;
        }
        if (GLFW.glfwGetKey((long)this.minecraft.getWindow().getWindow(), (int)32) != 0) {
            this.storageSlotClick(null, TerminalSyncManager.SlotAction.SPACE_CLICK, false);
            return true;
        }
        int n = this.searchField.getX() - this.leftPos;
        int n2 = this.searchField.getY() - this.topPos;
        Objects.requireNonNull(this.getFont());
        if (this.isHovering(n, n2, 89, 9, mouseX, mouseY)) {
            if (mouseButton != 1) return super.mouseClicked(mouseX, mouseY, mouseButton);
            this.searchField.setValue("");
            return true;
        }
        this.searchField.setFocused(false);
        return super.mouseClicked(mouseX, mouseY, mouseButton);
    }

    protected void storageSlotClick(StoredItemStack slotStack, TerminalSyncManager.SlotAction act, boolean mod) {
        ((StorageTerminalMenu)this.menu).sync.sendInteract(slotStack, act, mod);
    }

    public boolean isPullOne(int mouseButton) {
        switch (this.ctrlm().ordinal()) {
            case 0: {
                return mouseButton == 1 && AbstractStorageTerminalScreen.hasShiftDown();
            }
            case 1: {
                return mouseButton == 2;
            }
            case 2: {
                return mouseButton == 1 && !((StorageTerminalMenu)this.menu).getCarried().isEmpty();
            }
        }
        return false;
    }

    public boolean isTransferOne(int mouseButton) {
        switch (this.ctrlm().ordinal()) {
            case 0: {
                return AbstractStorageTerminalScreen.hasShiftDown() && AbstractStorageTerminalScreen.hasControlDown();
            }
            case 1: {
                return AbstractStorageTerminalScreen.hasShiftDown() && mouseButton == 2;
            }
            case 2: {
                return mouseButton == 1 && AbstractStorageTerminalScreen.hasShiftDown();
            }
        }
        return false;
    }

    public boolean pullHalf(int mouseButton) {
        switch (this.ctrlm().ordinal()) {
            case 0: {
                return mouseButton == 1;
            }
            case 1: {
                return mouseButton == 1;
            }
            case 2: {
                return mouseButton == 1 && ((StorageTerminalMenu)this.menu).getCarried().isEmpty();
            }
        }
        return false;
    }

    public boolean pullNormal(int mouseButton) {
        switch (this.ctrlm().ordinal()) {
            case 0: 
            case 1: 
            case 2: {
                return mouseButton == 0;
            }
        }
        return false;
    }

    private ControllMode ctrlm() {
        return ControllMode.VALUES[this.controllMode];
    }

    public Font getFont() {
        return this.font;
    }

    public boolean keyPressed(int pKeyCode, int pScanCode, int pModifiers) {
        if (this.popup.keyPressed(pKeyCode, pScanCode, pModifiers)) {
            return true;
        }
        if (pKeyCode == 256) {
            this.onClose();
            return true;
        }
        if (pKeyCode == 258) {
            return super.keyPressed(pKeyCode, pScanCode, pModifiers);
        }
        if (this.searchField.keyPressed(pKeyCode, pScanCode, pModifiers) || this.searchField.canConsumeInput()) {
            return true;
        }
        return super.keyPressed(pKeyCode, pScanCode, pModifiers);
    }

    public boolean charTyped(char pCodePoint, int pModifiers) {
        if (this.popup.charTyped(pCodePoint, pModifiers)) {
            return true;
        }
        if (this.searchField.charTyped(pCodePoint, pModifiers)) {
            return true;
        }
        return super.charTyped(pCodePoint, pModifiers);
    }

    @Override
    public boolean mouseScrolled(double p_mouseScrolled_1_, double p_mouseScrolled_3_, double xd, double p_mouseScrolled_5_) {
        if (!this.needsScrollBars()) {
            return false;
        }
        int i = (((StorageTerminalMenu)this.menu).itemListClientSorted.size() + 9 - 1) / 9 - 5;
        this.currentScroll = (float)((double)this.currentScroll - p_mouseScrolled_5_ / (double)i);
        this.currentScroll = Mth.clamp((float)this.currentScroll, (float)0.0f, (float)1.0f);
        ((StorageTerminalMenu)this.menu).scrollTo(this.currentScroll);
        return true;
    }

    public abstract ResourceLocation getGui();

    protected void renderBg(GuiGraphics st, float partialTicks, int mouseX, int mouseY) {
        if (this.tallMode) {
            st.blit(RenderType::guiTextured, this.getGui(), this.leftPos, this.topPos, 0.0f, 0.0f, this.imageWidth, this.slotStartY, 256, 256);
            int guiStart = this.textureSlotCount * 18 + this.slotStartY;
            int guiRStart = this.rowCount * 18 + this.slotStartY;
            int guiSize = this.guiHeight - this.textureSlotCount * 18 - this.slotStartY;
            st.blit(RenderType::guiTextured, this.getGui(), this.leftPos, this.topPos + guiRStart, 0.0f, (float)guiStart, this.imageWidth, guiSize, 256, 256);
            int scrollbarW = 25;
            st.blit(RenderType::guiTextured, this.getGui(), this.leftPos, this.topPos + this.slotStartY, 0.0f, (float)this.slotStartY, this.slotStartX + 162 + scrollbarW, 18, 256, 256);
            for (int i = 1; i < this.rowCount - 1; ++i) {
                st.blit(RenderType::guiTextured, this.getGui(), this.leftPos, this.topPos + this.slotStartY + i * 18, 0.0f, (float)(this.slotStartY + 18), this.slotStartX + 162 + scrollbarW, 18, 256, 256);
            }
            st.blit(RenderType::guiTextured, this.getGui(), this.leftPos, this.topPos + this.slotStartY + (this.rowCount - 1) * 18, 0.0f, (float)(this.slotStartY + (this.textureSlotCount - 1) * 18), this.slotStartX + 162 + scrollbarW, 18, 256, 256);
        } else {
            st.blit(RenderType::guiTextured, this.getGui(), this.leftPos, this.topPos, 0.0f, 0.0f, this.imageWidth, this.imageHeight, 256, 256);
        }
        Slot offh = ((StorageTerminalMenu)this.getMenu()).offhand;
        st.blitSprite(RenderType::guiTextured, FLOATING_SLOT, this.leftPos + offh.x - 8, this.topPos + offh.y - 8, 32, 32);
    }

    protected void onUpdateSearch(String text) {
    }

    @Override
    public void receive(CompoundTag tag) {
        ((StorageTerminalMenu)this.menu).receiveClientNBTPacket(tag);
        this.refreshItemList = true;
    }

    public Slot getSlotUnderMouse() {
        Slot s = super.getSlotUnderMouse();
        if (s != null) {
            return s;
        }
        if (this.slotIDUnderMouse > -1 && ((StorageTerminalMenu)this.getMenu()).getSlotByID((int)this.slotIDUnderMouse).stack != null) {
            this.fakeSlotUnderMouse.container.setItem(0, ((StorageTerminalMenu)this.getMenu()).getSlotByID((int)this.slotIDUnderMouse).stack.getStack());
            return this.fakeSlotUnderMouse;
        }
        return null;
    }

    public int getRowCount() {
        return this.rowCount;
    }

    public boolean isSmartItemSearchOn() {
        return (this.buttonSearchType.getSearchType() & 8) == 0;
    }

    @Override
    public void getExclusionAreas(Consumer<IScreen.Box> consumer) {
        consumer.accept(new IScreen.Box(this.leftPos - 30, this.topPos, 30, this.imageHeight));
    }

    private static class FakeSlot
    extends Slot {
        private static final Container DUMMY = new SimpleContainer(1);

        public FakeSlot() {
            super(DUMMY, 0, Integer.MIN_VALUE, Integer.MIN_VALUE);
        }

        public boolean allowModification(Player p_150652_) {
            return false;
        }

        public void set(ItemStack p_40240_) {
        }

        public ItemStack remove(int p_40227_) {
            return ItemStack.EMPTY;
        }
    }

    public static enum ControllMode {
        AE,
        RS,
        DEF;

        public static final ControllMode[] VALUES;

        static {
            VALUES = ControllMode.values();
        }
    }
}

