/*
 * Decompiled with CFR 0.152.
 */
package com.tom.storagemod.screen;

import com.tom.storagemod.menu.CraftingTerminalMenu;
import com.tom.storagemod.screen.AbstractStorageTerminalScreen;
import com.tom.storagemod.screen.RecipeBookButton;
import com.tom.storagemod.screen.widget.CraftingTerminalRecipeBookWidget;
import com.tom.storagemod.screen.widget.ToggleButton;
import com.tom.storagemod.util.IAutoFillTerminal;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.ImageButton;
import net.minecraft.client.gui.components.Tooltip;
import net.minecraft.client.gui.components.WidgetSprites;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.recipebook.GhostSlots;
import net.minecraft.client.gui.screens.recipebook.RecipeUpdateListener;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.ClickType;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.display.RecipeDisplay;

public class CraftingTerminalScreen
extends AbstractStorageTerminalScreen<CraftingTerminalMenu>
implements RecipeUpdateListener {
    private static final ResourceLocation gui = ResourceLocation.tryBuild((String)"toms_storage", (String)"textures/gui/crafting_terminal.png");
    private final CraftingTerminalRecipeBookWidget recipeBookGui;
    private boolean widthTooNarrow;
    private ToggleButton buttonPullFromInv;
    private ButtonClear btnClr;

    public CraftingTerminalScreen(CraftingTerminalMenu screenContainer, Inventory inv, Component titleIn) {
        super(screenContainer, inv, titleIn, 5, 256, 7, 17);
        this.recipeBookGui = new CraftingTerminalRecipeBookWidget(screenContainer);
    }

    @Override
    public ResourceLocation getGui() {
        return gui;
    }

    @Override
    protected void onUpdateSearch(String text) {
        if (IAutoFillTerminal.hasSync() || (this.buttonSearchType.getSearchType() & 4) > 0) {
            if (this.recipeBookGui.searchBox != null) {
                this.recipeBookGui.searchBox.setValue(text);
            }
            this.recipeBookGui.recipesUpdated();
        }
    }

    @Override
    protected void init() {
        this.imageWidth = 194;
        this.imageHeight = 256;
        super.init();
        boolean bl = this.widthTooNarrow = this.width < 379;
        if (this.recipeBookGui.isVisible()) {
            this.recipeBookGui.toggleVisibility();
        }
        this.recipeBookGui.init(this.width, this.height, this.minecraft, this.widthTooNarrow);
        this.leftPos = this.recipeBookGui.updateScreenPosition(this.width, this.imageWidth - 16);
        this.addWidget((GuiEventListener)this.recipeBookGui);
        this.setInitialFocus((GuiEventListener)this.recipeBookGui);
        this.btnClr = new ButtonClear(this.leftPos + 80, this.topPos + 20 + this.rowCount * 18, b -> this.clearGrid());
        this.addRenderableWidget((GuiEventListener)this.btnClr);
        this.buttonPullFromInv = (ToggleButton)this.addRenderableWidget((GuiEventListener)ToggleButton.builder(this.leftPos - 18, this.topPos + 5 + 108).iconOff(ResourceLocation.tryBuild((String)"toms_storage", (String)"icons/refill_off")).iconOn(ResourceLocation.tryBuild((String)"toms_storage", (String)"icons/refill_on")).build(s -> {
            this.buttonPullFromInv.setState(s);
            this.sendUpdate();
        }));
        this.buttonPullFromInv.setTooltip(Tooltip.create((Component)Component.translatable((String)"tooltip.toms_storage.crafting_pull_off")), Tooltip.create((Component)Component.translatable((String)"tooltip.toms_storage.crafting_pull_on")));
        this.addRenderableWidget((GuiEventListener)new RecipeBookButton(this.leftPos + 4, this.topPos + 38 + this.rowCount * 18, p_214076_1_ -> {
            this.recipeBookGui.toggleVisibility();
            this.leftPos = this.recipeBookGui.updateScreenPosition(this.width, this.imageWidth - 16);
            ((ImageButton)p_214076_1_).setPosition(this.leftPos + 4, this.topPos + 38 + this.rowCount * 18);
            this.setButtonsPos();
        }));
        this.setButtonsPos();
        this.onPacket();
    }

    private void setButtonsPos() {
        this.searchField.setX(this.leftPos + 82);
        this.btnClr.setX(this.leftPos + 80);
        int space = this.recipeBookGui.isVisible() ? this.recipeBookGui.searchBox.getY() - 16 : this.imageHeight;
        List<Button> buttons = Arrays.asList(new Button[]{this.buttonSortingType, this.buttonDirection, this.buttonSearchType, this.buttonCtrlMode, this.buttonGhostMode, this.buttonPullFromInv, this.buttonTallMode});
        int y = this.topPos + 5;
        int x = this.leftPos - 18;
        for (int i = 0; i < buttons.size(); ++i) {
            Button b = buttons.get(i);
            if (y + 18 > space) {
                y = this.topPos + 5;
                x -= 18;
            }
            b.setX(x);
            b.setY(y);
            y += 18;
        }
    }

    @Override
    protected void onPacket() {
        super.onPacket();
        boolean pullFromInv = (((CraftingTerminalMenu)this.menu).modes & 0x20) != 0;
        this.buttonPullFromInv.setState(pullFromInv);
    }

    @Override
    protected int writeModes() {
        int d = super.writeModes();
        return d |= this.buttonPullFromInv.getState() ? 32 : 0;
    }

    @Override
    public void containerTick() {
        super.containerTick();
        this.recipeBookGui.tick();
    }

    @Override
    public void render(GuiGraphics st, int mouseX, int mouseY, float partialTicks) {
        if (this.recipeBookGui.isVisible() && this.widthTooNarrow) {
            st.pose().pushPose();
            st.pose().translate(0.0f, 0.0f, -1000.0f);
            super.render(st, -1, -1, partialTicks);
            st.pose().popPose();
            this.recipeBookGui.render(st, mouseX, mouseY, partialTicks);
        } else {
            super.render(st, mouseX, mouseY, partialTicks);
            this.recipeBookGui.render(st, mouseX, mouseY, partialTicks);
        }
        this.renderTooltip(st, mouseX, mouseY);
        this.recipeBookGui.renderTooltip(st, mouseX, mouseY, this.hoveredSlot);
        this.setInitialFocus((GuiEventListener)this.recipeBookGui);
    }

    protected void renderSlots(GuiGraphics p_376566_) {
        super.renderSlots(p_376566_);
        this.recipeBookGui.renderGhostRecipe(p_376566_, true);
    }

    protected boolean isHovering(int x, int y, int width, int height, double mouseX, double mouseY) {
        return (!this.widthTooNarrow || !this.recipeBookGui.isVisible()) && super.isHovering(x, y, width, height, mouseX, mouseY);
    }

    @Override
    public boolean mouseClicked(double x, double y, int b) {
        if (this.recipeBookGui.mouseClicked(x, y, b)) {
            this.setFocused((GuiEventListener)this.recipeBookGui);
            return true;
        }
        if (this.widthTooNarrow && this.recipeBookGui.isVisible()) {
            if (this.recipeBookGui.hasClickedOutside(x, y, this.leftPos, this.topPos, this.imageWidth, this.imageHeight, b)) {
                this.recipeBookGui.toggleVisibility();
            }
            return false;
        }
        return super.mouseClicked(x, y, b);
    }

    protected boolean hasClickedOutside(double mouseX, double mouseY, int guiLeftIn, int guiTopIn, int mouseButton) {
        boolean flag = mouseX < (double)guiLeftIn || mouseY < (double)guiTopIn || mouseX >= (double)(guiLeftIn + this.imageWidth) || mouseY >= (double)(guiTopIn + this.imageHeight);
        return this.recipeBookGui.hasClickedOutside(mouseX, mouseY, this.leftPos, this.topPos, this.imageWidth, this.imageHeight, mouseButton) && flag;
    }

    protected void slotClicked(Slot slotIn, int slotId, int mouseButton, ClickType type) {
        super.slotClicked(slotIn, slotId, mouseButton, type);
        this.recipeBookGui.slotClicked(slotIn);
    }

    public void recipesUpdated() {
        this.recipeBookGui.recipesUpdated();
    }

    private void clearGrid() {
        this.minecraft.gameMode.handleInventoryButtonClick(((CraftingTerminalMenu)this.menu).containerId, 0);
    }

    @Override
    public boolean keyPressed(int code, int p_231046_2_, int p_231046_3_) {
        if (code == 83 && this.hoveredSlot != null) {
            ItemStack itemstack = null;
            for (Map.Entry e : this.recipeBookGui.ghostSlots.ingredients.entrySet()) {
                if (e.getKey() != this.hoveredSlot) continue;
                itemstack = ((GhostSlots.GhostSlot)e.getValue()).getItem(this.recipeBookGui.ghostSlots.slotSelectTime.currentIndex());
                break;
            }
            if (itemstack != null) {
                this.searchField.setValue(itemstack.getHoverName().getString());
                this.searchField.setFocused(false);
                return true;
            }
        }
        if (code == 256 && this.recipeBookGui.isVisible() && this.widthTooNarrow) {
            this.recipeBookGui.toggleVisibility();
            return true;
        }
        return super.keyPressed(code, p_231046_2_, p_231046_3_);
    }

    public void fillGhostRecipe(RecipeDisplay recipeDisplay) {
        this.recipeBookGui.fillGhostRecipe(recipeDisplay);
    }

    public static class ButtonClear
    extends Button {
        private static final WidgetSprites SPRITES = new WidgetSprites(ResourceLocation.tryBuild((String)"toms_storage", (String)"widget/clear_button"), ResourceLocation.tryBuild((String)"toms_storage", (String)"widget/clear_button_disabled"), ResourceLocation.tryBuild((String)"toms_storage", (String)"widget/clear_button_hovered"));

        public ButtonClear(int x, int y, Button.OnPress pressable) {
            super(x, y, 11, 11, (Component)Component.empty(), pressable, DEFAULT_NARRATION);
        }

        public void renderWidget(GuiGraphics st, int mouseX, int mouseY, float pt) {
            if (this.visible) {
                int x = this.getX();
                int y = this.getY();
                this.isHovered = mouseX >= x && mouseY >= y && mouseX < x + this.width && mouseY < y + this.height;
                st.blitSprite(RenderType::guiTextured, SPRITES.get(this.active, this.isHoveredOrFocused()), x, y, this.width, this.height);
            }
        }
    }
}

