/*
 * Decompiled with CFR 0.152.
 */
package com.tom.storagemod.screen.widget;

import com.tom.storagemod.menu.CraftingTerminalMenu;
import java.lang.runtime.SwitchBootstraps;
import java.util.List;
import java.util.Objects;
import net.minecraft.client.gui.components.WidgetSprites;
import net.minecraft.client.gui.screens.recipebook.GhostSlots;
import net.minecraft.client.gui.screens.recipebook.RecipeBookComponent;
import net.minecraft.client.gui.screens.recipebook.RecipeCollection;
import net.minecraft.client.gui.screens.recipebook.SearchRecipeBookCategory;
import net.minecraft.network.chat.Component;
import net.minecraft.recipebook.PlaceRecipeHelper;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.context.ContextMap;
import net.minecraft.world.entity.player.StackedItemContents;
import net.minecraft.world.inventory.RecipeBookMenu;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.RecipeBookCategories;
import net.minecraft.world.item.crafting.display.RecipeDisplay;
import net.minecraft.world.item.crafting.display.ShapedCraftingRecipeDisplay;
import net.minecraft.world.item.crafting.display.ShapelessCraftingRecipeDisplay;
import net.minecraft.world.item.crafting.display.SlotDisplay;

public class CraftingTerminalRecipeBookWidget
extends RecipeBookComponent<CraftingTerminalMenu> {
    private static final WidgetSprites FILTER_BUTTON_SPRITES = new WidgetSprites(ResourceLocation.withDefaultNamespace((String)"recipe_book/filter_enabled"), ResourceLocation.withDefaultNamespace((String)"recipe_book/filter_disabled"), ResourceLocation.withDefaultNamespace((String)"recipe_book/filter_enabled_highlighted"), ResourceLocation.withDefaultNamespace((String)"recipe_book/filter_disabled_highlighted"));
    private static final Component ONLY_CRAFTABLES_TOOLTIP = Component.translatable((String)"gui.recipebook.toggleRecipes.craftable");
    private static final List<RecipeBookComponent.TabInfo> TABS = List.of(new RecipeBookComponent.TabInfo(SearchRecipeBookCategory.CRAFTING), new RecipeBookComponent.TabInfo(Items.IRON_AXE, Items.GOLDEN_SWORD, RecipeBookCategories.CRAFTING_EQUIPMENT), new RecipeBookComponent.TabInfo(Items.BRICKS, RecipeBookCategories.CRAFTING_BUILDING_BLOCKS), new RecipeBookComponent.TabInfo(Items.LAVA_BUCKET, Items.APPLE, RecipeBookCategories.CRAFTING_MISC), new RecipeBookComponent.TabInfo(Items.REDSTONE, RecipeBookCategories.CRAFTING_REDSTONE));

    private boolean canDisplay(RecipeDisplay recipeDisplay) {
        int i = 3;
        int j = 3;
        Objects.requireNonNull(recipeDisplay);
        RecipeDisplay recipeDisplay2 = recipeDisplay;
        Objects.requireNonNull(recipeDisplay2);
        RecipeDisplay recipeDisplay3 = recipeDisplay2;
        int n = 0;
        return switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{ShapedCraftingRecipeDisplay.class, ShapelessCraftingRecipeDisplay.class}, (Object)recipeDisplay3, n)) {
            case 0 -> {
                ShapedCraftingRecipeDisplay shapedCraftingRecipeDisplay = (ShapedCraftingRecipeDisplay)recipeDisplay3;
                if (i >= shapedCraftingRecipeDisplay.width() && j >= shapedCraftingRecipeDisplay.height()) {
                    yield true;
                }
                yield false;
            }
            case 1 -> {
                ShapelessCraftingRecipeDisplay shapelessCraftingRecipeDisplay = (ShapelessCraftingRecipeDisplay)recipeDisplay3;
                if (i * j >= shapelessCraftingRecipeDisplay.ingredients().size()) {
                    yield true;
                }
                yield false;
            }
            default -> false;
        };
    }

    public CraftingTerminalRecipeBookWidget(CraftingTerminalMenu recipeBookMenu) {
        super((RecipeBookMenu)recipeBookMenu, TABS);
    }

    protected void initFilterButtonTextures() {
        this.filterButton.initTextureValues(FILTER_BUTTON_SPRITES);
    }

    protected boolean isCraftingSlot(Slot slot) {
        return slot.index < 10;
    }

    protected void selectMatchingRecipes(RecipeCollection recipeCollection, StackedItemContents stackedItemContents) {
        recipeCollection.selectRecipes(stackedItemContents, this::canDisplay);
    }

    protected Component getRecipeFilterName() {
        return ONLY_CRAFTABLES_TOOLTIP;
    }

    protected void fillGhostRecipe(GhostSlots ghostSlots, RecipeDisplay recipeDisplay, ContextMap contextMap) {
        ghostSlots.setResult(((CraftingTerminalMenu)this.menu).getCraftingResultSlot(), contextMap, recipeDisplay.result());
        Objects.requireNonNull(recipeDisplay);
        RecipeDisplay recipeDisplay2 = recipeDisplay;
        Objects.requireNonNull(recipeDisplay2);
        RecipeDisplay recipeDisplay3 = recipeDisplay2;
        int n = 0;
        switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{ShapedCraftingRecipeDisplay.class, ShapelessCraftingRecipeDisplay.class}, (Object)recipeDisplay3, n)) {
            case 0: {
                ShapedCraftingRecipeDisplay shapedCraftingRecipeDisplay = (ShapedCraftingRecipeDisplay)recipeDisplay3;
                List<Slot> list = ((CraftingTerminalMenu)this.menu).getInputGridSlots();
                PlaceRecipeHelper.placeRecipe((int)3, (int)3, (int)shapedCraftingRecipeDisplay.width(), (int)shapedCraftingRecipeDisplay.height(), (Iterable)shapedCraftingRecipeDisplay.ingredients(), (slotDisplay, ix, jx, k) -> {
                    Slot slot = (Slot)list.get(ix);
                    ghostSlots.setInput(slot, contextMap, slotDisplay);
                });
                break;
            }
            case 1: {
                ShapelessCraftingRecipeDisplay shapelessCraftingRecipeDisplay = (ShapelessCraftingRecipeDisplay)recipeDisplay3;
                List<Slot> list2 = ((CraftingTerminalMenu)this.menu).getInputGridSlots();
                int i = Math.min(shapelessCraftingRecipeDisplay.ingredients().size(), list2.size());
                for (int j = 0; j < i; ++j) {
                    ghostSlots.setInput(list2.get(j), contextMap, (SlotDisplay)shapelessCraftingRecipeDisplay.ingredients().get(j));
                }
                break;
            }
        }
    }
}

