/*
 * Decompiled with CFR 0.152.
 */
package com.tom.storagemod;

import com.tom.storagemod.Config;
import com.tom.storagemod.Content;
import com.tom.storagemod.StorageModClient;
import com.tom.storagemod.api.MultiblockInventoryAPI;
import com.tom.storagemod.inventory.IInventoryAccess;
import com.tom.storagemod.inventory.PlatformItemHandler;
import com.tom.storagemod.inventory.VanillaMultiblockInventories;
import com.tom.storagemod.network.NetworkHandler;
import com.tom.storagemod.platform.Platform;
import net.minecraft.world.Container;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.fml.InterModComms;
import net.neoforged.fml.ModContainer;
import net.neoforged.fml.ModList;
import net.neoforged.fml.common.Mod;
import net.neoforged.fml.config.IConfigSpec;
import net.neoforged.fml.config.ModConfig;
import net.neoforged.fml.event.lifecycle.FMLClientSetupEvent;
import net.neoforged.fml.event.lifecycle.FMLCommonSetupEvent;
import net.neoforged.fml.event.lifecycle.InterModEnqueueEvent;
import net.neoforged.fml.loading.FMLEnvironment;
import net.neoforged.neoforge.capabilities.Capabilities;
import net.neoforged.neoforge.capabilities.RegisterCapabilitiesEvent;
import net.neoforged.neoforge.items.wrapper.InvWrapper;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Mod(value="toms_storage")
public class StorageMod {
    public static final String modid = "toms_storage";
    public static final Logger LOGGER = LogManager.getLogger();
    public static boolean polymorph;

    public StorageMod(ModContainer mc, IEventBus bus) {
        bus.addListener(this::setup);
        bus.addListener(this::doClientStuff);
        if (FMLEnvironment.dist == Dist.CLIENT) {
            StorageModClient.preInit(mc, bus);
        }
        bus.addListener(this::registerCapabilities);
        bus.addListener(this::enqueueIMC);
        mc.registerConfig(ModConfig.Type.COMMON, (IConfigSpec)Config.commonSpec);
        mc.registerConfig(ModConfig.Type.SERVER, (IConfigSpec)Config.serverSpec);
        bus.register((Object)Config.get());
        bus.register(NetworkHandler.class);
        Content.init();
        Platform.register(bus);
        polymorph = ModList.get().isLoaded("polymorph");
    }

    private void setup(FMLCommonSetupEvent event) {
        LOGGER.info("Tom's Storage Setup starting");
        MultiblockInventoryAPI.EVENT.register(VanillaMultiblockInventories::checkChest);
    }

    private void doClientStuff(FMLClientSetupEvent event) {
        StorageModClient.clientSetup();
    }

    private void registerCapabilities(RegisterCapabilitiesEvent event) {
        event.registerBlockEntity(Capabilities.ItemHandler.BLOCK, (BlockEntityType)Content.openCrateBE.get(), (be, side) -> new InvWrapper((Container)be));
        event.registerBlockEntity(Capabilities.ItemHandler.BLOCK, (BlockEntityType)Content.connectorBE.get(), (be, side) -> new PlatformItemHandler((IInventoryAccess.IInventory)be));
        event.registerBlockEntity(Capabilities.ItemHandler.BLOCK, (BlockEntityType)Content.invInterfaceBE.get(), (be, side) -> new PlatformItemHandler((IInventoryAccess.IInventory)be));
        event.registerBlockEntity(Capabilities.ItemHandler.BLOCK, (BlockEntityType)Content.filingCabinetBE.get(), (be, side) -> new InvWrapper(be.getInv()));
        event.registerBlockEntity(Capabilities.ItemHandler.BLOCK, (BlockEntityType)Content.invProxyBE.get(), (be, side) -> new PlatformItemHandler((IInventoryAccess.IInventory)be));
    }

    public void enqueueIMC(InterModEnqueueEvent e) {
        if (ModList.get().isLoaded("theoneprobe")) {
            InterModComms.sendTo((String)"theoneprobe", (String)"getTheOneProbe", () -> {
                try {
                    return Class.forName("com.tom.storagemod.top.TheOneProbeHandler").getConstructor(new Class[0]).newInstance(new Object[0]);
                }
                catch (Throwable e1) {
                    LOGGER.warn("Failed to init TheOneProbeHandler", e1);
                    return null;
                }
            });
        }
    }
}

