/*
 * Decompiled with CFR 0.152.
 */
package com.tom.storagemod.block;

import com.tom.storagemod.block.IInventoryCable;
import com.tom.storagemod.client.ClientUtil;
import com.tom.storagemod.util.BlockFace;
import com.tom.storagemod.util.TickerUtil;
import java.util.Collections;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.BaseEntityBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.redstone.Orientation;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;

public abstract class AbstractInventoryHopperBlock
extends BaseEntityBlock
implements IInventoryCable {
    public static final EnumProperty<Direction> FACING = BlockStateProperties.FACING;
    public static final BooleanProperty ENABLED = BlockStateProperties.ENABLED;

    protected AbstractInventoryHopperBlock(BlockBehaviour.Properties p_49224_) {
        super(p_49224_);
        this.registerDefaultState((BlockState)((BlockState)this.defaultBlockState().setValue(FACING, (Comparable)Direction.DOWN)).setValue((Property)ENABLED, (Comparable)Boolean.valueOf(true)));
    }

    public void appendHoverText(ItemStack itemStack, Item.TooltipContext tooltipContext, List<Component> tooltip, TooltipFlag tooltipFlag) {
        ClientUtil.tooltip("inventory_hopper", tooltip, new Object[0]);
    }

    public <T extends BlockEntity> BlockEntityTicker<T> getTicker(Level world, BlockState state, BlockEntityType<T> type) {
        return TickerUtil.createTicker(world, false, true);
    }

    public BlockState rotate(BlockState state, Rotation rot) {
        return (BlockState)state.setValue(FACING, (Comparable)rot.rotate((Direction)state.getValue(FACING)));
    }

    public BlockState mirror(BlockState state, Mirror mirrorIn) {
        return state.rotate(mirrorIn.getRotation((Direction)state.getValue(FACING)));
    }

    public BlockState getStateForPlacement(BlockPlaceContext context) {
        return (BlockState)this.defaultBlockState().setValue(FACING, (Comparable)context.getClickedFace().getOpposite());
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{FACING, ENABLED});
    }

    public RenderShape getRenderShape(BlockState p_149645_1_) {
        return RenderShape.MODEL;
    }

    @Override
    public List<BlockFace> nextScan(Level world, BlockState state, BlockPos pos) {
        return Collections.emptyList();
    }

    @Override
    public boolean canConnectFrom(BlockState state, Direction dir) {
        return ((Direction)state.getValue(FACING)).getAxis() == dir.getAxis();
    }

    public VoxelShape getShape(BlockState state, BlockGetter worldIn, BlockPos pos, CollisionContext context) {
        switch ((Direction)state.getValue(FACING)) {
            case DOWN: {
                return Shapes.or((VoxelShape)AbstractInventoryHopperBlock.box((double)5.0, (double)0.0, (double)5.0, (double)11.0, (double)6.0, (double)11.0), (VoxelShape)AbstractInventoryHopperBlock.box((double)3.0, (double)6.0, (double)3.0, (double)13.0, (double)16.0, (double)13.0));
            }
            case EAST: {
                return Shapes.or((VoxelShape)AbstractInventoryHopperBlock.box((double)10.0, (double)5.0, (double)5.0, (double)16.0, (double)11.0, (double)11.0), (VoxelShape)AbstractInventoryHopperBlock.box((double)0.0, (double)3.0, (double)3.0, (double)10.0, (double)13.0, (double)13.0));
            }
            case NORTH: {
                return Shapes.or((VoxelShape)AbstractInventoryHopperBlock.box((double)5.0, (double)5.0, (double)0.0, (double)11.0, (double)11.0, (double)6.0), (VoxelShape)AbstractInventoryHopperBlock.box((double)3.0, (double)3.0, (double)6.0, (double)13.0, (double)13.0, (double)16.0));
            }
            case SOUTH: {
                return Shapes.or((VoxelShape)AbstractInventoryHopperBlock.box((double)5.0, (double)5.0, (double)10.0, (double)11.0, (double)11.0, (double)16.0), (VoxelShape)AbstractInventoryHopperBlock.box((double)3.0, (double)3.0, (double)0.0, (double)13.0, (double)13.0, (double)10.0));
            }
            case UP: {
                return Shapes.or((VoxelShape)AbstractInventoryHopperBlock.box((double)5.0, (double)10.0, (double)5.0, (double)11.0, (double)16.0, (double)11.0), (VoxelShape)AbstractInventoryHopperBlock.box((double)3.0, (double)0.0, (double)3.0, (double)13.0, (double)10.0, (double)13.0));
            }
            case WEST: {
                return Shapes.or((VoxelShape)AbstractInventoryHopperBlock.box((double)0.0, (double)5.0, (double)5.0, (double)6.0, (double)11.0, (double)11.0), (VoxelShape)AbstractInventoryHopperBlock.box((double)6.0, (double)3.0, (double)3.0, (double)16.0, (double)13.0, (double)13.0));
            }
        }
        return Shapes.block();
    }

    public void onPlace(BlockState p_54110_, Level p_54111_, BlockPos p_54112_, BlockState p_54113_, boolean p_54114_) {
        if (!p_54113_.is(p_54110_.getBlock())) {
            this.updateState(p_54111_, p_54112_, p_54110_);
        }
    }

    protected void neighborChanged(BlockState blockState, Level level, BlockPos blockPos, Block block, Orientation orientation, boolean bl) {
        this.updateState(level, blockPos, blockState);
    }

    private void updateState(Level worldIn, BlockPos pos, BlockState state) {
        boolean flag;
        boolean bl = flag = !worldIn.hasNeighborSignal(pos);
        if (flag != (Boolean)state.getValue((Property)ENABLED)) {
            worldIn.setBlock(pos, (BlockState)state.setValue((Property)ENABLED, (Comparable)Boolean.valueOf(flag)), 4);
        }
    }
}

