/*
 * Decompiled with CFR 0.152.
 */
package com.tom.storagemod.block;

import com.mojang.serialization.MapCodec;
import com.tom.storagemod.Content;
import com.tom.storagemod.block.IConfiguratorHighlight;
import com.tom.storagemod.block.IPaintable;
import com.tom.storagemod.block.entity.PaintedBlockEntity;
import com.tom.storagemod.client.ClientUtil;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.BaseEntityBlock;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;

public class PaintedTrimBlock
extends BaseEntityBlock
implements IPaintable,
IConfiguratorHighlight {
    public static final MapCodec<PaintedTrimBlock> CODEC = PaintedTrimBlock.simpleCodec(PaintedTrimBlock::new);

    public PaintedTrimBlock(BlockBehaviour.Properties pr) {
        super(pr);
    }

    public void appendHoverText(ItemStack itemStack, Item.TooltipContext tooltipContext, List<Component> tooltip, TooltipFlag tooltipFlag) {
        tooltip.add((Component)Component.translatable((String)"tooltip.toms_storage.paintable"));
        ClientUtil.tooltip("trim", tooltip, new Object[0]);
    }

    @Override
    public boolean paint(Level world, BlockPos pos, BlockState to) {
        BlockEntity te = world.getBlockEntity(pos);
        if (te != null && te instanceof PaintedBlockEntity) {
            return ((PaintedBlockEntity)te).setPaintedBlockState(to);
        }
        return false;
    }

    public BlockEntity newBlockEntity(BlockPos pos, BlockState state) {
        return new PaintedBlockEntity(pos, state);
    }

    public RenderShape getRenderShape(BlockState p_149645_1_) {
        return RenderShape.MODEL;
    }

    protected ItemStack getCloneItemStack(LevelReader p_382795_, BlockPos p_383120_, BlockState p_382830_, boolean p_388788_) {
        return new ItemStack((ItemLike)Content.inventoryTrim.get());
    }

    protected MapCodec<? extends BaseEntityBlock> codec() {
        return CODEC;
    }

    @Override
    public int getHighlightColor() {
        return 0x888888;
    }

    @Override
    public VoxelShape getHighlightShape(BlockState state, BlockGetter level, BlockPos pos) {
        return Shapes.block();
    }
}

