/*
 * Decompiled with CFR 0.152.
 */
package com.tom.storagemod.block.entity;

import com.tom.storagemod.Content;
import com.tom.storagemod.block.entity.IInventoryConnector;
import com.tom.storagemod.inventory.IInventoryAccess;
import com.tom.storagemod.inventory.IInventoryConnectorReference;
import com.tom.storagemod.inventory.InventoryCableNetwork;
import com.tom.storagemod.inventory.PlatformInventoryAccess;
import com.tom.storagemod.platform.PlatformBlockEntity;
import com.tom.storagemod.util.TickerUtil;
import java.lang.ref.WeakReference;
import java.util.Collection;
import net.minecraft.core.BlockPos;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;

public class InventoryInterfaceBlockEntity
extends PlatformBlockEntity
implements TickerUtil.TickableServer,
IInventoryAccess.IInventory,
IInventoryConnectorReference {
    private WeakReference<IInventoryConnector> networkAccess;
    private WeakReference<IInventoryConnector> connectorAccess;
    private boolean hasConnector;

    public InventoryInterfaceBlockEntity(BlockPos p_155229_, BlockState p_155230_) {
        super((BlockEntityType)Content.invInterfaceBE.get(), p_155229_, p_155230_);
    }

    @Override
    public void updateServer() {
        long time = this.level.getGameTime();
        if (time % 20L == (long)(Math.abs(this.worldPosition.hashCode()) % 20)) {
            if (this.hasConnector) {
                this.hasConnector = false;
            } else {
                this.connectorAccess = null;
            }
            if (this.connectorAccess != null) {
                this.networkAccess = this.connectorAccess;
            } else {
                this.networkAccess = null;
                Collection<BlockPos> netBlocks = InventoryCableNetwork.getNetwork(this.level).getNetworkNodes(this.worldPosition);
                for (BlockPos p : netBlocks) {
                    IInventoryConnector te;
                    BlockEntity be;
                    if (!this.level.isLoaded(p) || !((be = this.level.getBlockEntity(p)) instanceof IInventoryConnector) || !(te = (IInventoryConnector)be).hasConnectedInventories()) continue;
                    this.networkAccess = new WeakReference<IInventoryConnector>(te);
                    break;
                }
            }
        }
    }

    @Override
    public IInventoryAccess getInventoryAccess() {
        IInventoryConnector net;
        if (this.networkAccess != null && (net = (IInventoryConnector)this.networkAccess.get()) != null && net.hasConnectedInventories()) {
            return net.getMergedHandler();
        }
        return PlatformInventoryAccess.EMPTY;
    }

    @Override
    public IInventoryConnector getConnectorRef() {
        IInventoryConnector net;
        if (this.networkAccess != null && (net = (IInventoryConnector)this.networkAccess.get()) != null && net.hasConnectedInventories()) {
            return net;
        }
        return null;
    }

    public void setConnectorAccess(IInventoryConnector connectorAccess) {
        this.connectorAccess = new WeakReference<IInventoryConnector>(connectorAccess);
        this.hasConnector = true;
    }
}

