/*
 * Decompiled with CFR 0.152.
 */
package com.tom.storagemod.inventory;

import com.tom.storagemod.inventory.IInventoryAccess;
import com.tom.storagemod.inventory.InventorySlot;
import com.tom.storagemod.inventory.StoredItemStack;
import com.tom.storagemod.inventory.filter.ItemPredicate;
import java.lang.ref.WeakReference;
import java.util.Arrays;
import java.util.stream.Stream;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.neoforged.neoforge.items.IItemHandler;

public class InventoryChangeTracker
implements IInventoryAccess.IInventoryChangeTracker,
IInventoryAccess.IMultiThreadedTracker<ItemStack[], Long>,
IInventoryAccess.IChangeNotifier {
    public static final InventoryChangeTracker NULL = new InventoryChangeTracker(null);
    private final WeakReference<IItemHandler> itemHandler;
    private long lastUpdate;
    private long lastChange;
    private StoredItemStack[] lastItems = new StoredItemStack[0];

    public InventoryChangeTracker(IItemHandler itemHandler) {
        this.itemHandler = new WeakReference<IItemHandler>(itemHandler);
    }

    @Override
    public long getChangeTracker(Level level) {
        IItemHandler h = (IItemHandler)this.itemHandler.get();
        if (h == null) {
            return 0L;
        }
        if (this.lastUpdate != level.getGameTime()) {
            int slots = h.getSlots();
            if (this.lastItems.length != slots) {
                this.lastItems = new StoredItemStack[slots];
            }
            boolean change = false;
            for (int i = 0; i < slots; ++i) {
                ItemStack is = h.getStackInSlot(i);
                change |= this.updateChange(i, is);
            }
            if (change) {
                this.lastChange = System.nanoTime();
            }
            this.lastUpdate = level.getGameTime();
        }
        return this.lastChange;
    }

    protected boolean checkFilter(ItemStack stack) {
        return this.checkFilter(new StoredItemStack(stack, stack.getCount()));
    }

    protected boolean checkFilter(StoredItemStack stack) {
        return true;
    }

    protected int getCount(ItemStack is) {
        return is.getCount();
    }

    protected IItemHandler getSlotHandler(IItemHandler def) {
        return def;
    }

    private boolean updateChange(int i, ItemStack is) {
        if (!is.isEmpty() && this.checkFilter(is)) {
            int cnt = this.getCount(is);
            if (this.lastItems[i] == null || !ItemStack.isSameItemSameComponents((ItemStack)this.lastItems[i].getStack(), (ItemStack)is)) {
                this.lastItems[i] = new StoredItemStack(is);
                this.lastItems[i].setCount(cnt);
                return true;
            }
            if (this.lastItems[i].getQuantity() != (long)cnt) {
                this.lastItems[i].setCount(cnt);
                return true;
            }
        } else if (this.lastItems[i] != null) {
            this.lastItems[i] = null;
            return true;
        }
        return false;
    }

    @Override
    public Stream<StoredItemStack> streamWrappedStacks(boolean parallel) {
        IItemHandler h = (IItemHandler)this.itemHandler.get();
        if (h == null) {
            return Stream.empty();
        }
        return Arrays.stream(this.lastItems).filter(e -> e != null);
    }

    @Override
    public long countItems(StoredItemStack filter) {
        IItemHandler h = (IItemHandler)this.itemHandler.get();
        if (h == null) {
            return 0L;
        }
        long c = 0L;
        for (int i = 0; i < this.lastItems.length; ++i) {
            StoredItemStack is = this.lastItems[i];
            if (is == null || !is.equalItem(filter)) continue;
            c += is.getQuantity();
        }
        return c;
    }

    @Override
    public InventorySlot findSlot(ItemPredicate filter, boolean findEmpty) {
        IItemHandler h = (IItemHandler)this.itemHandler.get();
        if (h == null) {
            return null;
        }
        for (int i = 0; i < this.lastItems.length; ++i) {
            StoredItemStack is = this.lastItems[i];
            if (!(is == null ? findEmpty : filter.test(is))) continue;
            return new InventorySlot(this.getSlotHandler(h), this, i);
        }
        return null;
    }

    @Override
    public ItemStack[] prepForOffThread(Level level) {
        if (this.lastUpdate == level.getGameTime()) {
            return null;
        }
        IItemHandler h = (IItemHandler)this.itemHandler.get();
        if (h == null) {
            return null;
        }
        int slots = h.getSlots();
        if (this.lastItems.length != slots) {
            this.lastItems = new StoredItemStack[slots];
        }
        ItemStack[] items = new ItemStack[slots];
        for (int i = 0; i < slots; ++i) {
            items[i] = h.getStackInSlot(i);
        }
        return items;
    }

    @Override
    public Long processOffThread(ItemStack[] array) {
        int slots = array.length;
        boolean change = false;
        for (int i = 0; i < slots; ++i) {
            ItemStack is = array[i];
            change |= this.updateChange(i, is);
        }
        if (change) {
            return System.nanoTime();
        }
        return this.lastChange;
    }

    @Override
    public long finishOffThreadProcess(Level level, Long ct) {
        if (ct == null) {
            return this.lastChange;
        }
        this.lastChange = ct;
        this.lastUpdate = level.getGameTime();
        return ct;
    }

    @Override
    public void onSlotChanged(InventorySlot slot) {
        if (this.lastItems.length > slot.getId() && this.updateChange(slot.getId(), slot.getStack())) {
            this.lastChange = System.nanoTime();
        }
    }

    @Override
    public InventorySlot findSlotDest(StoredItemStack forStack) {
        IItemHandler h = (IItemHandler)this.itemHandler.get();
        if (h == null) {
            return null;
        }
        if (!this.checkFilter(forStack)) {
            return null;
        }
        for (int i = 0; i < this.lastItems.length; ++i) {
            int rem;
            StoredItemStack is = this.lastItems[i];
            if (is == null && !h.isItemValid(i, forStack.getStack()) || is != null && !is.equalItem(forStack) || (long)(rem = h.insertItem(i, forStack.getActualStack(), true).getCount()) >= forStack.getQuantity()) continue;
            return new InventorySlot(this.getSlotHandler(h), this, i);
        }
        return null;
    }

    @Override
    public InventorySlot findSlotAfter(InventorySlot slot, ItemPredicate filter, boolean findEmpty, boolean loop) {
        if (slot == null) {
            return this.findSlot(filter, findEmpty);
        }
        IItemHandler h = (IItemHandler)this.itemHandler.get();
        if (h == null || slot.getHandler() != h) {
            return null;
        }
        if (h.getSlots() <= slot.getId() + 1) {
            return loop ? this.findSlot(filter, findEmpty) : null;
        }
        for (int i = slot.getId() + 1; i < this.lastItems.length; ++i) {
            StoredItemStack is = this.lastItems[i];
            if (!(is == null ? findEmpty : filter.test(is))) continue;
            return new InventorySlot(this.getSlotHandler(h), this, i);
        }
        return null;
    }

    @Override
    public InventorySlot findSlotDestAfter(InventorySlot slot, StoredItemStack forStack, boolean loop) {
        if (slot == null) {
            return this.findSlotDest(forStack);
        }
        IItemHandler h = (IItemHandler)this.itemHandler.get();
        if (h == null) {
            return null;
        }
        if (!this.checkFilter(forStack)) {
            return null;
        }
        if (slot.getHandler() != h) {
            return null;
        }
        if (h.getSlots() <= slot.getId() + 1) {
            return loop ? this.findSlotDest(forStack) : null;
        }
        for (int i = slot.getId() + 1; i < this.lastItems.length; ++i) {
            int rem;
            StoredItemStack is = this.lastItems[i];
            if (is == null && !h.isItemValid(i, forStack.getStack()) || is != null && !is.equalItem(forStack) || (long)(rem = h.insertItem(i, forStack.getActualStack(), true).getCount()) >= forStack.getQuantity()) continue;
            return new InventorySlot(this.getSlotHandler(h), this, i);
        }
        return null;
    }
}

