/*
 * Decompiled with CFR 0.152.
 */
package com.tom.storagemod.inventory;

import com.tom.storagemod.block.entity.IInventoryConnector;
import com.tom.storagemod.inventory.IInventoryAccess;
import com.tom.storagemod.inventory.IProxy;
import com.tom.storagemod.inventory.InventoryCableNetwork;
import com.tom.storagemod.inventory.PlatformInventoryAccess;
import com.tom.storagemod.inventory.PlatformItemHandler;
import com.tom.storagemod.util.IValidInfo;
import java.lang.ref.WeakReference;
import java.util.Collection;
import java.util.Collections;
import java.util.IdentityHashMap;
import java.util.Set;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.neoforged.neoforge.items.IItemHandler;

public class NetworkInventory {
    private PlatformInventoryAccess.BlockInventoryAccess block = new PlatformInventoryAccess.BlockInventoryAccess();
    private WeakReference<IInventoryConnector> networkAccess;
    private long lastUpdate;

    public void onLoad(Level level, BlockPos worldPosition, Direction side, IValidInfo v) {
        this.block.onLoad(level, worldPosition, side, v);
    }

    public void scanNetwork(Level level, BlockPos worldPosition) {
        this.networkAccess = null;
        Collection<BlockPos> netBlocks = InventoryCableNetwork.getNetwork(level).getNetworkNodes(worldPosition);
        for (BlockPos p : netBlocks) {
            IInventoryConnector te;
            BlockEntity be;
            if (!level.isLoaded(p) || !((be = level.getBlockEntity(p)) instanceof IInventoryConnector) || !(te = (IInventoryConnector)be).hasConnectedInventories()) continue;
            this.networkAccess = new WeakReference<IInventoryConnector>(te);
            break;
        }
    }

    public IInventoryAccess getAccess(Level level, BlockPos worldPosition) {
        IInventoryConnector net;
        if (this.block.exists()) {
            IItemHandler iItemHandler = this.block.get();
            if (iItemHandler instanceof PlatformItemHandler) {
                PlatformItemHandler h = (PlatformItemHandler)iItemHandler;
                Set<IProxy> dejaVu = Collections.newSetFromMap(new IdentityHashMap());
                return h.getRootHandler(dejaVu);
            }
            return this.block;
        }
        if (level.getGameTime() - this.lastUpdate > 10L) {
            this.scanNetwork(level, worldPosition);
            this.lastUpdate = level.getGameTime();
        }
        if (this.networkAccess != null && (net = (IInventoryConnector)this.networkAccess.get()) != null && net.hasConnectedInventories()) {
            return net.getMergedHandler();
        }
        return this.block;
    }

    public boolean isNetwork() {
        return !this.block.exists() && this.networkAccess != null;
    }

    public boolean isValid() {
        return this.block.exists() || this.networkAccess != null;
    }
}

