/*
 * Decompiled with CFR 0.152.
 */
package com.tom.storagemod.item;

import com.tom.storagemod.Content;
import com.tom.storagemod.client.ClientUtil;
import com.tom.storagemod.components.SimpleItemFilterComponent;
import com.tom.storagemod.inventory.filter.ItemFilter;
import com.tom.storagemod.inventory.filter.SimpleItemFilter;
import com.tom.storagemod.item.IItemFilter;
import com.tom.storagemod.menu.ItemFilterMenu;
import com.tom.storagemod.util.BlockFaceReference;
import java.util.ArrayList;
import java.util.List;
import java.util.function.BooleanSupplier;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.SimpleMenuProvider;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;

public class FilterItem
extends Item
implements IItemFilter {
    public FilterItem(Item.Properties pr) {
        super(pr);
    }

    public void appendHoverText(ItemStack itemStack, Item.TooltipContext tooltipContext, List<Component> tooltip, TooltipFlag tooltipFlag) {
        ClientUtil.tooltip("item_filter", tooltip, new Object[0]);
        if (Screen.hasControlDown()) {
            tooltip.add((Component)Component.translatable((String)"tooltip.toms_storage.item_filter.contents"));
            SimpleItemFilterComponent c = (SimpleItemFilterComponent)itemStack.get(Content.simpleItemFilterComponent.get());
            boolean allow = false;
            ArrayList<MutableComponent> elems = new ArrayList<MutableComponent>();
            if (c != null) {
                for (ItemStack s : c.stacks()) {
                    if (s.isEmpty()) continue;
                    elems.add(Component.translatable((String)"tooltip.toms_storage.item_filter.prefix", (Object[])new Object[]{s.getHoverName()}));
                }
                allow = c.allowList();
            }
            if (elems.isEmpty()) {
                tooltip.add((Component)Component.translatable((String)"tooltip.toms_storage.item_filter.no_items"));
            } else {
                tooltip.addAll(elems);
            }
            tooltip.add((Component)Component.translatable((String)(allow ? "tooltip.toms_storage.allowList" : "tooltip.toms_storage.denyList")));
        } else {
            tooltip.add((Component)Component.translatable((String)"tooltip.toms_storage.hold_control_for_details", (Object[])new Object[]{Minecraft.ON_OSX ? "CMD" : "CTRL"}).withStyle(new ChatFormatting[]{ChatFormatting.ITALIC, ChatFormatting.GRAY}));
        }
    }

    @Override
    public ItemFilter createFilter(BlockFaceReference face, ItemStack stack) {
        return new SimpleItemFilter(stack);
    }

    public InteractionResult use(Level world, Player player, InteractionHand hand) {
        ItemStack is = player.getItemInHand(hand);
        this.openGui(is, player, () -> player.getItemInHand(hand).getItem() == this, null);
        return InteractionResult.SUCCESS_SERVER;
    }

    @Override
    public void openGui(ItemStack is, Player player, BooleanSupplier isValid, Runnable refresh) {
        player.openMenu((MenuProvider)new SimpleMenuProvider((id, pi, pl) -> new ItemFilterMenu(id, pi, new SimpleItemFilter(is), isValid, refresh), is.getHoverName()));
    }
}

