/*
 * Decompiled with CFR 0.152.
 */
package com.tom.storagemod.menu;

import com.tom.storagemod.Content;
import com.tom.storagemod.util.LimitedContainer;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.Container;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;

public class FilingCabinetMenu
extends AbstractContainerMenu {
    public static final ResourceLocation LOCKED_SLOT = ResourceLocation.tryBuild((String)"toms_storage", (String)"item/locked_slot");
    private final Container containerParent;
    private final LimitedContainer container;
    private final int containerRows;

    public FilingCabinetMenu(int wid, Inventory pinv) {
        this(wid, pinv, (Container)new SimpleContainer(512));
    }

    public FilingCabinetMenu(int wid, Inventory pinv, Container inv) {
        super(Content.filingCabinetMenu.get(), wid);
        this.containerParent = inv;
        this.container = new LimitedContainer(inv, 45);
        this.containerRows = 5;
        int i = (this.containerRows - 4) * 18;
        for (int j = 0; j < this.containerRows; ++j) {
            for (int k = 0; k < 9; ++k) {
                this.addSlot(new Slot(this, this.container, k + j * 9, 8 + k * 18, 18 + j * 18){

                    public int getMaxStackSize() {
                        return 1;
                    }

                    public int getMaxStackSize(ItemStack p_40238_) {
                        return 1;
                    }

                    public boolean mayPlace(ItemStack stack) {
                        if (!this.isValid()) {
                            return false;
                        }
                        if (stack.getMaxStackSize() != 1) {
                            return false;
                        }
                        for (int i = 0; i < this.container.getContainerSize(); ++i) {
                            ItemStack is = this.container.getItem(i);
                            if (is.isEmpty()) continue;
                            return is.getItem() == stack.getItem();
                        }
                        return true;
                    }

                    public boolean mayPickup(Player p_40228_) {
                        return this.isValid();
                    }

                    public ItemStack getItem() {
                        if (!this.isValid()) {
                            return ItemStack.EMPTY;
                        }
                        return super.getItem();
                    }

                    public ResourceLocation getNoItemIcon() {
                        if (!this.isValid()) {
                            return LOCKED_SLOT;
                        }
                        return null;
                    }

                    private boolean isValid() {
                        return this.container.getContainerSize() > this.getContainerSlot();
                    }
                });
            }
        }
        for (int l = 0; l < 3; ++l) {
            for (int j1 = 0; j1 < 9; ++j1) {
                this.addSlot(new Slot((Container)pinv, j1 + l * 9 + 9, 8 + j1 * 18, 103 + l * 18 + i));
            }
        }
        for (int i1 = 0; i1 < 9; ++i1) {
            this.addSlot(new Slot((Container)pinv, i1, 8 + i1 * 18, 161 + i));
        }
    }

    public ItemStack quickMoveStack(Player p_39253_, int p_39254_) {
        ItemStack itemstack = ItemStack.EMPTY;
        Slot slot = (Slot)this.slots.get(p_39254_);
        if (slot != null && slot.hasItem()) {
            ItemStack itemstack1 = slot.getItem();
            itemstack = itemstack1.copy();
            if (p_39254_ < this.containerRows * 9 ? !this.moveItemStackTo(itemstack1, this.containerRows * 9, this.slots.size(), true) : !this.moveItemStackTo(itemstack1, 0, this.containerRows * 9, false)) {
                return ItemStack.EMPTY;
            }
            if (itemstack1.isEmpty()) {
                slot.setByPlayer(ItemStack.EMPTY);
            } else {
                slot.setChanged();
            }
        }
        return itemstack;
    }

    public boolean stillValid(Player p_38874_) {
        return this.container.stillValid(p_38874_);
    }

    public int getRowCount() {
        return this.containerRows;
    }

    public boolean clickMenuButton(Player p_38875_, int row) {
        this.setRow(row);
        return true;
    }

    public void setRow(int row) {
        this.container.setStartOffset(row * 9);
    }

    public int getContainerSize() {
        return this.containerParent.getContainerSize();
    }
}

