/*
 * Decompiled with CFR 0.152.
 */
package com.tom.storagemod.screen.widget;

import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.WidgetSprites;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;

public class IconButton
extends Button {
    protected static final WidgetSprites SPRITES = new WidgetSprites(ResourceLocation.tryBuild((String)"toms_storage", (String)"widget/slot_button"), ResourceLocation.tryBuild((String)"toms_storage", (String)"widget/slot_button_disabled"), ResourceLocation.tryBuild((String)"toms_storage", (String)"widget/slot_button_hovered"));
    protected Component name;
    protected ResourceLocation icon;

    public IconButton(int x, int y, Component name, ResourceLocation icon, Button.OnPress pressable) {
        super(x, y, 16, 16, (Component)Component.empty(), pressable, Button.DEFAULT_NARRATION);
        this.name = name;
        this.icon = icon;
    }

    public void renderWidget(GuiGraphics st, int mouseX, int mouseY, float pt) {
        if (this.visible) {
            int x = this.getX();
            int y = this.getY();
            RenderSystem.enableBlend();
            RenderSystem.defaultBlendFunc();
            RenderSystem.blendFunc((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA);
            this.isHovered = mouseX >= x && mouseY >= y && mouseX < x + this.width && mouseY < y + this.height;
            st.blitSprite(RenderType::guiTextured, SPRITES.get(this.active, this.isHoveredOrFocused()), this.getX(), this.getY(), this.getWidth(), this.getHeight());
            this.drawIcon(st, mouseX, mouseY, pt);
        }
    }

    protected void drawIcon(GuiGraphics st, int mouseX, int mouseY, float pt) {
        st.blitSprite(RenderType::guiTextured, this.getIcon(), this.getX(), this.getY(), this.getWidth(), this.getHeight());
    }

    public ResourceLocation getIcon() {
        return this.icon;
    }
}

