/*
 * Decompiled with CFR 0.152.
 */
package com.tom.storagemod.util;

import com.tom.storagemod.inventory.StoredItemStack;
import com.tom.storagemod.menu.TerminalCraftingFiller;
import com.tom.storagemod.network.NetworkHandler;
import com.tom.storagemod.platform.Platform;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import it.unimi.dsi.fastutil.ints.Int2ObjectArrayMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import net.minecraft.ChatFormatting;
import net.minecraft.core.RegistryAccess;
import net.minecraft.core.component.DataComponentPatch;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.StackedItemContents;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.component.ItemLore;
import net.minecraft.world.level.ItemLike;

public class TerminalSyncManager {
    private static final int MAX_PACKET_SIZE = 64000;
    private Object2IntMap<StoredItemStack> idMap = new Object2IntOpenHashMap();
    private Int2ObjectMap<StoredItemStack> idMap2 = new Int2ObjectArrayMap();
    private Map<StoredItemStack, StoredItemStack> items = new HashMap<StoredItemStack, StoredItemStack>();
    private Map<StoredItemStack, StoredItemStack> itemList = new HashMap<StoredItemStack, StoredItemStack>();
    private int lastId = 1;
    private int lastChangeID = -1;
    private RegistryFriendlyByteBuf workBuf;

    public TerminalSyncManager(RegistryAccess reg) {
        this.workBuf = Platform.makeRegByteBuf(Unpooled.buffer((int)64000, (int)128000), reg);
    }

    private void write(RegistryFriendlyByteBuf buf, StoredItemStack stack) {
        ItemStack st = stack.getStack();
        Item item = st.getItem();
        DataComponentPatch components = st.getComponentsPatch();
        byte flags = (byte)((stack.getQuantity() == 0L ? 1 : 0) | (!components.isEmpty() ? 2 : 0));
        boolean wr = true;
        int id = this.idMap.getInt((Object)stack);
        if (id != 0) {
            flags = (byte)(flags | 4);
            wr = false;
        }
        buf.writeByte(flags);
        buf.writeVarInt(this.idMap.computeIfAbsent((Object)stack, s -> {
            int i = this.lastId++;
            this.idMap2.put(i, (Object)((StoredItemStack)s));
            return i;
        }));
        if (wr) {
            buf.writeVarInt(BuiltInRegistries.ITEM.getId((Object)item));
        }
        if (stack.getQuantity() != 0L) {
            buf.writeVarLong(stack.getQuantity());
        }
        if (wr && !components.isEmpty()) {
            DataComponentPatch.STREAM_CODEC.encode((Object)buf, (Object)components);
        }
    }

    private void writeMiniStack(RegistryFriendlyByteBuf buf, StoredItemStack stack) {
        int id = this.idMap.getInt((Object)stack);
        byte flags = (byte)((stack.getQuantity() == 0L ? 1 : 0) | 2);
        buf.writeByte(flags);
        buf.writeVarInt(id);
        buf.writeVarInt(BuiltInRegistries.ITEM.getId((Object)stack.getStack().getItem()));
        if (stack.getQuantity() != 0L) {
            buf.writeVarLong(stack.getQuantity());
        }
        DataComponentPatch tag = DataComponentPatch.builder().set(DataComponents.LORE, (Object)new ItemLore(List.of(Component.translatable((String)"tooltip.toms_storage.nbt_overflow").withStyle(ChatFormatting.RED)))).build();
        DataComponentPatch.STREAM_CODEC.encode((Object)buf, (Object)tag);
    }

    private StoredItemStack read(RegistryFriendlyByteBuf buf) {
        byte flags = buf.readByte();
        int id = buf.readVarInt();
        boolean rd = (flags & 4) == 0;
        StoredItemStack stack = rd ? new StoredItemStack(new ItemStack((ItemLike)BuiltInRegistries.ITEM.byId(buf.readVarInt()))) : new StoredItemStack(((StoredItemStack)this.idMap2.get(id)).getStack());
        long count = (flags & 1) != 0 ? 0L : buf.readVarLong();
        stack.setCount(count);
        if (rd && (flags & 2) != 0) {
            DataComponentPatch dataComponentPatch = (DataComponentPatch)DataComponentPatch.STREAM_CODEC.decode((Object)buf);
            stack.getStack().applyComponents(dataComponentPatch);
        }
        this.idMap.put((Object)stack, id);
        this.idMap2.put(id, (Object)stack);
        return stack;
    }

    public void update(int changeID, Map<StoredItemStack, StoredItemStack> items, ServerPlayer player, Consumer<CompoundTag> extraSync) {
        if (changeID != this.lastChangeID) {
            this.lastChangeID = changeID;
            ArrayList toWrite = new ArrayList();
            HashSet found = new HashSet();
            items.forEach((s, c) -> {
                StoredItemStack pc = this.items.get(s);
                if (pc != null) {
                    found.add(s);
                }
                if (pc == null || !c.equalDetails(pc)) {
                    toWrite.add(c);
                }
            });
            this.items.forEach((s, c) -> {
                if (!found.contains(s)) {
                    toWrite.add(new StoredItemStack(s.getStack(), 0L));
                }
            });
            this.items.clear();
            this.items.putAll(items);
            if (!toWrite.isEmpty()) {
                this.workBuf.writerIndex(0);
                int j = 0;
                int i = 0;
                while (i < toWrite.size()) {
                    StoredItemStack stack = (StoredItemStack)toWrite.get(i);
                    int li = this.workBuf.writerIndex();
                    try {
                        this.write(this.workBuf, stack);
                    }
                    catch (IndexOutOfBoundsException e) {
                        this.workBuf.writerIndex(li);
                        this.writeMiniStack(this.workBuf, stack);
                    }
                    int s2 = this.workBuf.writerIndex();
                    if ((s2 > 64000 || j > 32000) && j > 1) {
                        CompoundTag t = this.writeBuf("d", (FriendlyByteBuf)this.workBuf, li);
                        t.putShort("l", (short)j);
                        NetworkHandler.sendTo(player, t);
                        j = 0;
                        this.workBuf.writerIndex(0);
                        if (s2 - li > 64000) {
                            this.writeMiniStack(this.workBuf, stack);
                        } else {
                            this.workBuf.writeBytes((ByteBuf)this.workBuf, li, s2 - li);
                        }
                    }
                    ++i;
                    ++j;
                }
                if (j > 0 || extraSync != null) {
                    CompoundTag t;
                    if (j > 0) {
                        t = this.writeBuf("d", (FriendlyByteBuf)this.workBuf, this.workBuf.writerIndex());
                        t.putShort("l", (short)j);
                    } else {
                        t = new CompoundTag();
                    }
                    if (extraSync != null) {
                        extraSync.accept(t);
                    }
                    NetworkHandler.sendTo(player, t);
                    return;
                }
            }
        }
        if (extraSync != null) {
            CompoundTag t = new CompoundTag();
            extraSync.accept(t);
            NetworkHandler.sendTo(player, t);
        }
    }

    public boolean receiveUpdate(RegistryAccess registryAccess, CompoundTag tag) {
        if (tag.contains("d")) {
            RegistryFriendlyByteBuf buf = Platform.makeRegByteBuf(Unpooled.wrappedBuffer((byte[])tag.getByteArray("d")), registryAccess);
            ArrayList<StoredItemStack> in = new ArrayList<StoredItemStack>();
            int len = tag.getShort("l");
            for (int i = 0; i < len; ++i) {
                in.add(this.read(buf));
            }
            in.forEach(s -> {
                if (s.getQuantity() == 0L) {
                    this.itemList.remove(s);
                } else {
                    this.itemList.put((StoredItemStack)s, (StoredItemStack)s);
                }
            });
            return true;
        }
        return false;
    }

    public void sendInteract(StoredItemStack intStack, SlotAction action, boolean mod) {
        int flags;
        FriendlyByteBuf buf = new FriendlyByteBuf(Unpooled.buffer());
        int n = flags = mod ? 1 : 0;
        if (intStack == null) {
            buf.writeByte(flags | 2);
        } else {
            buf.writeByte(flags);
            buf.writeVarInt(this.idMap.getInt((Object)intStack));
            buf.writeVarLong(intStack.getQuantity());
        }
        buf.writeEnum((Enum)action);
        NetworkHandler.sendDataToServer(this.writeBuf("a", buf, buf.writerIndex()));
    }

    private CompoundTag writeBuf(String id, FriendlyByteBuf buf, int len) {
        byte[] data = new byte[len];
        buf.getBytes(0, data);
        CompoundTag tag = new CompoundTag();
        tag.putByteArray(id, data);
        return tag;
    }

    public void receiveInteract(CompoundTag tag, InteractHandler handler) {
        if (tag.contains("a")) {
            StoredItemStack stack;
            FriendlyByteBuf buf = new FriendlyByteBuf(Unpooled.wrappedBuffer((byte[])tag.getByteArray("a")));
            byte flags = buf.readByte();
            if ((flags & 2) != 0) {
                stack = null;
            } else {
                stack = new StoredItemStack(((StoredItemStack)this.idMap2.get(buf.readVarInt())).getStack());
                long count = buf.readVarLong();
                stack.setCount(count);
            }
            handler.onInteract(stack, (SlotAction)buf.readEnum(SlotAction.class), (flags & 1) != 0);
        }
    }

    public List<StoredItemStack> getAsList() {
        return new ArrayList<StoredItemStack>(this.itemList.values());
    }

    public void fillStackedContents(StackedItemContents stc) {
        this.items.forEach((s, c) -> stc.accountSimpleStack(c.getActualStack()));
    }

    public long getAmount(StoredItemStack stack) {
        StoredItemStack s = this.itemList.get(stack);
        return s != null ? s.getQuantity() : 0L;
    }

    public void fillCraftingFiller(TerminalCraftingFiller terminalCraftingFiller) {
        this.items.forEach((s, c) -> terminalCraftingFiller.accountStack(c.getActualStack()));
    }

    public static enum SlotAction {
        PULL_OR_PUSH_STACK,
        PULL_ONE,
        SPACE_CLICK,
        SHIFT_PULL,
        GET_HALF,
        GET_QUARTER,
        CRAFT;

        public static final SlotAction[] VALUES;

        static {
            VALUES = SlotAction.values();
        }
    }

    public static interface InteractHandler {
        public void onInteract(StoredItemStack var1, SlotAction var2, boolean var3);
    }
}

