/*
 * Decompiled with CFR 0.152.
 */
package com.tom.storagemod.client;

import com.tom.storagemod.Config;
import com.tom.storagemod.Content;
import com.tom.storagemod.StorageTags;
import com.tom.storagemod.block.IConfiguratorHighlight;
import com.tom.storagemod.client.CustomRenderTypes;
import com.tom.storagemod.client.ViveCraftHelper;
import com.tom.storagemod.components.ConfiguratorComponent;
import com.tom.storagemod.item.WirelessTerminalItem;
import com.tom.storagemod.platform.Platform;
import com.tom.storagemod.util.ComponentJoiner;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import net.minecraft.class_1074;
import net.minecraft.class_124;
import net.minecraft.class_1268;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1921;
import net.minecraft.class_1922;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_238;
import net.minecraft.class_239;
import net.minecraft.class_243;
import net.minecraft.class_2561;
import net.minecraft.class_265;
import net.minecraft.class_2680;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_3532;
import net.minecraft.class_3965;
import net.minecraft.class_437;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_5250;
import net.minecraft.class_5253;
import net.minecraft.class_746;
import net.minecraft.class_761;

public class ClientUtil {
    private static class_2561[] tooltipExt = new class_2561[0];

    public static void tooltip(String key, List<class_2561> tooltip, Object ... args) {
        ClientUtil.tooltip(key, true, tooltip, args);
    }

    public static void tooltip(String key, boolean addShift, List<class_2561> tooltip, Object ... args) {
        if (class_437.method_25442()) {
            String[] sp = class_2561.method_43469((String)("tooltip.toms_storage." + key), (Object[])args).getString().split("\\\\");
            for (int i = 0; i < sp.length; ++i) {
                tooltip.add((class_2561)class_2561.method_43470((String)sp[i]));
            }
        } else if (addShift) {
            tooltip.add((class_2561)class_2561.method_43471((String)"tooltip.toms_storage.hold_shift_for_info").method_27695(new class_124[]{class_124.field_1056, class_124.field_1080}));
        }
    }

    public static void setTooltip(class_2561 ... string) {
        tooltipExt = string;
    }

    public static void collectExtraTooltips(class_1799 stack, List<class_2561> toolip) {
        Collections.addAll(toolip, tooltipExt);
    }

    public static void drawTerminalOutline(class_4587 ps) {
        class_310 mc = class_310.method_1551();
        class_746 player = mc.field_1724;
        if (player == null) {
            return;
        }
        if (!WirelessTerminalItem.isPlayerHolding((class_1657)player)) {
            return;
        }
        class_3965 lookingAt = ClientUtil.rayTrace((class_1657)player, Config.get().wirelessRange, true);
        class_2680 state = mc.field_1687.method_8320(lookingAt.method_17777());
        if (state.method_26164(StorageTags.REMOTE_ACTIVATE)) {
            class_2338 pos = lookingAt.method_17777();
            class_243 renderPos = mc.field_1773.method_19418().method_19326();
            class_4588 buf = mc.method_22940().method_23000().getBuffer(class_1921.method_23594());
            ClientUtil.drawShape(ps, buf, state.method_26201((class_1922)player.method_37908(), pos), (double)pos.method_10263() - renderPos.field_1352, (double)pos.method_10264() - renderPos.field_1351, (double)pos.method_10260() - renderPos.field_1350, 1.0f, 1.0f, 1.0f, 0.4f);
            mc.method_22940().method_23000().method_22994(class_1921.method_23594());
        }
    }

    private static class_3965 rayTrace(class_1657 player, double maxDist, boolean hitFluids) {
        class_239 vr;
        if (Platform.vivecraft && (vr = ViveCraftHelper.rayTraceVR(maxDist, hitFluids)) != null) {
            return (class_3965)vr;
        }
        return (class_3965)player.method_5745(maxDist, 0.0f, hitFluids);
    }

    public static void drawConfiguratorOutline(class_4587 ps) {
        class_239 x2;
        class_310 mc = class_310.method_1551();
        class_746 player = mc.field_1724;
        if (player == null) {
            return;
        }
        class_1799 is = player.method_5998(class_1268.field_5808);
        if (!is.method_31574((class_1792)Content.invConfig.get())) {
            is = player.method_5998(class_1268.field_5810);
        }
        if (!is.method_31574((class_1792)Content.invConfig.get())) {
            return;
        }
        ConfiguratorComponent c = (ConfiguratorComponent)is.method_57824(Content.configuratorComponent.get());
        if (!c.selecting() && !c.showInvBox()) {
            ClientUtil.drawPaintedHighlights(ps);
            return;
        }
        class_243 renderPos = mc.field_1773.method_19418().method_19326();
        class_4588 buf = mc.method_22940().method_23000().getBuffer(class_1921.method_23594());
        for (class_2338 pos : c.selection()) {
            double x2 = (double)pos.method_10263() - renderPos.field_1352;
            double y = (double)pos.method_10264() - renderPos.field_1351;
            double z = (double)pos.method_10260() - renderPos.field_1350;
            class_761.method_22980((class_4587)ps, (class_4588)buf, (double)x2, (double)y, (double)z, (double)(x2 + 1.0), (double)(y + 1.0), (double)(z + 1.0), (float)1.0f, (float)1.0f, (float)1.0f, (float)0.4f);
        }
        class_4588 bufNd = mc.method_22940().method_23000().getBuffer(CustomRenderTypes.linesNoDepth());
        if (c.massSelect() && (x2 = mc.field_1765) instanceof class_3965) {
            class_3965 hr = (class_3965)x2;
            int sx = c.boxStart().method_10263();
            int sy = c.boxStart().method_10264();
            int sz = c.boxStart().method_10260();
            class_238 bb = class_238.method_54784((class_2338)new class_2338(sx, sy, sz), (class_2338)hr.method_17777());
            bb = bb.method_989(-renderPos.field_1352, -renderPos.field_1351, -renderPos.field_1350);
            class_761.method_22982((class_4587)ps, (class_4588)bufNd, (class_238)bb, (float)1.0f, (float)1.0f, (float)0.0f, (float)0.4f);
        }
        if (c.isBound()) {
            double x3 = (double)c.bound().method_10263() - renderPos.field_1352;
            double y = (double)c.bound().method_10264() - renderPos.field_1351;
            double z = (double)c.bound().method_10260() - renderPos.field_1350;
            class_761.method_22980((class_4587)ps, (class_4588)bufNd, (double)x3, (double)y, (double)z, (double)(x3 + 1.0), (double)(y + 1.0), (double)(z + 1.0), (float)1.0f, (float)0.0f, (float)0.0f, (float)1.0f);
        }
        mc.method_22940().method_23000().method_22993();
    }

    private static void drawPaintedHighlights(class_4587 ps) {
        class_310 mc = class_310.method_1551();
        class_746 player = mc.field_1724;
        class_4588 buf = mc.method_22940().method_23000().getBuffer(CustomRenderTypes.linesNoDepth());
        class_243 renderPos = mc.field_1773.method_19418().method_19326();
        class_2338.method_29715((class_238)new class_238(player.method_24515()).method_1014(7.0)).forEach(pos -> {
            double dist = renderPos.method_1028((double)pos.method_10263(), (double)pos.method_10264(), (double)pos.method_10260());
            if (dist > 49.0) {
                return;
            }
            class_2680 state = mc.field_1687.method_8320(pos);
            class_2248 patt0$temp = state.method_26204();
            if (patt0$temp instanceof IConfiguratorHighlight) {
                IConfiguratorHighlight h = (IConfiguratorHighlight)patt0$temp;
                class_265 shape = h.getHighlightShape(state, (class_1922)mc.field_1687, (class_2338)pos);
                int color = h.getHighlightColor();
                float a = 1.0f;
                if (dist > 25.0) {
                    a = 1.0f - (float)((dist - 25.0) / 24.0);
                }
                ClientUtil.drawShape(ps, buf, shape, (double)pos.method_10263() - renderPos.field_1352, (double)pos.method_10264() - renderPos.field_1351, (double)pos.method_10260() - renderPos.field_1350, (float)class_5253.class_5254.method_27765((int)color) / 255.0f, (float)class_5253.class_5254.method_27766((int)color) / 255.0f, (float)class_5253.class_5254.method_27767((int)color) / 255.0f, a);
            }
        });
    }

    private static void drawShape(class_4587 matrices, class_4588 vertexConsumer, class_265 voxelShape, double d, double e, double f, float g, float h, float i, float j) {
        class_4587.class_4665 entry = matrices.method_23760();
        voxelShape.method_1104((k, l, m, n, o, p) -> {
            float q = (float)(n - k);
            float r = (float)(o - l);
            float s = (float)(p - m);
            float t = class_3532.method_15355((float)(q * q + r * r + s * s));
            vertexConsumer.method_22918(entry.method_23761(), (float)(k + d), (float)(l + e), (float)(m + f)).method_22915(g, h, i, j).method_60831(entry, q /= t, r /= t, s /= t);
            vertexConsumer.method_22918(entry.method_23761(), (float)(n + d), (float)(o + e), (float)(p + f)).method_22915(g, h, i, j).method_60831(entry, q, r, s);
        });
    }

    public static class_2561 multilineTooltip(String text, Object ... objects) {
        return Arrays.stream(class_1074.method_4662((String)text, (Object[])objects).split("\\\\")).map(class_2561::method_43470).collect(ComponentJoiner.joining((class_2561)class_2561.method_43473(), (class_2561)class_2561.method_43470((String)"\n")));
    }

    public static void drawConfiguratorOverlay(class_332 gr) {
        class_310 mc = class_310.method_1551();
        class_746 player = mc.field_1724;
        if (player == null || mc.field_1755 != null) {
            return;
        }
        class_1799 is = player.method_5998(class_1268.field_5808);
        if (!is.method_31574((class_1792)Content.invConfig.get())) {
            is = player.method_5998(class_1268.field_5810);
        }
        if (!is.method_31574((class_1792)Content.invConfig.get())) {
            return;
        }
        ArrayList<class_5250> messages = new ArrayList<class_5250>();
        class_5250 leftClk = class_2561.method_43472((String)"key.attack").method_27692(class_124.field_1060);
        class_5250 rightClk = class_2561.method_43472((String)"key.use").method_27692(class_124.field_1060);
        class_5250 shift = class_2561.method_43472((String)"key.sneak").method_27692(class_124.field_1060);
        ConfiguratorComponent c = (ConfiguratorComponent)is.method_57824(Content.configuratorComponent.get());
        if (c.isBound()) {
            int x = c.bound().method_10263();
            int y = c.bound().method_10264();
            int z = c.bound().method_10260();
            class_2338 pos = new class_2338(x, y, z);
            if (mc.field_1724.method_5649((double)x, (double)y, (double)z) < 4096.0) {
                class_1799 item;
                class_5250 lookingAt = null;
                if (mc.field_1765 != null && !(item = Platform.getCloneItemStack((class_1937)mc.field_1687, mc.field_1765, pos, (class_1657)player)).method_7960()) {
                    lookingAt = item.method_7964();
                }
                if (lookingAt == null) {
                    lookingAt = class_2561.method_43470((String)"?");
                }
                if (mc.method_1555()) {
                    messages.add(class_2561.method_43469((String)"tooltip.toms_storage.config_overlay.block_alt", (Object[])new Object[]{lookingAt}));
                } else {
                    messages.add(class_2561.method_43469((String)"tooltip.toms_storage.config_overlay.block", (Object[])new Object[]{x, y, z}));
                    messages.add(lookingAt);
                }
                if (c.selecting()) {
                    if (c.massSelect()) {
                        messages.add(class_2561.method_43471((String)"tooltip.toms_storage.config_overlay.mass_select").method_27692(class_124.field_1065));
                        messages.add(class_2561.method_43469((String)"tooltip.toms_storage.config_overlay.mass_select.finish", (Object[])new Object[]{leftClk}));
                        messages.add(class_2561.method_43469((String)"tooltip.toms_storage.config_overlay.mass_select.abort", (Object[])new Object[]{shift, leftClk}));
                    } else {
                        messages.add(class_2561.method_43471((String)"tooltip.toms_storage.config_overlay.select").method_27692(class_124.field_1065));
                        messages.add(class_2561.method_43469((String)"tooltip.toms_storage.config_overlay.select.single", (Object[])new Object[]{rightClk}));
                        messages.add(class_2561.method_43469((String)"tooltip.toms_storage.config_overlay.select.finish", (Object[])new Object[]{rightClk}));
                        messages.add(class_2561.method_43469((String)"tooltip.toms_storage.config_overlay.select.start_mass", (Object[])new Object[]{leftClk}));
                    }
                }
            } else {
                messages.add(class_2561.method_43471((String)"tooltip.toms_storage.config_overlay.too_far"));
            }
        } else {
            messages.add(class_2561.method_43469((String)"tooltip.toms_storage.config_overlay.configure", (Object[])new Object[]{rightClk}));
            messages.add(class_2561.method_43469((String)"tooltip.toms_storage.config_overlay.show", (Object[])new Object[]{leftClk}));
        }
        if (!messages.isEmpty()) {
            gr.method_51437(mc.field_1772, messages, Optional.empty(), 5, 25);
        }
    }
}

