/*
 * Decompiled with CFR 0.152.
 */
package com.tom.storagemod.inventory;

import com.tom.storagemod.inventory.IInventoryAccess;
import com.tom.storagemod.inventory.MultiInventoryAccess;
import java.util.Collections;
import java.util.Iterator;
import java.util.NoSuchElementException;
import net.fabricmc.fabric.api.transfer.v1.item.ItemVariant;
import net.fabricmc.fabric.api.transfer.v1.storage.Storage;
import net.fabricmc.fabric.api.transfer.v1.storage.StoragePreconditions;
import net.fabricmc.fabric.api.transfer.v1.storage.StorageView;
import net.fabricmc.fabric.api.transfer.v1.transaction.Transaction;
import net.fabricmc.fabric.api.transfer.v1.transaction.TransactionContext;

public class PlatformMultiInventoryAccess
extends MultiInventoryAccess
implements Storage<ItemVariant> {
    private boolean iterating;
    private boolean calling;

    public Storage<ItemVariant> get() {
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long insert(ItemVariant resource, long maxAmount, TransactionContext transaction) {
        StoragePreconditions.notNegative((long)maxAmount);
        if (this.calling) {
            return 0L;
        }
        this.calling = true;
        long amount = 0L;
        try (Transaction iterationTransaction = Transaction.openNested((TransactionContext)transaction);){
            for (IInventoryAccess part : this.connected) {
                Storage h = (Storage)part.getPlatformHandler();
                if (h == null) continue;
                try (Transaction transferTransaction = iterationTransaction.openNested();){
                    amount += h.insert((Object)resource, maxAmount - amount, (TransactionContext)transferTransaction);
                    transferTransaction.commit();
                }
                if (amount != maxAmount) continue;
                break;
            }
            iterationTransaction.commit();
        }
        finally {
            this.calling = false;
        }
        return amount;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long extract(ItemVariant resource, long maxAmount, TransactionContext transaction) {
        StoragePreconditions.notNegative((long)maxAmount);
        if (this.calling) {
            return 0L;
        }
        this.calling = true;
        long amount = 0L;
        try (Transaction iterationTransaction = Transaction.openNested((TransactionContext)transaction);){
            for (IInventoryAccess part : this.connected) {
                Storage h = (Storage)part.getPlatformHandler();
                if (h == null) continue;
                try (Transaction transferTransaction = iterationTransaction.openNested();){
                    amount += h.extract((Object)resource, maxAmount - amount, (TransactionContext)transferTransaction);
                    transferTransaction.commit();
                }
                if (amount != maxAmount) continue;
                break;
            }
            iterationTransaction.commit();
        }
        finally {
            this.calling = false;
        }
        return amount;
    }

    public Iterator<StorageView<ItemVariant>> iterator() {
        if (this.iterating) {
            new Throwable("Recursive storage access").printStackTrace();
            return Collections.emptyIterator();
        }
        return new MultiIterator();
    }

    private class MultiIterator
    implements Iterator<StorageView<ItemVariant>> {
        final Iterator<IInventoryAccess> partIterator;
        Iterator<? extends StorageView<ItemVariant>> currentPartIterator;

        MultiIterator() {
            this.partIterator = PlatformMultiInventoryAccess.this.connected.iterator();
            this.currentPartIterator = null;
            this.advanceCurrentPartIterator();
        }

        @Override
        public boolean hasNext() {
            return this.currentPartIterator != null && this.currentPartIterator.hasNext();
        }

        @Override
        public StorageView<ItemVariant> next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            StorageView<ItemVariant> returned = this.currentPartIterator.next();
            if (!this.currentPartIterator.hasNext()) {
                this.advanceCurrentPartIterator();
            }
            return returned;
        }

        private void advanceCurrentPartIterator() {
            PlatformMultiInventoryAccess.this.iterating = true;
            while (this.partIterator.hasNext()) {
                Storage h = (Storage)this.partIterator.next().getPlatformHandler();
                if (h == null) {
                    h = Storage.empty();
                }
                this.currentPartIterator = h.iterator();
                if (!this.currentPartIterator.hasNext()) continue;
                break;
            }
            PlatformMultiInventoryAccess.this.iterating = false;
        }
    }
}

