/*
 * Decompiled with CFR 0.152.
 */
package com.tom.storagemod.inventory;

import com.tom.storagemod.block.IInventoryCable;
import com.tom.storagemod.util.BlockFace;
import com.tom.storagemod.util.WorldStates;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.Stack;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2680;

public class InventoryCableNetwork {
    private final class_1937 level;
    private Map<class_2338, CableCache> caches = new HashMap<class_2338, CableCache>();

    public InventoryCableNetwork(class_1937 level) {
        this.level = level;
    }

    public Collection<class_2338> getNetworkNodes(class_2338 from) {
        CableCache cache = this.caches.get(from);
        if (cache != null) {
            return cache.attached;
        }
        HashSet<class_2338> checked = new HashSet<class_2338>();
        Stack<BlockFace> next = new Stack<BlockFace>();
        HashSet<class_2338> cables = new HashSet<class_2338>();
        HashSet<class_2338> attached = new HashSet<class_2338>();
        next.add(new BlockFace(from, null));
        while (!next.isEmpty()) {
            class_2680 st;
            class_2248 class_22482;
            BlockFace p2 = (BlockFace)next.pop();
            if (checked.contains(p2.pos())) continue;
            checked.add(p2.pos());
            if (!this.level.method_8477(p2.pos()) || !((class_22482 = (st = this.level.method_8320(p2.pos())).method_26204()) instanceof IInventoryCable)) continue;
            IInventoryCable c = (IInventoryCable)class_22482;
            if (p2.from() != null && !c.canConnectFrom(st, p2.from())) continue;
            CableCache cc = this.caches.get(p2.pos());
            if (cc != null) {
                cables.addAll(cc.cables);
                attached.addAll(cc.attached);
                checked.addAll(cc.cables);
                continue;
            }
            if (c.isFunctionalNode()) {
                attached.add(p2.pos());
            } else {
                cables.add(p2.pos());
            }
            next.addAll(c.nextScan(this.level, st, p2.pos()));
        }
        CableCache cc = new CableCache(cables, attached);
        cables.forEach(p -> this.caches.put((class_2338)p, cc));
        return cc.attached;
    }

    public void markNodeInvalid(class_2338 pos) {
        CableCache cc = this.caches.get(pos);
        if (cc != null) {
            cc.cables.forEach(this.caches::remove);
        }
    }

    public void markNodeInvalid(BlockFace pos) {
        this.markNodeInvalid(pos.pos());
    }

    public static InventoryCableNetwork getNetwork(class_1937 level) {
        return WorldStates.cableNetworks.computeIfAbsent(level, InventoryCableNetwork::new);
    }

    private record CableCache(Set<class_2338> cables, Set<class_2338> attached) {
    }
}

