/*
 * Decompiled with CFR 0.152.
 */
package com.tom.storagemod.inventory;

import java.util.Comparator;
import java.util.function.Function;
import net.minecraft.class_1799;
import net.minecraft.class_7923;

public class StoredItemStack {
    private class_1799 stack;
    private long count;
    private int hash;
    private boolean hashZero;

    public StoredItemStack(class_1799 stack, long count) {
        this.stack = stack;
        this.count = count;
    }

    public StoredItemStack(class_1799 stack) {
        this.stack = stack.method_7972();
        this.stack.method_7939(1);
        this.count = stack.method_7947();
    }

    public StoredItemStack(class_1799 stack, long count, int hash) {
        this.stack = stack;
        this.count = count;
        this.hash = hash;
        if (hash == 0) {
            this.hashZero = true;
        }
    }

    public StoredItemStack(StoredItemStack st) {
        this.stack = st.stack;
        this.count = st.count;
        this.hash = st.hash;
        this.hashZero = st.hashZero;
    }

    public class_1799 getStack() {
        return this.stack;
    }

    public long getQuantity() {
        return this.count;
    }

    public class_1799 getActualStack() {
        class_1799 s = this.stack.method_7972();
        s.method_7939((int)this.count);
        return s;
    }

    public int hashCode() {
        if (this.hash == 0 && !this.hashZero) {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.stack == null ? 0 : this.stack.method_7909().hashCode());
            this.hash = result = 31 * result + (this.stack == null ? 0 : this.stack.method_57380().hashCode());
            if (this.hash == 0) {
                this.hashZero = true;
            }
            return result;
        }
        return this.hash;
    }

    public String getDisplayName() {
        return this.stack.method_7964().getString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        StoredItemStack other = (StoredItemStack)obj;
        return !(this.stack == null ? other.stack != null : !class_1799.method_31577((class_1799)this.stack, (class_1799)other.stack));
    }

    public boolean equals(StoredItemStack other) {
        if (this == other) {
            return true;
        }
        if (other == null) {
            return false;
        }
        if (this.count != other.count) {
            return false;
        }
        return !(this.stack == null ? other.stack != null : !class_1799.method_31577((class_1799)this.stack, (class_1799)other.stack));
    }

    public boolean equalItem(StoredItemStack other) {
        if (this == other) {
            return true;
        }
        if (other == null) {
            return false;
        }
        return !(this.stack == null ? other.stack != null : !class_1799.method_31577((class_1799)this.stack, (class_1799)other.stack));
    }

    public void grow(long c) {
        this.count += c;
    }

    public void setCount(long count) {
        this.count = count;
    }

    public int getMaxStackSize() {
        return this.stack.method_7914();
    }

    public static StoredItemStack merge(StoredItemStack a, StoredItemStack b) {
        if (a == null) {
            return b;
        }
        if (b == null) {
            return a;
        }
        return new StoredItemStack(a.stack, a.count + b.count, a.hashCode());
    }

    public boolean equalDetails(StoredItemStack pc) {
        return pc.count == this.count;
    }

    public static enum SortingTypes {
        AMOUNT(ComparatorAmount::new),
        NAME(ComparatorName::new),
        BY_MOD(ComparatorModName::new);

        public static final SortingTypes[] VALUES;
        private final Function<Boolean, IStoredItemStackComparator> factory;

        private SortingTypes(Function<Boolean, IStoredItemStackComparator> factory) {
            this.factory = factory;
        }

        public IStoredItemStackComparator create(boolean rev) {
            return this.factory.apply(rev);
        }

        static {
            VALUES = SortingTypes.values();
        }
    }

    public static interface IStoredItemStackComparator
    extends Comparator<StoredItemStack> {
        public boolean isReversed();

        public void setReversed(boolean var1);

        public int type();
    }

    public static class ComparatorModName
    implements IStoredItemStackComparator {
        public boolean reversed;

        public ComparatorModName(boolean reversed) {
            this.reversed = reversed;
        }

        @Override
        public int compare(StoredItemStack in1, StoredItemStack in2) {
            String m1 = class_7923.field_41178.method_10221((Object)in1.getStack().method_7909()).method_12836();
            String m2 = class_7923.field_41178.method_10221((Object)in2.getStack().method_7909()).method_12836();
            int c1 = m1.compareTo(m2);
            int c2 = in1.getDisplayName().compareTo(in2.getDisplayName());
            int c = c1 == 0 ? c2 : c1;
            return this.reversed ? -c : c;
        }

        @Override
        public boolean isReversed() {
            return this.reversed;
        }

        @Override
        public void setReversed(boolean rev) {
            this.reversed = rev;
        }

        @Override
        public int type() {
            return 2;
        }
    }

    public static class ComparatorName
    implements IStoredItemStackComparator {
        public boolean reversed;

        public ComparatorName(boolean reversed) {
            this.reversed = reversed;
        }

        @Override
        public int compare(StoredItemStack in1, StoredItemStack in2) {
            int c = in1.getDisplayName().compareTo(in2.getDisplayName());
            return this.reversed ? -c : c;
        }

        @Override
        public boolean isReversed() {
            return this.reversed;
        }

        @Override
        public int type() {
            return 1;
        }

        @Override
        public void setReversed(boolean rev) {
            this.reversed = rev;
        }
    }

    public static class ComparatorAmount
    implements IStoredItemStackComparator {
        public boolean reversed;

        public ComparatorAmount(boolean reversed) {
            this.reversed = reversed;
        }

        @Override
        public int compare(StoredItemStack in1, StoredItemStack in2) {
            int c = in2.getQuantity() > in1.getQuantity() ? 1 : (in1.getQuantity() == in2.getQuantity() ? in1.getStack().method_7964().getString().compareTo(in2.getStack().method_7964().getString()) : -1);
            return this.reversed ? -c : c;
        }

        @Override
        public boolean isReversed() {
            return this.reversed;
        }

        @Override
        public int type() {
            return 0;
        }

        @Override
        public void setReversed(boolean rev) {
            this.reversed = rev;
        }
    }
}

