/*
 * Decompiled with CFR 0.152.
 */
package me.duncanruns.fsgmod;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonSyntaxException;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import me.duncanruns.fsgmod.FSGMod;
import me.duncanruns.fsgmod.util.FileUtil;
import me.duncanruns.fsgmod.util.GrabUtil;
import net.fabricmc.loader.api.FabricLoader;

public class FSGModConfig {
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().create();
    private static final Path PATH = FabricLoader.getInstance().getConfigDir().resolve("fsgwm.json");
    private static FSGModConfig instance = new FSGModConfig();
    public String onlineFilterCode = null;
    public String installedFilter = "Unknown Filter";
    public int maxGenerating = 1;

    public static void trySave() {
        try {
            FSGModConfig.save();
        }
        catch (Exception e) {
            FSGMod.logError("Failed to save config!", e);
        }
    }

    private static void save() throws IOException {
        FileUtil.writeString(PATH, GSON.toJson((Object)instance));
    }

    public static void tryLoad() {
        try {
            FSGModConfig.load();
        }
        catch (Exception e) {
            FSGMod.logError("Failed to load config!", e);
            instance = new FSGModConfig();
        }
    }

    private static void resolveMaxGenerating() {
        JsonObject meta;
        FSGModConfig.instance.maxGenerating = 1;
        try {
            meta = GrabUtil.grabJson("https://raw.githubusercontent.com/DuncanRuns/FSG-Mod/meta/meta.json");
        }
        catch (IOException e) {
            FSGMod.logError("Could not resolve max generating for filter:", e);
            return;
        }
        String filterName = FSGModConfig.instance.installedFilter;
        for (JsonElement element : meta.getAsJsonArray("filters")) {
            JsonObject filter = element.getAsJsonObject();
            if (!filterName.startsWith(filter.get("name").getAsString())) continue;
            FSGModConfig.instance.maxGenerating = filter.get("maxGenerating").getAsInt();
        }
    }

    private static void load() throws IOException, JsonSyntaxException {
        if (Files.exists(PATH, new LinkOption[0])) {
            String s = FileUtil.readString(PATH);
            instance = (FSGModConfig)GSON.fromJson(s, FSGModConfig.class);
        }
        if (!FSGModConfig.instance.installedFilter.equals("Unknown Filter") && FSGModConfig.instance.maxGenerating == -1) {
            FSGModConfig.resolveMaxGenerating();
        }
    }

    public static FSGModConfig getInstance() {
        return instance;
    }
}

