/*
 * Decompiled with CFR 0.152.
 */
package me.duncanruns.fsgmod;

import com.google.gson.JsonObject;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import me.duncanruns.fsgmod.FSGFilterResult;
import me.duncanruns.fsgmod.FSGMod;
import me.duncanruns.fsgmod.FSGModConfig;
import me.duncanruns.fsgmod.util.GrabUtil;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.Nullable;

public final class FSGRunner {
    private static final Pattern SEED_PATTERN = Pattern.compile("[sS]eed.*: ?(-?\\d+)");
    private static final Pattern TOKEN_PATTERN = Pattern.compile("[tT]oken.*?: ?(.+)");

    private FSGRunner() {
    }

    public static FSGFilterResult runFilter() throws IOException, InterruptedException {
        String onlineFilterCode = FSGModConfig.getInstance().onlineFilterCode;
        if (onlineFilterCode != null) {
            return FSGRunner.runFilterOnline(onlineFilterCode);
        }
        return FSGRunner.runFilterOffline();
    }

    private static FSGFilterResult runFilterOnline(String onlineFilterCode) throws IOException, InterruptedException {
        String responseType;
        JsonObject json;
        do {
            try {
                json = GrabUtil.grabJson("https://fsgonlinedb.duncanruns.xyz/getSeed/" + onlineFilterCode);
            }
            catch (Exception e) {
                throw new IOException(e);
            }
        } while (FSGRunner.checkCooldown(json));
        switch (responseType = json.get("type").getAsString()) {
            case "SUCCESS": {
                return new FSGFilterResult(json.getAsJsonObject("data").get("seed").getAsString(), json.getAsJsonObject("data").get("token").getAsString(), System.currentTimeMillis());
            }
            case "ERROR": {
                throw new IOException("Error from fsgonlinedb: " + json.get("errorMessage").getAsString());
            }
        }
        throw new IOException("Unexpected response from fsgonlinedb");
    }

    private static boolean checkCooldown(JsonObject jsonObject) throws InterruptedException {
        if (jsonObject.get("type").getAsString().equals("COOLDOWN")) {
            Thread.sleep(jsonObject.get("cooldown").getAsLong());
            return true;
        }
        return false;
    }

    @Nullable
    private static FSGFilterResult runFilterOffline() throws IOException, InterruptedException {
        String readL;
        String command = FSGMod.getRunPath().toString();
        Process process = new ProcessBuilder(command).directory(FSGMod.getFsgDir().toFile()).start();
        ArrayList<String> lines = new ArrayList<String>();
        BufferedReader reader = new BufferedReader(new InputStreamReader(process.getInputStream()));
        BufferedReader errReader = new BufferedReader(new InputStreamReader(process.getErrorStream()));
        while ((readL = reader.readLine()) != null) {
            lines.add(readL.trim());
            readL = errReader.readLine();
            if (readL == null) continue;
            lines.add(readL.trim());
        }
        process.waitFor();
        long generationTime = System.currentTimeMillis();
        String seedOut = null;
        String tokenOut = "Token Unavailable";
        for (String line : lines) {
            if (!line.contains(":")) continue;
            Matcher matcher = SEED_PATTERN.matcher(line);
            if (matcher.find()) {
                seedOut = matcher.group(1);
                continue;
            }
            matcher = TOKEN_PATTERN.matcher(line);
            if (!matcher.find()) continue;
            tokenOut = matcher.group(1);
        }
        if (seedOut == null) {
            FSGMod.LOGGER.info("No seed was returned, process output:");
            lines.forEach(arg_0 -> ((Logger)FSGMod.LOGGER).info(arg_0));
            return null;
        }
        return new FSGFilterResult(seedOut, tokenOut, generationTime);
    }
}

