/*
 * Decompiled with CFR 0.152.
 */
package me.duncanruns.fsgmod;

import java.io.IOException;
import java.util.Objects;
import java.util.Optional;
import java.util.OptionalLong;
import java.util.Queue;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentLinkedQueue;
import me.duncanruns.fsgmod.FSGFilterResult;
import me.duncanruns.fsgmod.FSGMod;
import me.duncanruns.fsgmod.FSGModConfig;
import me.duncanruns.fsgmod.FSGRunner;
import me.duncanruns.fsgmod.compat.ModCompat;
import me.voidxwalker.autoreset.Atum;
import net.minecraft.class_124;
import net.minecraft.class_2561;
import net.minecraft.class_2585;
import net.minecraft.class_310;
import net.minecraft.class_3532;
import org.apache.commons.lang3.StringUtils;

public final class SeedManager {
    private static Queue<FSGFilterResult> resultQueue = new ConcurrentLinkedQueue<FSGFilterResult>();
    private static final Queue<FSGFilterResult> resultCache = new ConcurrentLinkedQueue<FSGFilterResult>();
    private static int currentlyFiltering = 0;
    private static CompletableFuture<String> mainThreadSF = null;
    private static CompletableFuture<String> sqThreadSF = null;

    private SeedManager() {
    }

    public static int getCurrentlyFiltering() {
        return currentlyFiltering;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void clear() {
        Class<SeedManager> clazz = SeedManager.class;
        synchronized (SeedManager.class) {
            resultQueue = new ConcurrentLinkedQueue<FSGFilterResult>();
            // ** MonitorExit[var0] (shouldn't be in output)
            return;
        }
    }

    private static synchronized void kick(boolean forceOne) {
        if (!ModCompat.HAS_SEEDQUEUE) {
            return;
        }
        int maxCapacity = class_3532.method_15340((int)FSGModConfig.getInstance().maxGenerating, (int)1, (int)ModCompat.seedqueue$getMaxCapacity());
        ModCompat.seedqueue$clampMaxCapacity(maxCapacity);
        int maxGenerating = Math.min(maxCapacity, Math.max(ModCompat.seedqueue$getMaxConcurrently_onWall(), ModCompat.seedqueue$getMaxConcurrently()));
        int toGenerate = Math.min(maxCapacity - ModCompat.seedqueue$getTotalEntries() - resultQueue.size(), maxGenerating) - currentlyFiltering;
        toGenerate = Math.max(toGenerate, forceOne ? 1 : 0);
        if (toGenerate == 0) {
            return;
        }
        FSGMod.LOGGER.info("Starting {} filtering thread{}...", (Object)toGenerate, (Object)(toGenerate > 1 ? "s" : ""));
        SeedManager.startNewFilterThreads(toGenerate);
    }

    private static void startNewFilterThreads(int total) {
        for (int i = 0; i < total; ++i) {
            SeedManager.startNewFilterThread();
        }
    }

    private static synchronized void startNewFilterThread() {
        ++currentlyFiltering;
        Thread thread = new Thread(() -> {
            Class<SeedManager> clazz = SeedManager.class;
            synchronized (SeedManager.class) {
                FSGFilterResult result;
                Queue<FSGFilterResult> queueToUse = resultQueue;
                // ** MonitorExit[var1] (shouldn't be in output)
                try {
                    result = FSGRunner.runFilter();
                }
                catch (IOException | InterruptedException e) {
                    Class<SeedManager> clazz2 = SeedManager.class;
                    synchronized (SeedManager.class) {
                        --currentlyFiltering;
                        if (resultQueue != queueToUse) {
                            // ** MonitorExit[var3_5] (shouldn't be in output)
                            return;
                        }
                        FSGMod.logError("Failed to run filter!", e);
                        SeedManager.onFail();
                        // ** MonitorExit[var3_5] (shouldn't be in output)
                        return;
                    }
                }
                Class<SeedManager> clazz3 = SeedManager.class;
                synchronized (SeedManager.class) {
                    resultCache.add(result);
                    queueToUse.add(result);
                    while (resultCache.size() > 200) {
                        resultCache.remove();
                    }
                    --currentlyFiltering;
                    if (Atum.isRunning()) {
                        SeedManager.kick(false);
                    }
                    SeedManager.onSeedAvailable();
                    // ** MonitorExit[var2_4] (shouldn't be in output)
                    return;
                }
            }
        }, "filter-thread");
        thread.setDaemon(true);
        thread.start();
    }

    private static synchronized void onSeedAvailable() {
        if (!SeedManager.hasSeed()) {
            return;
        }
        if (mainThreadSF != null) {
            mainThreadSF.complete(Objects.requireNonNull(SeedManager.resultQueue.poll()).seed);
            mainThreadSF = null;
        }
        if (sqThreadSF != null) {
            sqThreadSF.complete(Objects.requireNonNull(SeedManager.resultQueue.poll()).seed);
            sqThreadSF = null;
        }
    }

    private static synchronized void onFail() {
        SeedManager.cancelAll();
        class_310.method_1551().execute(() -> {
            Atum.stopRunning();
            class_310 client = class_310.method_1551();
            if (client.field_1687 != null && client.field_1724 != null) {
                client.field_1705.method_1743().method_1812((class_2561)new class_2585("(FSG Mod) Filtering has failed!").method_10992().method_27694(style -> style.method_10977(class_124.field_1061).method_10977(class_124.field_1067)));
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean hasSeed() {
        long currentTime = System.currentTimeMillis();
        Class<SeedManager> clazz = SeedManager.class;
        synchronized (SeedManager.class) {
            resultQueue.removeIf(result -> Math.abs(result.generationTime - currentTime) > 60000L);
            // ** MonitorExit[var2_1] (shouldn't be in output)
            SeedManager.kick(false);
            return !resultQueue.isEmpty();
        }
    }

    public static Optional<FSGFilterResult> getResultForSeed(long seed) {
        return resultCache.stream().filter(result -> {
            OptionalLong optionalLong = SeedManager.getSeedFromString(result.seed);
            if (!optionalLong.isPresent()) {
                return false;
            }
            return optionalLong.getAsLong() == seed;
        }).findAny();
    }

    private static OptionalLong getSeedFromString(String string) {
        OptionalLong optionalLong2;
        OptionalLong optionalLong = StringUtils.isEmpty((CharSequence)string) ? OptionalLong.empty() : ((optionalLong2 = SeedManager.tryParseLong(string)).isPresent() && optionalLong2.getAsLong() != 0L ? optionalLong2 : OptionalLong.of(string.hashCode()));
        return optionalLong;
    }

    private static OptionalLong tryParseLong(String string) {
        try {
            return OptionalLong.of(Long.parseLong(string));
        }
        catch (NumberFormatException e) {
            return OptionalLong.empty();
        }
    }

    public static synchronized void requestSeed(boolean mainThread, CompletableFuture<String> sf) {
        if (!Atum.isRunning()) {
            sf.cancel(true);
            return;
        }
        SeedManager.kick(true);
        if (SeedManager.hasSeed()) {
            sf.complete(Objects.requireNonNull(SeedManager.resultQueue.poll()).seed);
            return;
        }
        if (mainThread) {
            mainThreadSF = sf;
        } else {
            sqThreadSF = sf;
        }
    }

    public static synchronized void cancelAll() {
        if (mainThreadSF != null) {
            mainThreadSF.cancel(true);
        }
        if (sqThreadSF != null) {
            sqThreadSF.cancel(true);
        }
        mainThreadSF = null;
        sqThreadSF = null;
        SeedManager.clear();
    }
}

