/*
 * Decompiled with CFR 0.152.
 */
package me.duncanruns.fsgmod.screen;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.util.List;
import java.util.stream.Collectors;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import me.duncanruns.fsgmod.FSGMod;
import me.duncanruns.fsgmod.screen.DownloadFailedScreen;
import me.duncanruns.fsgmod.util.GrabUtil;
import net.minecraft.class_2561;
import net.minecraft.class_2585;
import net.minecraft.class_437;
import net.minecraft.class_4587;
import net.minecraft.class_5348;
import org.apache.commons.io.FileUtils;

public class DownloadingScreen
extends class_437 {
    private boolean failed = false;
    private Thread thread = null;
    private int totalBytesRead = 0;
    private final String downloadURL;
    private final class_437 screenOnCompletion;
    private final Runnable runOnCompletion;

    public DownloadingScreen(String downloadURL, class_437 screenOnCompletion, Runnable runOnCompletion) {
        super((class_2561)new class_2585("Filter Download"));
        this.downloadURL = downloadURL;
        this.screenOnCompletion = screenOnCompletion;
        this.runOnCompletion = runOnCompletion;
    }

    private static void unzip(Path zipFilePath, Path outputDir) throws IOException {
        if (!Files.exists(outputDir, new LinkOption[0])) {
            Files.createDirectories(outputDir, new FileAttribute[0]);
        }
        try (InputStream fis = Files.newInputStream(zipFilePath, new OpenOption[0]);
             ZipInputStream zis = new ZipInputStream(fis);){
            ZipEntry entry;
            while ((entry = zis.getNextEntry()) != null) {
                Path entryPath = outputDir.resolve(entry.getName());
                if (entry.isDirectory()) {
                    if (!Files.exists(entryPath, new LinkOption[0])) {
                        Files.createDirectories(entryPath, new FileAttribute[0]);
                    }
                } else {
                    if (!Files.exists(entryPath.getParent(), new LinkOption[0])) {
                        Files.createDirectories(entryPath.getParent(), new FileAttribute[0]);
                    }
                    Files.copy(zis, entryPath, StandardCopyOption.REPLACE_EXISTING);
                }
                zis.closeEntry();
            }
        }
    }

    private void downloadAndMove() throws IOException {
        List files;
        String destDirPath;
        Path fsgFolderPath;
        Path zipFilePath = FSGMod.getGameDir().resolve("downloaded.zip");
        File zipFile = zipFilePath.toFile();
        if (!zipFile.isFile()) {
            GrabUtil.download(this.downloadURL, zipFilePath, i -> {
                this.totalBytesRead = i;
            });
        }
        if (!Files.isDirectory(fsgFolderPath = Paths.get(destDirPath = FSGMod.getFsgDir() + "/", new String[0]), new LinkOption[0])) {
            Files.createDirectories(fsgFolderPath, new FileAttribute[0]);
        }
        DownloadingScreen.unzip(zipFilePath, fsgFolderPath);
        zipFile.delete();
        while ((files = Files.list(FSGMod.getFsgDir()).collect(Collectors.toList())).size() == 1 && Files.isDirectory((Path)files.get(0), new LinkOption[0])) {
            File temp = FSGMod.getFsgDir().resolveSibling("fsg-temp").toFile();
            FileUtils.moveDirectory((File)((Path)files.get(0)).toFile(), (File)temp);
            FileUtils.deleteDirectory((File)FSGMod.getFsgDir().toFile());
            FileUtils.moveDirectory((File)temp, (File)FSGMod.getFsgDir().toFile());
            FileUtils.deleteDirectory((File)temp);
        }
    }

    private String getDisplay() {
        if (this.totalBytesRead == 0) {
            return "Starting download...";
        }
        return String.format("Downloading (%d)...", this.totalBytesRead);
    }

    public void method_25394(class_4587 matrices, int mouseX, int mouseY, float delta) {
        this.method_25420(matrices);
        this.method_27534(matrices, this.field_22793, (class_5348)this.field_22785, this.field_22789 / 2, this.field_22790 / 3, 0xFFFFFF);
        this.method_25300(matrices, this.field_22793, this.getDisplay(), this.field_22789 / 2, this.field_22790 / 2, 0xFFFFFF);
        super.method_25394(matrices, mouseX, mouseY, delta);
    }

    public boolean method_25422() {
        return false;
    }

    protected void method_25426() {
        if (this.thread != null) {
            return;
        }
        this.thread = new Thread(() -> {
            try {
                this.downloadAndMove();
                this.runOnCompletion.run();
            }
            catch (Exception e) {
                this.failed = true;
                FSGMod.logError("Error while downloading!", e);
            }
        }, "fsg-download");
        this.thread.start();
    }

    public void method_25393() {
        if (this.thread.isAlive()) {
            return;
        }
        try {
            Thread.sleep(15L);
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
        if (this.failed) {
            this.field_22787.method_1507((class_437)new DownloadFailedScreen());
        } else {
            this.field_22787.method_1507(this.screenOnCompletion);
        }
    }
}

