/*
 * Decompiled with CFR 0.152.
 */
package me.duncanruns.fsgmod.util;

import com.google.gson.Gson;
import com.google.gson.JsonObject;
import com.google.gson.JsonSyntaxException;
import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.security.KeyManagementException;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.cert.X509Certificate;
import java.util.function.Consumer;
import javax.net.ssl.SSLContext;
import me.duncanruns.fsgmod.FSGMod;
import org.apache.commons.io.IOUtils;
import org.apache.http.HttpEntity;
import org.apache.http.client.HttpClient;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.config.Registry;
import org.apache.http.config.RegistryBuilder;
import org.apache.http.conn.HttpClientConnectionManager;
import org.apache.http.conn.socket.PlainConnectionSocketFactory;
import org.apache.http.conn.ssl.SSLConnectionSocketFactory;
import org.apache.http.conn.ssl.SSLContextBuilder;
import org.apache.http.conn.ssl.TrustStrategy;
import org.apache.http.conn.ssl.X509HostnameVerifier;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.impl.conn.PoolingHttpClientConnectionManager;
import org.apache.http.util.EntityUtils;

public final class GrabUtil {
    private static final Gson GSON = new Gson();
    private static final HttpClient httpClient;

    private GrabUtil() {
    }

    private static HttpClient getHttpClient() throws NoSuchAlgorithmException, KeyStoreException, KeyManagementException {
        try {
            IOUtils.toString((InputStream)new URL("https://valid-isrgrootx1.letsencrypt.org/").openStream(), (Charset)Charset.defaultCharset());
            return HttpClientBuilder.create().build();
        }
        catch (Exception ignored) {
            FSGMod.LOGGER.warn("Outdated Java, GrabUtil is using an insecure HttpClient!");
            HttpClientBuilder b = HttpClientBuilder.create();
            SSLContext sslContext = new SSLContextBuilder().loadTrustMaterial(null, new TrustStrategy(){

                public boolean isTrusted(X509Certificate[] arg0, String arg1) {
                    return true;
                }
            }).build();
            b.setSslcontext(sslContext);
            X509HostnameVerifier hostnameVerifier = SSLConnectionSocketFactory.ALLOW_ALL_HOSTNAME_VERIFIER;
            SSLConnectionSocketFactory sslSocketFactory = new SSLConnectionSocketFactory(sslContext, hostnameVerifier);
            Registry socketFactoryRegistry = RegistryBuilder.create().register("http", (Object)PlainConnectionSocketFactory.getSocketFactory()).register("https", (Object)sslSocketFactory).build();
            PoolingHttpClientConnectionManager connMgr = new PoolingHttpClientConnectionManager(socketFactoryRegistry);
            b.setConnectionManager((HttpClientConnectionManager)connMgr);
            return b.build();
        }
    }

    public static String grab(String origin) throws IOException {
        HttpGet request = new HttpGet(origin);
        CloseableHttpResponse response = (CloseableHttpResponse)httpClient.execute((HttpUriRequest)request);
        HttpEntity entity = response.getEntity();
        String out = EntityUtils.toString((HttpEntity)entity);
        response.close();
        return out;
    }

    public static JsonObject grabJson(String origin) throws IOException, JsonSyntaxException {
        return (JsonObject)GSON.fromJson(GrabUtil.grab(origin), JsonObject.class);
    }

    public static void download(String origin, Path destination, Consumer<Integer> bytesReadConsumer) throws IOException {
        HttpGet request = new HttpGet(origin);
        try (CloseableHttpResponse response = (CloseableHttpResponse)httpClient.execute((HttpUriRequest)request);
             BufferedInputStream sourceStream = new BufferedInputStream(response.getEntity().getContent());
             OutputStream destinationStream = Files.newOutputStream(destination, new OpenOption[0]);){
            int bytesRead;
            int bufferSize = 1024;
            int totalBytesRead = 0;
            byte[] dataBuffer = new byte[bufferSize];
            while ((bytesRead = sourceStream.read(dataBuffer, 0, bufferSize)) != -1) {
                destinationStream.write(dataBuffer, 0, bytesRead);
                bytesReadConsumer.accept(totalBytesRead += bytesRead);
            }
        }
    }

    public static void download(String origin, Path destination) throws IOException {
        GrabUtil.download(origin, destination, integer -> {});
    }

    static {
        try {
            httpClient = GrabUtil.getHttpClient();
        }
        catch (KeyManagementException | KeyStoreException | NoSuchAlgorithmException e) {
            throw new RuntimeException(e);
        }
    }
}

