/*
 * Decompiled with CFR 0.152.
 */
package dev.worldgen.lithostitched.worldgen.modifier;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import dev.worldgen.lithostitched.mixin.common.BiomeAccessor;
import dev.worldgen.lithostitched.mixin.common.BiomeAccessor2;
import dev.worldgen.lithostitched.mixin.common.MappedRegistryAccessor;
import dev.worldgen.lithostitched.worldgen.modifier.Modifier;
import dev.worldgen.lithostitched.worldgen.modifier.util.BiomeEffects;
import java.util.List;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import net.minecraft.class_12190;
import net.minecraft.class_12194;
import net.minecraft.class_12197;
import net.minecraft.class_12199;
import net.minecraft.class_12206;
import net.minecraft.class_1959;
import net.minecraft.class_2378;
import net.minecraft.class_4763;
import net.minecraft.class_5321;
import net.minecraft.class_5455;
import net.minecraft.class_6880;
import net.minecraft.class_6885;
import net.minecraft.class_7924;
import net.minecraft.class_9248;

public record ReplaceEffectsModifier(int priority, class_6885<class_1959> biomes, BiomeEffects specialEffects) implements Modifier
{
    public static final MapCodec<ReplaceEffectsModifier> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)PRIORITY_DEFAULT.forGetter(ReplaceEffectsModifier::priority), (App)class_1959.field_26750.fieldOf("biomes").forGetter(ReplaceEffectsModifier::biomes), (App)BiomeEffects.CODEC.fieldOf("effects").forGetter(ReplaceEffectsModifier::specialEffects)).apply((Applicative)instance, ReplaceEffectsModifier::new));

    @Override
    public void applyModifier(class_5455 registryAccess) {
        List biomes = this.biomes().method_40239().toList();
        class_2378 registry = registryAccess.method_30530(class_7924.field_41236);
        for (class_6880 entry : biomes.stream().toList()) {
            this.applyModifier((class_1959)entry.comp_349());
            if (!entry.method_40230().isPresent()) continue;
            class_5321 key = (class_5321)entry.method_40230().get();
            Optional knownPackInfo = registry.method_57058(key);
            knownPackInfo.ifPresent(registrationInfo -> ((MappedRegistryAccessor)registry).lithostitched$getRegistrationInfos().put(key, new class_9248(Optional.empty(), registrationInfo.comp_2355())));
        }
    }

    @Override
    public void applyModifier() {
    }

    public void applyModifier(class_1959 biome) {
        BiomeAccessor accessor = (BiomeAccessor)biome;
        BiomeAccessor2 accessor2 = (BiomeAccessor2)biome;
        class_4763 effects = accessor.getSpecialEffects();
        class_4763.class_4764 effectBuilder = new class_4763.class_4764();
        this.applyRequiredEffect(BiomeEffects::waterColor, () -> ((class_4763)effects).comp_5169(), arg_0 -> ((class_4763.class_4764)effectBuilder).method_24395(arg_0));
        this.applyOptionalEffect(BiomeEffects::foliageColor, () -> ((class_4763)effects).comp_5170(), arg_0 -> ((class_4763.class_4764)effectBuilder).method_30821(arg_0));
        this.applyOptionalEffect(BiomeEffects::dryFoliageColor, () -> ((class_4763)effects).comp_5171(), arg_0 -> ((class_4763.class_4764)effectBuilder).method_68149(arg_0));
        this.applyOptionalEffect(BiomeEffects::grassColor, () -> ((class_4763)effects).comp_5172(), arg_0 -> ((class_4763.class_4764)effectBuilder).method_30822(arg_0));
        this.applyRequiredEffect(BiomeEffects::grassColorModifier, () -> ((class_4763)effects).comp_5173(), arg_0 -> ((class_4763.class_4764)effectBuilder).method_30818(arg_0));
        accessor.setSpecialEffects(effectBuilder.method_24391());
        class_12199 attributes = biome.method_75734();
        class_12199.class_12200 attributeBuilder = class_12199.method_75661();
        attributeBuilder.method_75675(attributes);
        this.applyAttribute(attributeBuilder, BiomeEffects::fogColor, class_12206.field_63742);
        this.applyAttribute(attributeBuilder, BiomeEffects::waterFogColor, class_12206.field_63744);
        this.applyAttribute(attributeBuilder, BiomeEffects::skyColor, class_12206.field_63746);
        this.applyAttribute(attributeBuilder, e -> Optional.of(e.ambientParticle().map(List::of).orElse(List.of())), class_12206.field_63750);
        this.applyAttribute(attributeBuilder, e -> Optional.of(new class_12190(e.ambientSound(), e.moodSound(), e.additionsSound().map(List::of).orElse(List.of()))), class_12206.field_63753);
        this.applyAttribute(attributeBuilder, e -> Optional.of(new class_12194(e.music(), Optional.empty(), Optional.empty())), class_12206.field_63751);
        this.applyAttribute(attributeBuilder, BiomeEffects::musicVolume, class_12206.field_63752);
        accessor2.setAttributes(attributeBuilder.method_75672());
    }

    private <T> void applyRequiredEffect(Function<BiomeEffects, Optional<T>> getter, Supplier<T> fallback, Consumer<T> applier) {
        applier.accept(getter.apply(this.specialEffects).orElse(fallback.get()));
    }

    private <T> void applyOptionalEffect(Function<BiomeEffects, Optional<T>> getter, Supplier<Optional<T>> fallback, Consumer<T> applier) {
        Object value = getter.apply(this.specialEffects).orElse(fallback.get().orElse(null));
        if (value != null) {
            applier.accept(value);
        }
    }

    private <T> void applyAttribute(class_12199.class_12200 builder, Function<BiomeEffects, Optional<T>> getter, class_12197<T> attribute) {
        Optional<Object> value = getter.apply(this.specialEffects);
        value.ifPresent(object -> builder.method_75674(attribute, object));
    }

    @Override
    public MapCodec<? extends Modifier> codec() {
        return CODEC;
    }
}

