/*
 * Decompiled with CFR 0.152.
 */
package dev.worldgen.lithostitched.worldgen.processor;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import dev.worldgen.lithostitched.util.weighted.Weighted;
import dev.worldgen.lithostitched.util.weighted.WeightedList;
import dev.worldgen.lithostitched.worldgen.processor.RandomSettings;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Optional;
import net.minecraft.class_2338;
import net.minecraft.class_3491;
import net.minecraft.class_3492;
import net.minecraft.class_3499;
import net.minecraft.class_3828;
import net.minecraft.class_4538;
import net.minecraft.class_5281;
import net.minecraft.class_5321;
import net.minecraft.class_5497;
import net.minecraft.class_5819;
import net.minecraft.class_6880;
import net.minecraft.class_6885;
import net.minecraft.class_6895;
import net.minecraft.class_7924;
import org.jetbrains.annotations.NotNull;

public class ApplyRandomStructureProcessor
extends class_3491 {
    private static final Codec<WeightedList<class_6880<class_5497>>> WEIGHTED_LIST_CODEC = WeightedList.codec(class_3828.field_25877);
    private static final Codec<class_6885<class_5497>> SET_CODEC = class_6895.method_40341((class_5321)class_7924.field_41247, (Codec)class_3828.field_25876);
    public static final MapCodec<ApplyRandomStructureProcessor> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)Codec.withAlternative(SET_CODEC, WEIGHTED_LIST_CODEC, ApplyRandomStructureProcessor::convertToSet).fieldOf("processor_lists").forGetter(ApplyRandomStructureProcessor::processorLists), (App)RandomSettings.CODEC.fieldOf("mode").forGetter(ApplyRandomStructureProcessor::randomSettings)).apply((Applicative)instance, ApplyRandomStructureProcessor::new));
    public static final class_3828<ApplyRandomStructureProcessor> TYPE = () -> CODEC;
    private final class_6885<class_5497> processorLists;
    private final RandomSettings randomSettings;

    private static class_6885<class_5497> convertToSet(WeightedList<class_6880<class_5497>> weightedList) {
        ArrayList<class_6880<class_5497>> holders = new ArrayList<class_6880<class_5497>>();
        for (Weighted<class_6880<class_5497>> processor : weightedList.unwrap()) {
            for (int i = 0; i < processor.weight(); ++i) {
                holders.add(processor.value());
            }
        }
        return class_6885.method_40242(holders);
    }

    public ApplyRandomStructureProcessor(class_6885<class_5497> processorLists, RandomSettings randomSettings) {
        this.processorLists = processorLists;
        this.randomSettings = randomSettings;
    }

    public class_6885<class_5497> processorLists() {
        return this.processorLists;
    }

    public RandomSettings randomSettings() {
        return this.randomSettings;
    }

    public class_3499.class_3501 method_15110(class_4538 levelReader, class_2338 pos, class_2338 pivot, class_3499.class_3501 relative, class_3499.class_3501 absolute, class_3492 settings) {
        class_5281 level;
        class_5819 random;
        Optional processorList;
        if (levelReader instanceof class_5281 && (processorList = this.processorLists.method_40243(random = this.randomSettings.create(level = (class_5281)levelReader, pos, absolute))).isPresent()) {
            class_3491 processor;
            class_3499.class_3501 processedBlock = absolute;
            Iterator iterator = ((class_5497)((class_6880)processorList.get()).comp_349()).method_31027().iterator();
            while (iterator.hasNext() && (processedBlock = (processor = (class_3491)iterator.next()).method_15110(levelReader, pos, pivot, relative, processedBlock, settings)) != null) {
            }
            return processedBlock;
        }
        return absolute;
    }

    @NotNull
    protected class_3828<?> method_16772() {
        return TYPE;
    }
}

