/*
 * Decompiled with CFR 0.152.
 */
package dev.worldgen.lithostitched.mixin.common.mnbs;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.datafixers.util.Either;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.MapCodec;
import dev.worldgen.lithostitched.duck.mnbs.MNBSDuck;
import dev.worldgen.lithostitched.duck.mnbs.MNBSPLDuck;
import dev.worldgen.lithostitched.util.CodecExtender;
import java.util.List;
import java.util.Optional;
import java.util.function.Function;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.RegistryOps;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.biome.Climate;
import net.minecraft.world.level.biome.MultiNoiseBiomeSource;
import net.minecraft.world.level.biome.MultiNoiseBiomeSourceParameterList;
import net.minecraft.world.level.biome.MultiNoiseBiomeSourceParameterLists;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Mutable;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Redirect;

@Mixin(value={MultiNoiseBiomeSource.class})
public abstract class MNBSMixin
implements MNBSDuck {
    @Shadow
    @Mutable
    @Final
    private Either<Climate.ParameterList<Holder<Biome>>, Holder<MultiNoiseBiomeSourceParameterList>> parameters;

    @Override
    public Either<Climate.ParameterList<Holder<Biome>>, Holder<MultiNoiseBiomeSourceParameterList>> lithostitched$getEntries() {
        return this.parameters;
    }

    @Override
    public void lithostitched$setEntries(Either<Climate.ParameterList<Holder<Biome>>, Holder<MultiNoiseBiomeSourceParameterList>> entries) {
        this.parameters = entries;
    }

    @Redirect(method={"<clinit>"}, at=@At(value="INVOKE", target="Lcom/mojang/serialization/MapCodec;xmap(Ljava/util/function/Function;Ljava/util/function/Function;)Lcom/mojang/serialization/MapCodec;"))
    private static MapCodec<MultiNoiseBiomeSource> wrapCodec(MapCodec<Either<Climate.ParameterList<Holder<Biome>>, Holder<MultiNoiseBiomeSourceParameterList>>> original, Function<? super Either<Climate.ParameterList<Holder<Biome>>, Holder<MultiNoiseBiomeSourceParameterList>>, ? extends MultiNoiseBiomeSource> to, Function<? super MultiNoiseBiomeSource, ? extends Either<Climate.ParameterList<Holder<Biome>>, Holder<MultiNoiseBiomeSourceParameterList>>> from) {
        return CodecExtender.extend(original.xmap(to, from), (instance, wrapper) -> instance.group((App)wrapper, (App)RegistryOps.retrieveGetter((ResourceKey)Registries.MULTI_NOISE_BIOME_SOURCE_PARAMETER_LIST)).apply((Applicative)instance, (mnbs, lookup) -> {
            MNBSDuck duck = (MNBSDuck)mnbs;
            Either<Climate.ParameterList<Holder<Biome>>, Holder<MultiNoiseBiomeSourceParameterList>> biomeEntries = duck.lithostitched$getEntries();
            if (biomeEntries.left().isPresent()) {
                List rawEntries = ((Climate.ParameterList)biomeEntries.left().get()).values();
                Optional overworldPreset = lookup.get(MultiNoiseBiomeSourceParameterLists.OVERWORLD);
                if (overworldPreset.isEmpty()) {
                    return mnbs;
                }
                Optional<Holder<Biome>> migrationBiome = ((MNBSPLDuck)((Holder.Reference)overworldPreset.get()).value()).lithostitched$getMigrationBiome();
                if (migrationBiome.isPresent() && ((Holder)((Pair)rawEntries.getLast()).getSecond()).is(migrationBiome.get())) {
                    duck.lithostitched$setEntries((Either<Climate.ParameterList<Holder<Biome>>, Holder<MultiNoiseBiomeSourceParameterList>>)Either.right((Object)((Holder)overworldPreset.get())));
                }
            }
            return mnbs;
        }));
    }
}

