/*
 * Decompiled with CFR 0.152.
 */
package dev.worldgen.lithostitched.worldgen.bandlands.band;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import dev.worldgen.lithostitched.worldgen.bandlands.band.Band;
import net.minecraft.util.RandomSource;
import net.minecraft.util.valueproviders.IntProvider;
import net.minecraft.world.level.block.state.BlockState;

public record WrappedBand(IntProvider interval, IntProvider maxCount, float wrapperChance, BlockState wrapperState, BlockState wrappedState) implements Band
{
    public static final MapCodec<WrappedBand> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)IntProvider.POSITIVE_CODEC.fieldOf("interval").forGetter(WrappedBand::interval), (App)IntProvider.POSITIVE_CODEC.fieldOf("max_count").forGetter(WrappedBand::maxCount), (App)Codec.floatRange((float)0.0f, (float)1.0f).fieldOf("wrapper_chance").forGetter(WrappedBand::wrapperChance), (App)BlockState.CODEC.fieldOf("wrapper_state").forGetter(WrappedBand::wrapperState), (App)BlockState.CODEC.fieldOf("wrapped_state").forGetter(WrappedBand::wrappedState)).apply((Applicative)instance, WrappedBand::new));

    @Override
    public void fill(BlockState[] states, RandomSource random) {
        int count = 0;
        int maxCount = this.maxCount.sample(random);
        for (int i = 0; count < maxCount && i < states.length; ++count, i += this.interval.sample(random)) {
            states[i] = this.wrappedState;
            if (i - 1 > 0 && random.nextFloat() < this.wrapperChance) {
                states[i - 1] = this.wrapperState;
            }
            if (i + 1 >= states.length || !(random.nextFloat() < this.wrapperChance)) continue;
            states[i + 1] = this.wrapperState;
        }
    }

    @Override
    public MapCodec<? extends Band> codec() {
        return CODEC;
    }
}

