/*
 * Decompiled with CFR 0.152.
 */
package dev.worldgen.lithostitched.worldgen.structure;

import com.mojang.serialization.Codec;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.level.LevelHeightAccessor;
import net.minecraft.world.level.NoiseColumn;
import net.minecraft.world.level.levelgen.RandomState;
import net.minecraft.world.level.levelgen.structure.Structure;

public enum SurfaceSnap implements StringRepresentable
{
    CEILING("ceiling", 1),
    FLOOR("floor", -1);

    public static final Codec<SurfaceSnap> CODEC;
    private final String name;
    private final int offset;

    private SurfaceSnap(String name, int offset) {
        this.name = name;
        this.offset = offset;
    }

    public Optional<Integer> findY(BlockPos pos, Structure.GenerationContext context, LevelHeightAccessor heightAccessor, RandomState randomState) {
        NoiseColumn column = context.chunkGenerator().getBaseColumn(pos.getX(), pos.getZ(), heightAccessor, randomState);
        int y = pos.getY();
        boolean lastCheckSolid = true;
        while (!heightAccessor.isOutsideBuildHeight(y)) {
            boolean thisCheckSolid = column.getBlock(y += this.offset).isSolid();
            if (!lastCheckSolid && thisCheckSolid) {
                return Optional.of(y);
            }
            lastCheckSolid = thisCheckSolid;
        }
        return Optional.empty();
    }

    public String getSerializedName() {
        return this.name;
    }

    static {
        CODEC = StringRepresentable.fromEnum(SurfaceSnap::values);
    }
}

