/*
 * Decompiled with CFR 0.152.
 */
package dev.worldgen.lithostitched.worldgen.placementcondition;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import dev.worldgen.lithostitched.mixin.common.RandomStateAccessor;
import dev.worldgen.lithostitched.worldgen.placementcondition.PlacementCondition;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.levelgen.DensityFunction;
import net.minecraft.world.level.levelgen.DensityFunctions;
import net.minecraft.world.level.levelgen.LegacyRandomSource;
import net.minecraft.world.level.levelgen.NoiseBasedChunkGenerator;
import net.minecraft.world.level.levelgen.NoiseGeneratorSettings;
import net.minecraft.world.level.levelgen.Noises;
import net.minecraft.world.level.levelgen.PositionalRandomFactory;
import net.minecraft.world.level.levelgen.RandomState;
import net.minecraft.world.level.levelgen.synth.BlendedNoise;
import net.minecraft.world.level.levelgen.synth.NormalNoise;

public record SampleDensityPlacementCondition(Holder<DensityFunction> densityFunction, Optional<Double> minInclusive, Optional<Double> maxInclusive) implements PlacementCondition
{
    public static final MapCodec<SampleDensityPlacementCondition> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)DensityFunction.CODEC.fieldOf("density_function").forGetter(SampleDensityPlacementCondition::densityFunction), (App)Codec.DOUBLE.optionalFieldOf("min_inclusive").forGetter(SampleDensityPlacementCondition::minInclusive), (App)Codec.DOUBLE.optionalFieldOf("max_inclusive").forGetter(SampleDensityPlacementCondition::maxInclusive)).apply((Applicative)instance, SampleDensityPlacementCondition::new));

    @Override
    public boolean test(PlacementCondition.Context context, BlockPos pos) {
        ChunkGenerator chunkGenerator = context.generator();
        if (!(chunkGenerator instanceof NoiseBasedChunkGenerator)) {
            return false;
        }
        NoiseBasedChunkGenerator chunkGenerator2 = (NoiseBasedChunkGenerator)chunkGenerator;
        DensityFunction df = ((DensityFunction)this.densityFunction.value()).mapAll((DensityFunction.Visitor)new NoiseWiringHelper(context.seed(), ((NoiseGeneratorSettings)chunkGenerator2.settings.value()).useLegacyRandomSource(), context.randomState(), ((RandomStateAccessor)context.randomState()).getRandom()));
        double density = df.compute((DensityFunction.FunctionContext)new DensityFunction.SinglePointContext(pos.getX(), pos.getY(), pos.getZ()));
        boolean min = this.minInclusive.isEmpty() || density >= this.minInclusive.get();
        boolean max = this.maxInclusive.isEmpty() || density <= this.maxInclusive.get();
        return min && max;
    }

    @Override
    public MapCodec<? extends PlacementCondition> codec() {
        return CODEC;
    }

    private static class NoiseWiringHelper
    implements DensityFunction.Visitor {
        private final Map<DensityFunction, DensityFunction> wrapped = new HashMap<DensityFunction, DensityFunction>();
        private final boolean useLegacySource;
        private final long seed;
        final RandomState randomState;
        final PositionalRandomFactory random;

        private RandomSource newLegacyInstance(long noiseSeed) {
            return new LegacyRandomSource(this.seed + noiseSeed);
        }

        NoiseWiringHelper(long seed, boolean useLegacySource, RandomState randomState, PositionalRandomFactory random) {
            this.seed = seed;
            this.useLegacySource = useLegacySource;
            this.randomState = randomState;
            this.random = random;
        }

        public DensityFunction.NoiseHolder visitNoise(DensityFunction.NoiseHolder noiseHolder) {
            Holder noiseData = noiseHolder.noiseData();
            if (this.useLegacySource) {
                if (noiseData.is(Noises.TEMPERATURE)) {
                    NormalNoise noise = NormalNoise.createLegacyNetherBiome((RandomSource)this.newLegacyInstance(0L), (NormalNoise.NoiseParameters)new NormalNoise.NoiseParameters(-7, 1.0, new double[]{1.0}));
                    return new DensityFunction.NoiseHolder(noiseData, noise);
                }
                if (noiseData.is(Noises.VEGETATION)) {
                    NormalNoise noise = NormalNoise.createLegacyNetherBiome((RandomSource)this.newLegacyInstance(1L), (NormalNoise.NoiseParameters)new NormalNoise.NoiseParameters(-7, 1.0, new double[]{1.0}));
                    return new DensityFunction.NoiseHolder(noiseData, noise);
                }
                if (noiseData.is(Noises.SHIFT)) {
                    NormalNoise noise = NormalNoise.create((RandomSource)this.random.fromHashOf(Noises.SHIFT.location()), (NormalNoise.NoiseParameters)new NormalNoise.NoiseParameters(0, 0.0, new double[0]));
                    return new DensityFunction.NoiseHolder(noiseData, noise);
                }
            }
            NormalNoise noise = this.randomState.getOrCreateNoise((ResourceKey)noiseData.unwrapKey().orElseThrow());
            return new DensityFunction.NoiseHolder(noiseData, noise);
        }

        private DensityFunction wrapNew(DensityFunction densityFunction) {
            if (densityFunction instanceof BlendedNoise) {
                BlendedNoise $$1 = (BlendedNoise)densityFunction;
                RandomSource $$2x = this.useLegacySource ? this.newLegacyInstance(0L) : this.random.fromHashOf(ResourceLocation.withDefaultNamespace((String)"terrain"));
                return $$1.withNewRandom($$2x);
            }
            return densityFunction instanceof DensityFunctions.EndIslandDensityFunction ? new DensityFunctions.EndIslandDensityFunction(this.seed) : densityFunction;
        }

        public DensityFunction apply(DensityFunction densityFunction) {
            return this.wrapped.computeIfAbsent(densityFunction, this::wrapNew);
        }
    }
}

