/*
 * Decompiled with CFR 0.152.
 */
package dev.worldgen.lithostitched.worldgen.stateprovider;

import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import net.minecraft.core.BlockPos;
import net.minecraft.util.RandomSource;
import net.minecraft.util.random.SimpleWeightedRandomList;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.feature.stateproviders.BlockStateProvider;
import net.minecraft.world.level.levelgen.feature.stateproviders.BlockStateProviderType;
import org.jetbrains.annotations.NotNull;

public final class WeightedProvider
extends BlockStateProvider {
    public static final MapCodec<WeightedProvider> CODEC = SimpleWeightedRandomList.wrappedCodec((Codec)BlockStateProvider.CODEC).fieldOf("entries").xmap(WeightedProvider::new, WeightedProvider::providers);
    public static final BlockStateProviderType<WeightedProvider> TYPE = new BlockStateProviderType(CODEC);
    private final SimpleWeightedRandomList<BlockStateProvider> providers;

    public WeightedProvider(SimpleWeightedRandomList<BlockStateProvider> providers) {
        this.providers = providers;
    }

    public SimpleWeightedRandomList<BlockStateProvider> providers() {
        return this.providers;
    }

    @NotNull
    protected BlockStateProviderType<?> type() {
        return TYPE;
    }

    @NotNull
    public BlockState getState(@NotNull RandomSource random, @NotNull BlockPos pos) {
        return this.providers.getRandomValue(random).map(provider -> provider.getState(random, pos)).orElse(Blocks.AIR.defaultBlockState());
    }
}

