/*
 * Decompiled with CFR 0.152.
 */
package dev.worldgen.lithostitched.worldgen.modifier;

import com.google.common.base.Suppliers;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import dev.worldgen.lithostitched.LithostitchedCommon;
import dev.worldgen.lithostitched.mixin.common.ChunkGeneratorAccessor;
import dev.worldgen.lithostitched.registry.LithostitchedRegistryKeys;
import dev.worldgen.lithostitched.worldgen.modifier.PriorityBasedModifier;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Optional;
import java.util.function.Function;
import java.util.function.Supplier;
import net.minecraft.class_1959;
import net.minecraft.class_1966;
import net.minecraft.class_2378;
import net.minecraft.class_3542;
import net.minecraft.class_5363;
import net.minecraft.class_5455;
import net.minecraft.class_6880;
import net.minecraft.class_7510;
import net.minecraft.class_7923;
import net.minecraft.class_7924;
import net.minecraft.server.MinecraftServer;
import org.jetbrains.annotations.NotNull;

public interface Modifier {
    public static final Codec<Modifier> CODEC = Codec.lazyInitialized(() -> {
        Optional modifierRegistry = class_7923.field_41167.method_10223(LithostitchedRegistryKeys.MODIFIER_TYPE.method_29177());
        if (modifierRegistry.isEmpty()) {
            throw new NullPointerException("Worldgen modifier registry does not exist yet!");
        }
        return ((class_2378)((class_6880.class_6883)modifierRegistry.get()).comp_349()).method_39673();
    }).dispatch(Modifier::codec, Function.identity());

    default public void applyModifier(class_5455 registryAccess) {
        this.applyModifier();
    }

    public void applyModifier();

    public ModifierPhase getPhase();

    public MapCodec<? extends Modifier> codec();

    public static void applyModifiers(MinecraftServer server) {
        boolean fabricFeaturesModified = false;
        class_5455.class_6890 registries = server.method_30611();
        class_2378 modifiers = registries.method_30530(LithostitchedRegistryKeys.WORLDGEN_MODIFIER);
        for (ModifierPhase phase : ModifierPhase.values()) {
            if (phase == ModifierPhase.NONE) continue;
            List<class_6880.class_6883<Modifier>> phaseModifiers = modifiers.method_42017().filter(m -> ((Modifier)m.comp_349()).getPhase() == phase).toList();
            Modifier.applyPhaseModifiers((class_5455)registries, phaseModifiers);
            if (phaseModifiers.stream().filter(holder -> ((Modifier)holder.comp_349()).internal$modifiesFabricFeatures()).toList().isEmpty()) continue;
            fabricFeaturesModified = true;
        }
        if (fabricFeaturesModified) {
            class_2378 dimensions = registries.method_30530(class_7924.field_41224);
            for (class_5363 dimension : dimensions) {
                ChunkGeneratorAccessor accessor = (ChunkGeneratorAccessor)dimension.comp_1013();
                class_1966 source = accessor.getBiomeSource();
                accessor.setFeaturesPerStep((Supplier<List<class_7510.class_6827>>)Suppliers.memoize(() -> class_7510.method_44210(List.copyOf(source.method_28443()), biome -> accessor.getGetter().apply((class_6880<class_1959>)biome).method_30983(), (boolean)true)));
            }
        }
    }

    private static void applyPhaseModifiers(class_5455 registries, List<class_6880.class_6883<Modifier>> phaseModifiers) {
        ArrayList<class_6880.class_6883<PriorityBasedModifier>> priorityBasedModifiers = new ArrayList<class_6880.class_6883<PriorityBasedModifier>>();
        for (class_6880.class_6883<Modifier> class_68832 : phaseModifiers) {
            if (class_68832.comp_349() instanceof PriorityBasedModifier) {
                priorityBasedModifiers.add(class_68832);
                continue;
            }
            LithostitchedCommon.debug("Applying modifier with id: {}", class_68832.method_40237().method_29177());
            ((Modifier)class_68832.comp_349()).applyModifier(registries);
        }
        for (class_6880.class_6883<Modifier> class_68833 : Modifier.sortByPriority(priorityBasedModifiers)) {
            LithostitchedCommon.debug("Applying modifier with id: {}", class_68833.method_40237().method_29177());
            ((PriorityBasedModifier)class_68833.comp_349()).applyModifier(registries);
        }
    }

    public static List<class_6880.class_6883<PriorityBasedModifier>> sortByPriority(List<class_6880.class_6883<PriorityBasedModifier>> modifiers) {
        return modifiers.stream().sorted(Comparator.comparingInt(reference -> ((PriorityBasedModifier)reference.comp_349()).getPriority())).toList();
    }

    default public boolean internal$modifiesFabricFeatures() {
        return false;
    }

    public static enum ModifierPhase implements class_3542
    {
        NONE("none"),
        BEFORE_ALL("before_all"),
        REPLACE("replace"),
        ADD("add"),
        REMOVE("remove"),
        MODIFY("modify"),
        AFTER_ALL("after_all");

        private final String name;

        private ModifierPhase(String name) {
            this.name = name;
        }

        @NotNull
        public String method_15434() {
            return this.name;
        }
    }
}

