/*
 * Decompiled with CFR 0.152.
 */
package ru.xishnikus.thedawnera.client;

import com.google.common.reflect.Reflection;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.inventory.CreativeModeInventoryScreen;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.item.ItemProperties;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleType;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.Container;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.EntityRenderersEvent;
import net.minecraftforge.client.event.RegisterParticleProvidersEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import ru.astemir.astemirlib.common.handler.ClientLevelEventHandler;
import ru.astemir.astemirlib.common.handler.LevelEventMap;
import ru.astemir.astemirlib.common.math.Color;
import ru.astemir.astemirlib.common.math.RandomUtils;
import ru.astemir.astemirlib.common.network.PacketArgument;
import ru.xishnikus.thedawnera.client.event.ClientEventListener;
import ru.xishnikus.thedawnera.client.gui.screen.DinoInteractScreen;
import ru.xishnikus.thedawnera.client.gui.screen.DinoInventoryScreen;
import ru.xishnikus.thedawnera.client.misc.ShakeController;
import ru.xishnikus.thedawnera.client.particle.DripBloodParticle;
import ru.xishnikus.thedawnera.client.particle.SpitParticle;
import ru.xishnikus.thedawnera.client.particle.WaterSplashParticle;
import ru.xishnikus.thedawnera.client.particle.WindParticle;
import ru.xishnikus.thedawnera.client.render.entity.TDEFallingTreeRenderer;
import ru.xishnikus.thedawnera.client.render.entity.misc.DiplorangModel;
import ru.xishnikus.thedawnera.client.render.entity.mobs.AegirocassisModel;
import ru.xishnikus.thedawnera.client.render.entity.mobs.AlligatorGarModel;
import ru.xishnikus.thedawnera.client.render.entity.mobs.CeratosaurusModel;
import ru.xishnikus.thedawnera.client.render.entity.mobs.CoelacanthModel;
import ru.xishnikus.thedawnera.client.render.entity.mobs.DeinonychusModel;
import ru.xishnikus.thedawnera.client.render.entity.mobs.DiabloceratopsModel;
import ru.xishnikus.thedawnera.client.render.entity.mobs.DimorphodonModel;
import ru.xishnikus.thedawnera.client.render.entity.mobs.DiplocaulusModel;
import ru.xishnikus.thedawnera.client.render.entity.mobs.DodoModel;
import ru.xishnikus.thedawnera.client.render.entity.mobs.DunkleosteusModel;
import ru.xishnikus.thedawnera.client.render.entity.mobs.MixosaurusModel;
import ru.xishnikus.thedawnera.client.render.entity.mobs.PondSnailModel;
import ru.xishnikus.thedawnera.client.render.entity.mobs.PsittacosaurusModel;
import ru.xishnikus.thedawnera.client.render.entity.mobs.SabertoothSalmonModel;
import ru.xishnikus.thedawnera.client.render.entity.mobs.SachicasaurusModel;
import ru.xishnikus.thedawnera.client.render.entity.mobs.StruthiomimusModel;
import ru.xishnikus.thedawnera.client.render.entity.mobs.SturgeonModel;
import ru.xishnikus.thedawnera.client.render.entity.mobs.TriceratopsModel;
import ru.xishnikus.thedawnera.client.render.entity.mobs.TyrannosaurusModel;
import ru.xishnikus.thedawnera.client.render.entity.mobs.WormModel;
import ru.xishnikus.thedawnera.common.TDELevelEvents;
import ru.xishnikus.thedawnera.common.entity.TDEEntities;
import ru.xishnikus.thedawnera.common.entity.entity.base.BaseAnimal;
import ru.xishnikus.thedawnera.common.item.TDEItems;
import ru.xishnikus.thedawnera.common.menu.DinoInventoryMenu;
import ru.xishnikus.thedawnera.common.misc.BloodColor;
import ru.xishnikus.thedawnera.common.particle.BloodParticleOptions;
import ru.xishnikus.thedawnera.common.particle.TDEParticleTypes;
import ru.xishnikus.thedawnera.common.utils.TDEUtils;

@Mod.EventBusSubscriber(modid="dawnera", bus=Mod.EventBusSubscriber.Bus.MOD, value={Dist.CLIENT})
public class TDEClientProxy
implements ClientLevelEventHandler {
    private static final LevelEventMap CLIENT_EVENTS = LevelEventMap.create().registerEvent(TDELevelEvents.EVENT_SHAKE_SCREEN, (pos, level, args) -> {
        int ticks = args[0].asInt();
        double power = args[1].asDouble();
        ShakeController.shake(ticks, (float)power);
    }).registerEvent(TDELevelEvents.EVENT_TAME, (pos, level, args) -> {
        block4: {
            int tamerId = args[0].asInt();
            int tamedId = args[1].asInt();
            boolean success = args[2].asBoolean();
            Entity tamed = level.m_6815_(tamedId);
            if (tamed == null) break block4;
            float width = tamed.m_20205_() * 0.75f;
            float height = tamed.m_20206_() * 0.75f;
            if (success) {
                for (int i = 0; i < 10; ++i) {
                    level.m_7106_((ParticleOptions)ParticleTypes.f_123750_, tamed.m_20185_() + (double)RandomUtils.randomFloat((float)(-width), (float)width), tamed.m_20186_() + (double)RandomUtils.randomFloat((float)0.0f, (float)height), tamed.m_20189_() + (double)RandomUtils.randomFloat((float)(-width), (float)width), 0.0, 0.0, 0.0);
                }
            } else {
                for (int i = 0; i < 10; ++i) {
                    level.m_7106_((ParticleOptions)ParticleTypes.f_123762_, tamed.m_20185_() + (double)RandomUtils.randomFloat((float)(-width), (float)width), tamed.m_20186_() + (double)RandomUtils.randomFloat((float)0.0f, (float)height), tamed.m_20189_() + (double)RandomUtils.randomFloat((float)(-width), (float)width), 0.0, 0.0, 0.0);
                }
            }
        }
    }).registerEvent(TDELevelEvents.EVENT_MOUNT, (pos, level, args) -> {
        int entityId = args[0].asInt();
        int vehicleId = args[1].asInt();
        Entity entity = level.m_6815_(entityId);
        Entity vehicle = level.m_6815_(vehicleId);
        if (entity != null && vehicle != null) {
            entity.m_7998_(vehicle, true);
        }
    }).registerEvent(TDELevelEvents.EVENT_UNMOUNT, (pos, level, args) -> {
        int entityId = args[0].asInt();
        Entity entity = level.m_6815_(entityId);
        if (entity != null) {
            entity.m_8127_();
        }
    }).registerEvent(TDELevelEvents.EVENT_EAT, (pos, level, args) -> {
        int id = args[0].asInt();
        ItemStack itemStack = args[1].asItemStack();
        Entity entity = level.m_6815_(id);
        if (entity instanceof BaseAnimal) {
            BaseAnimal baseAnimal = (BaseAnimal)entity;
            baseAnimal.setLastEatenFood(itemStack);
        }
    }).registerEvent(TDELevelEvents.EVENT_OPEN_MOB_INTERACT_SCREEN, (pos, level, args) -> {
        int mobId = args[0].asInt();
        BaseAnimal mob = (BaseAnimal)level.m_6815_(mobId);
        if (mob != null) {
            Minecraft.m_91087_().m_91152_((Screen)new DinoInteractScreen.Main(mob));
        }
    }).registerEvent(TDELevelEvents.EVENT_BLEEDING_PARTICLE, (pos, level, args) -> {
        int mobId = args[0].asInt();
        LivingEntity livingEntity = (LivingEntity)level.m_6815_(mobId);
        for (int i = 0; i < 2; ++i) {
            Color color = BloodColor.get(livingEntity, 1.0f);
            Color.HSV hsv = color.getHSV();
            hsv.s = RandomUtils.randomFloat((float)0.8f, (float)1.0f);
            hsv.v = RandomUtils.randomFloat((float)hsv.v, (float)(hsv.v + 0.4f));
            level.m_7106_((ParticleOptions)new BloodParticleOptions(TDEUtils.colorFromHSV(hsv).toVec3().m_252839_(), 1.0f), livingEntity.m_20185_() + (double)RandomUtils.randomFloat((float)(-livingEntity.m_20205_() / 2.0f), (float)(livingEntity.m_20205_() / 2.0f)), livingEntity.m_20186_() + (double)RandomUtils.randomFloat((float)(livingEntity.m_20206_() * 0.25f), (float)(livingEntity.m_20206_() * 0.75f)), livingEntity.m_20189_() + (double)RandomUtils.randomFloat((float)(-livingEntity.m_20205_() / 2.0f), (float)(livingEntity.m_20205_() / 2.0f)), (double)RandomUtils.randomFloat((float)-0.1f, (float)0.1f), 0.0, (double)RandomUtils.randomFloat((float)-0.1f, (float)0.1f));
        }
    }).registerEvent(TDELevelEvents.EVENT_BLEEDING_UPDATE, (pos, level, args) -> {
        int mobId = args[0].asInt();
        LivingEntity livingEntity = (LivingEntity)level.m_6815_(mobId);
        if (livingEntity instanceof LocalPlayer) {
            LocalPlayer localPlayer = (LocalPlayer)livingEntity;
            localPlayer.f_108605_ = false;
            if (ClientEventListener.bleedingTicks <= 0) {
                ClientEventListener.bleedingTicks = 40;
            }
        }
    }).registerEvent(TDELevelEvents.EVENT_OPEN_MOB_INVENTORY_SCREEN, (pos, level, args) -> {
        int mobId = args[0].asInt();
        int containerId = args[1].asInt();
        int containerSize = args[2].asInt();
        BaseAnimal mob = (BaseAnimal)level.m_6815_(mobId);
        if (mob != null) {
            LocalPlayer localplayer = Minecraft.m_91087_().f_91074_;
            SimpleContainer simplecontainer = new SimpleContainer(containerSize);
            DinoInventoryMenu dinoInventoryMenu = new DinoInventoryMenu(containerId, localplayer.m_150109_(), (Container)simplecontainer, mob);
            localplayer.f_36096_ = dinoInventoryMenu;
            Minecraft.m_91087_().m_91152_((Screen)new DinoInventoryScreen(dinoInventoryMenu, localplayer.m_150109_(), mob));
        }
    });

    public void onHandleEvent(ClientLevel clientLevel, BlockPos blockPos, int id, PacketArgument[] packetArguments) {
        CLIENT_EVENTS.handleEvent(id, (Level)clientLevel, blockPos, packetArguments);
    }

    public static void onClientInit() {
        Reflection.initialize((Class[])new Class[]{CreativeModeInventoryScreen.class});
        ItemProperties.register((Item)((Item)TDEItems.BONE_WHISTLE.get()), (ResourceLocation)new ResourceLocation("tooting"), (itemStack, level, entity, useTime) -> entity != null && entity.m_6117_() && entity.m_21211_() == itemStack ? 1.0f : 0.0f);
    }

    @SubscribeEvent
    public static void onRenderRegister(EntityRenderersEvent.RegisterRenderers e) {
        e.registerEntityRenderer((EntityType)TDEEntities.TRICERATOPS.get(), TriceratopsModel::createRenderer);
        e.registerEntityRenderer((EntityType)TDEEntities.PSITTACOSAURUS.get(), PsittacosaurusModel::createRenderer);
        e.registerEntityRenderer((EntityType)TDEEntities.TYRANNOSAURUS.get(), TyrannosaurusModel::createRenderer);
        e.registerEntityRenderer((EntityType)TDEEntities.SACHICASAURUS.get(), SachicasaurusModel::createRenderer);
        e.registerEntityRenderer((EntityType)TDEEntities.CERATOSAURUS.get(), CeratosaurusModel::createRenderer);
        e.registerEntityRenderer((EntityType)TDEEntities.DUNKLEOSTEUS.get(), DunkleosteusModel::createRenderer);
        e.registerEntityRenderer((EntityType)TDEEntities.STRUTHIOMIMUS.get(), StruthiomimusModel::createRenderer);
        e.registerEntityRenderer((EntityType)TDEEntities.STURGEON.get(), SturgeonModel::createRenderer);
        e.registerEntityRenderer((EntityType)TDEEntities.MIXOSAURUS.get(), MixosaurusModel::createRenderer);
        e.registerEntityRenderer((EntityType)TDEEntities.ALLIGATOR_GAR.get(), AlligatorGarModel::createRenderer);
        e.registerEntityRenderer((EntityType)TDEEntities.SABERTOOTH_SALMON.get(), SabertoothSalmonModel::createRenderer);
        e.registerEntityRenderer((EntityType)TDEEntities.COELACANTH.get(), CoelacanthModel::createRenderer);
        e.registerEntityRenderer((EntityType)TDEEntities.WORM.get(), WormModel::createRenderer);
        e.registerEntityRenderer((EntityType)TDEEntities.DIABLOCERATOPS.get(), DiabloceratopsModel::createRenderer);
        e.registerEntityRenderer((EntityType)TDEEntities.DIMORPHODON.get(), DimorphodonModel::createRenderer);
        e.registerEntityRenderer((EntityType)TDEEntities.DEINONYCHUS.get(), DeinonychusModel::createRenderer);
        e.registerEntityRenderer((EntityType)TDEEntities.DIPLOCAULUS.get(), DiplocaulusModel::createRenderer);
        e.registerEntityRenderer((EntityType)TDEEntities.DODO.get(), DodoModel::createRenderer);
        e.registerEntityRenderer((EntityType)TDEEntities.POND_SNAIL.get(), PondSnailModel::createRenderer);
        e.registerEntityRenderer((EntityType)TDEEntities.DIPLORANG.get(), DiplorangModel::createRenderer);
        e.registerEntityRenderer((EntityType)TDEEntities.AEGIROCASSIS.get(), AegirocassisModel::createRenderer);
        e.registerEntityRenderer((EntityType)TDEEntities.FALLING_TREE.get(), TDEFallingTreeRenderer::new);
    }

    @SubscribeEvent
    public static void onParticleRegister(RegisterParticleProvidersEvent e) {
        e.registerSpriteSet((ParticleType)TDEParticleTypes.SPIT.get(), SpitParticle.Provider::new);
        e.registerSpriteSet((ParticleType)TDEParticleTypes.WIND.get(), WindParticle.Provider::new);
        e.registerSpriteSet((ParticleType)TDEParticleTypes.WATER_SPLASH.get(), WaterSplashParticle.Provider::new);
        e.registerSpriteSet((ParticleType)TDEParticleTypes.DRIP_BLOOD.get(), DripBloodParticle.Provider::new);
    }
}

