/*
 * Decompiled with CFR 0.152.
 */
package ru.xishnikus.thedawnera.client.event;

import com.mojang.blaze3d.Blaze3D;
import com.mojang.blaze3d.vertex.PoseStack;
import net.minecraft.client.Minecraft;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import ru.astemir.astemirlib.common.math.Color;
import ru.astemir.astemirlib.common.math.MathUtils;
import ru.xishnikus.thedawnera.client.event.AdvancementRenderEvent;
import ru.xishnikus.thedawnera.client.render.AdvancedRenderer;
import ru.xishnikus.thedawnera.client.render.TDEShaders;
import ru.xishnikus.thedawnera.common.advancement.TDEAdvancements;

@Mod.EventBusSubscriber(modid="dawnera", bus=Mod.EventBusSubscriber.Bus.FORGE, value={Dist.CLIENT})
public class AdvancementEventListener {
    private static final AdvancedRenderer.Sprite SPRITE_DAWNERA = AdvancedRenderer.sprite(AdvancedRenderer.texture(256.0f, 256.0f, new ResourceLocation("dawnera", "textures/gui/misc/icon.png")).build(), 160.0f, 90.0f).centered().uv(AdvancedRenderer.rect(0.0f, 0.0f, 160.0f, 90.0f)).build();
    private static final AdvancedRenderer.Sprite SPRITE_NAIVITY_ITSELF = AdvancedRenderer.sprite(AdvancedRenderer.texture(16.0f, 16.0f, new ResourceLocation("dawnera", "textures/gui/advancements/icons/naivity_itself.png")).build(), 16.0f, 16.0f).centered().build();
    private static final AdvancedRenderer.Sprite SPRITE_LONG_LIVE_THE_KING = AdvancedRenderer.sprite(AdvancedRenderer.texture(16.0f, 16.0f, new ResourceLocation("dawnera", "textures/gui/advancements/icons/long_live_the_king.png")).build(), 16.0f, 16.0f).centered().shader(TDEShaders::getSpriteGlint).build();
    private static final AdvancedRenderer.Sprite SPRITE_NO_KING_RULES_FOREVER = AdvancedRenderer.sprite(AdvancedRenderer.texture(16.0f, 16.0f, new ResourceLocation("dawnera", "textures/gui/advancements/icons/no_king_rules_forever.png")).build(), 16.0f, 16.0f).centered().shader(TDEShaders::getSpriteGlint).build();
    private static final AdvancedRenderer.Sprite SPRITE_LIVING_FOSSIL = AdvancedRenderer.sprite(AdvancedRenderer.texture(16.0f, 16.0f, new ResourceLocation("dawnera", "textures/gui/advancements/icons/living_fossil.png")).build(), 16.0f, 16.0f).centered().shader(TDEShaders::getSpriteGlint).build();

    @SubscribeEvent
    public static void onRenderAdvancementPageIcon(AdvancementRenderEvent.PageIcon e) {
        if (e.advancement().m_138327_().equals((Object)TDEAdvancements.THE_DAWN_ERA)) {
            PoseStack poseStack = e.graphics().m_280168_();
            poseStack.m_85836_();
            AdvancedRenderer.drawSprite(poseStack, SPRITE_DAWNERA, (float)(e.getX() + 8), (float)(e.getY() + 8), 0.1325f, 0.1325f, 0.0f, 0.0f, Color.WHITE);
            poseStack.m_85849_();
        }
    }

    @SubscribeEvent
    public static void onRenderAdvancementIcon(AdvancementRenderEvent.ElementIcon e) {
        float time = (float)Blaze3D.m_83640_();
        PoseStack poseStack = e.graphics().m_280168_();
        poseStack.m_85836_();
        if (e.advancement().m_138327_().equals((Object)TDEAdvancements.THE_DAWN_ERA)) {
            float scale = 0.1125f + MathUtils.abs((float)MathUtils.sin((float)(time * 4.0f * 0.75f))) / 40.0f;
            AdvancedRenderer.drawSprite(poseStack, SPRITE_DAWNERA, (float)(e.getX() + e.getScrollX() + 16), (float)(e.getY() + e.getScrollY() + 12), scale, scale, 0.0f, 0.0f, Color.WHITE);
        }
        if (e.advancement().m_138327_().equals((Object)TDEAdvancements.LONG_LIVE_THE_KING)) {
            AdvancedRenderer.drawSprite(poseStack, SPRITE_LONG_LIVE_THE_KING, (float)(e.getX() + e.getScrollX() + 15), (float)(e.getY() + e.getScrollY() + 13), 1.3f, 1.3f, 0.0f, 0.0f, Color.WHITE);
        }
        if (e.advancement().m_138327_().equals((Object)TDEAdvancements.NO_KING_RULES_FOREVER)) {
            AdvancedRenderer.drawSprite(poseStack, SPRITE_NO_KING_RULES_FOREVER, (float)(e.getX() + e.getScrollX() + 15), (float)(e.getY() + e.getScrollY() + 13), 1.3f, 1.3f, 0.0f, 0.0f, Color.WHITE);
        }
        if (e.advancement().m_138327_().equals((Object)TDEAdvancements.LIVING_FOSSIL)) {
            AdvancedRenderer.drawSprite(poseStack, SPRITE_LIVING_FOSSIL, (float)(e.getX() + e.getScrollX() + 16), (float)(e.getY() + e.getScrollY() + 13), 1.3f, 1.3f, 0.0f, 0.0f, Color.WHITE);
        }
        if (e.advancement().m_138327_().equals((Object)TDEAdvancements.NAIVETY_ITSELF)) {
            AdvancedRenderer.drawSprite(poseStack, SPRITE_NAIVITY_ITSELF, (float)(e.getX() + e.getScrollX() + 16), (float)(e.getY() + e.getScrollY() + 13), 1.15f, 1.15f, 0.0f, 0.0f, Color.WHITE);
        }
        poseStack.m_85849_();
    }

    @SubscribeEvent
    public static void onRenderToastAdvancement(AdvancementRenderEvent.Toast e) {
        float time = (float)Blaze3D.m_83640_();
        PoseStack poseStack = e.graphics().m_280168_();
        poseStack.m_85836_();
        if (e.advancement().m_138327_().equals((Object)TDEAdvancements.THE_DAWN_ERA)) {
            float scale = 0.1225f + MathUtils.abs((float)MathUtils.sin((float)(time * 4.0f * 0.75f))) / 40.0f;
            float showTime = (float)e.getShowTime() + Minecraft.m_91087_().getPartialTick();
            float rotation = showTime < 360.0f ? MathUtils.clamp((float)showTime, (float)0.0f, (float)360.0f) / 40.0f : 0.0f;
            AdvancedRenderer.drawSprite(poseStack, SPRITE_DAWNERA, 16.0f, 16.0f, scale, scale, rotation, 0.0f, Color.WHITE);
        }
        if (e.advancement().m_138327_().equals((Object)TDEAdvancements.LONG_LIVE_THE_KING)) {
            AdvancedRenderer.drawSprite(poseStack, SPRITE_LONG_LIVE_THE_KING, 16.0f, 16.0f, 1.3f, 1.3f, 0.0f, 0.0f, Color.WHITE);
        }
        if (e.advancement().m_138327_().equals((Object)TDEAdvancements.NO_KING_RULES_FOREVER)) {
            AdvancedRenderer.drawSprite(poseStack, SPRITE_NO_KING_RULES_FOREVER, 16.0f, 16.0f, 1.3f, 1.3f, 0.0f, 0.0f, Color.WHITE);
        }
        if (e.advancement().m_138327_().equals((Object)TDEAdvancements.LIVING_FOSSIL)) {
            AdvancedRenderer.drawSprite(poseStack, SPRITE_LIVING_FOSSIL, 16.0f, 16.0f, 1.3f, 1.3f, 0.0f, 0.0f, Color.WHITE);
        }
        if (e.advancement().m_138327_().equals((Object)TDEAdvancements.NAIVETY_ITSELF)) {
            AdvancedRenderer.drawSprite(poseStack, SPRITE_NAIVITY_ITSELF, 16.0f, 16.0f, 1.15f, 1.15f, 0.0f, 0.0f, Color.WHITE);
        }
        poseStack.m_85849_();
    }
}

