/*
 * Decompiled with CFR 0.152.
 */
package ru.xishnikus.thedawnera.client.event;

import com.mojang.blaze3d.Blaze3D;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.Level;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.ComputeFovModifierEvent;
import net.minecraftforge.client.event.InputEvent;
import net.minecraftforge.client.event.RenderGuiOverlayEvent;
import net.minecraftforge.client.event.ViewportEvent;
import net.minecraftforge.client.gui.overlay.VanillaGuiOverlay;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import org.joml.Matrix4f;
import org.joml.Quaternionf;
import ru.astemir.astemirlib.client.RenderUtils;
import ru.astemir.astemirlib.client.bedrock.model.BedrockEntityModel;
import ru.astemir.astemirlib.client.bedrock.renderer.BedrockLivingRenderer;
import ru.astemir.astemirlib.client.event.CreativeTabRenderEvent;
import ru.astemir.astemirlib.client.event.DeferredRendererEvent;
import ru.astemir.astemirlib.client.event.HumanoidPoseEvent;
import ru.astemir.astemirlib.client.event.LivingRenderSetupEvent;
import ru.astemir.astemirlib.common.handler.LevelEvent;
import ru.astemir.astemirlib.common.handler.LevelEventHandler;
import ru.astemir.astemirlib.common.math.AVector2f;
import ru.astemir.astemirlib.common.math.Color;
import ru.astemir.astemirlib.common.math.MathUtils;
import ru.astemir.astemirlib.common.math.Rect2f;
import ru.astemir.astemirlib.common.network.PacketArgument;
import ru.xishnikus.thedawnera.client.gui.DinoGuiRenderer;
import ru.xishnikus.thedawnera.client.gui.InspectingSpyGlassRenderer;
import ru.xishnikus.thedawnera.client.misc.ShakeController;
import ru.xishnikus.thedawnera.client.render.AdvancedRenderer;
import ru.xishnikus.thedawnera.client.render.TDERenderUtils;
import ru.xishnikus.thedawnera.client.render.entity.TDEEntityModel;
import ru.xishnikus.thedawnera.common.TDELevelEvents;
import ru.xishnikus.thedawnera.common.entity.entity.base.BaseAnimal;
import ru.xishnikus.thedawnera.common.entity.entity.base.BaseRideableAnimal;
import ru.xishnikus.thedawnera.common.entity.entity.base.BaseRideableWaterAnimal;
import ru.xishnikus.thedawnera.common.entity.entity.base.BaseWaterAnimal;
import ru.xishnikus.thedawnera.common.entity.entity.ground.EntityDeinonychus;
import ru.xishnikus.thedawnera.common.entity.entity.water.EntityAegirocassis;
import ru.xishnikus.thedawnera.common.entity.input.InputKey;
import ru.xishnikus.thedawnera.common.entity.input.InputType;
import ru.xishnikus.thedawnera.common.entity.input.KeyInputMob;
import ru.xishnikus.thedawnera.common.entity.properties.MobProperties;
import ru.xishnikus.thedawnera.common.io.config.TDEClientConfig;
import ru.xishnikus.thedawnera.common.item.TDEItems;
import ru.xishnikus.thedawnera.common.misc.TDECreativeTabs;

@Mod.EventBusSubscriber(modid="dawnera", bus=Mod.EventBusSubscriber.Bus.FORGE, value={Dist.CLIENT})
public class ClientEventListener {
    private static final ResourceLocation dawnEraIcon = new ResourceLocation("dawnera", "textures/gui/misc/icon.png");
    public static int bleedingTicks;

    @SubscribeEvent
    public static void onPreRenderGui(RenderGuiOverlayEvent.Pre e) {
        LocalPlayer player = Minecraft.m_91087_().f_91074_;
        if (player != null) {
            Entity entity;
            if ((player.m_20202_() instanceof BaseRideableAnimal || player.m_20202_() instanceof BaseWaterAnimal) && e.getOverlay().id().equals((Object)VanillaGuiOverlay.SUBTITLES.id())) {
                e.getGuiGraphics().m_280168_().m_85836_();
                e.getGuiGraphics().m_280168_().m_252880_(0.0f, 20.0f, 0.0f);
            }
            if (e.getOverlay().id().equals((Object)VanillaGuiOverlay.MOUNT_HEALTH.id()) && (entity = player.m_20202_()) instanceof BaseAnimal) {
                BaseAnimal animal = (BaseAnimal)entity;
                DinoGuiRenderer.renderGui((Player)player, e.getGuiGraphics(), animal, e.getWindow().m_85445_(), e.getWindow().m_85446_());
                e.setCanceled(true);
            }
            if (e.getOverlay().id().equals((Object)VanillaGuiOverlay.SLEEP_FADE.id()) && ((Boolean)TDEClientConfig.SHOW_BLOOD_UI.get()).booleanValue()) {
                if (bleedingTicks > 0) {
                    Minecraft minecraft = Minecraft.m_91087_();
                    float f2 = (float)bleedingTicks + minecraft.m_91297_();
                    AdvancedRenderer.Texture texture = AdvancedRenderer.texture(256.0f, 256.0f, new ResourceLocation("dawnera", "textures/gui/blood_vignete.png")).build();
                    AdvancedRenderer.Sprite sprite = AdvancedRenderer.sprite(texture, e.getWindow().m_85445_(), e.getWindow().m_85446_()).centered().build();
                    AdvancedRenderer.drawSprite(new PoseStack(), sprite, (float)e.getWindow().m_85445_() / 2.0f, (float)e.getWindow().m_85446_() / 2.0f, 1.0f, 1.0f, 0.0f, 0.0f, Color.WHITE.alpha(MathUtils.sin((float)(f2 / 40.0f))));
                }
                e.setCanceled(true);
            }
        }
    }

    @SubscribeEvent
    public static void onPostRenderGui(RenderGuiOverlayEvent.Post e) {
        LocalPlayer player = Minecraft.m_91087_().f_91074_;
        if (player != null) {
            if ((player.m_20202_() instanceof BaseRideableAnimal || player.m_20202_() instanceof BaseWaterAnimal) && e.getOverlay().id().equals((Object)VanillaGuiOverlay.SUBTITLES.id())) {
                e.getGuiGraphics().m_280168_().m_85849_();
            }
            if (e.getOverlay().id().equals((Object)VanillaGuiOverlay.CROSSHAIR.id())) {
                DinoGuiRenderer.renderControls((Player)player, e.getGuiGraphics(), e.getWindow().m_85445_(), e.getWindow().m_85446_());
            }
            if (e.getOverlay().id().equals((Object)VanillaGuiOverlay.SPYGLASS.id())) {
                InspectingSpyGlassRenderer.renderInspectingSpyglass(e.getGuiGraphics(), e.getWindow().m_85445_(), e.getWindow().m_85446_());
            }
        }
    }

    @SubscribeEvent
    public static void onUpdate(TickEvent.ClientTickEvent e) {
        if (e.phase == TickEvent.Phase.START) {
            ClientLevel level;
            Minecraft minecraft = Minecraft.m_91087_();
            if (bleedingTicks > 0) {
                --bleedingTicks;
            }
            if (minecraft.f_91074_ != null && minecraft.f_91074_.m_21224_()) {
                bleedingTicks = 0;
            }
            if (minecraft != null && (level = minecraft.f_91073_) != null) {
                for (Entity entity : level.m_104735_()) {
                    if (!(entity instanceof KeyInputMob)) continue;
                    KeyInputMob keyInputMob = (KeyInputMob)entity;
                    keyInputMob.getInputMap().update(keyInputMob);
                }
            }
        }
    }

    @SubscribeEvent
    public static void onKeyInput(InputEvent.Key e) {
        Minecraft minecraft = Minecraft.m_91087_();
        if (minecraft == null) {
            return;
        }
        if (minecraft.f_91080_ != null) {
            return;
        }
        LocalPlayer player = Minecraft.m_91087_().f_91074_;
        if (player != null) {
            ClientEventListener.input(player.m_20202_(), InputType.KEY, e.getKey(), e.getAction());
        }
    }

    @SubscribeEvent
    public static void onMouseInput(InputEvent.MouseButton e) {
        Minecraft minecraft = Minecraft.m_91087_();
        if (minecraft == null) {
            return;
        }
        if (minecraft.f_91080_ != null) {
            return;
        }
        LocalPlayer player = Minecraft.m_91087_().f_91074_;
        if (player != null) {
            ClientEventListener.input(player.m_20202_(), InputType.MOUSE, e.getButton(), e.getAction());
        }
    }

    @SubscribeEvent
    public static void onSetupCameraAngle(ViewportEvent.ComputeCameraAngles e) {
        Entity vehicle = Minecraft.m_91087_().f_91074_.m_20202_();
        if (!Minecraft.m_91087_().f_91066_.m_92176_().m_90612_() && vehicle != null) {
            float zoom = 0.0f;
            if (vehicle instanceof BaseRideableAnimal) {
                BaseRideableAnimal rideableDino = (BaseRideableAnimal)vehicle;
                zoom = (float)((BaseRideableAnimal.Properties)rideableDino.getProperties()).getPassengerZoom().getDouble();
            } else if (vehicle instanceof BaseRideableWaterAnimal) {
                BaseRideableWaterAnimal rideableWaterDino = (BaseRideableWaterAnimal)vehicle;
                zoom = (float)((BaseRideableAnimal.Properties)rideableWaterDino.getProperties()).getPassengerZoom().getDouble();
            }
            if (zoom != 0.0f) {
                e.getCamera().m_90568_(-e.getCamera().m_90566_((double)zoom), 0.0, 0.0);
            }
            if (vehicle instanceof EntityAegirocassis) {
                EntityAegirocassis entityAegirocassis = (EntityAegirocassis)vehicle;
                e.setRoll(((Double)entityAegirocassis.playerOffset.get((float)e.getPartialTick())).floatValue());
            }
        }
        ShakeController.updateScreenShake(e);
    }

    @SubscribeEvent
    public static void onPosePlayer(HumanoidPoseEvent e) {
        BedrockLivingRenderer bedrockLivingRenderer;
        BedrockEntityModel model;
        Entity vehicle;
        Player player;
        LivingEntity livingEntity = e.getEntity();
        if (livingEntity instanceof Player && (player = (Player)livingEntity).m_21211_().m_150930_((Item)TDEItems.DIPLORANG.get())) {
            int i;
            float ticksUsed = Minecraft.m_91087_().m_91296_() + (float)player.m_21252_();
            float twitching = ticksUsed >= 5.0f ? MathUtils.sin((float)ticksUsed) / 100.0f : 0.0f;
            int n = i = player.m_7655_() == InteractionHand.MAIN_HAND ? 1 : -1;
            if (i == 1) {
                e.rightArm.f_104205_ = MathUtils.rad((float)-60.0f) + twitching;
                e.rightArm.f_104203_ = MathUtils.rad((float)-200.0f);
            } else {
                e.leftArm.f_104205_ = MathUtils.rad((float)60.0f) + twitching;
                e.leftArm.f_104203_ = MathUtils.rad((float)-200.0f);
            }
        }
        if ((vehicle = e.getEntity().m_20202_()) == null) {
            return;
        }
        EntityRenderer renderer = Minecraft.m_91087_().m_91290_().m_114382_(vehicle);
        if (renderer instanceof BedrockLivingRenderer && (model = (bedrockLivingRenderer = (BedrockLivingRenderer)renderer).getModel(vehicle)) instanceof TDEEntityModel) {
            TDEEntityModel tdeEntityModel = (TDEEntityModel)model;
            tdeEntityModel.applyPassengerPose(vehicle, e.getEntity(), e, (float)e.getEntity().f_19797_ + Minecraft.m_91087_().m_91296_(), e.getPartialTick());
        }
    }

    @SubscribeEvent
    public static void onDeferredRenderPrepare(DeferredRendererEvent.Prepare e) {
        BaseAnimal animal;
        Entity passenger = e.getOriginalRenderEvent().getEntity();
        Entity vehicle = passenger.m_20202_();
        if (vehicle == null || passenger instanceof EntityDeinonychus) {
            return;
        }
        if (vehicle instanceof BaseAnimal && ((MobProperties)(animal = (BaseAnimal)vehicle).getProperties()).isRideable()) {
            e.setCanceled(true);
        }
    }

    @SubscribeEvent
    public static void onRotateLivingEntity(LivingRenderSetupEvent.Rotation.Pre e) {
        BedrockLivingRenderer bedrockLivingRenderer;
        BedrockEntityModel model;
        EntityRenderer renderer;
        Entity vehicle = e.getEntity().m_20202_();
        if (vehicle == null) {
            return;
        }
        LivingEntity livingEntity = e.getEntity();
        if (livingEntity instanceof EntityDeinonychus) {
            EntityDeinonychus deinonychus = (EntityDeinonychus)livingEntity;
            float width = vehicle.m_20205_() / 2.0f;
            if (width - deinonychus.m_20205_() >= 1.0f) {
                width -= deinonychus.m_20205_();
            }
            float yRot = MathUtils.rad((float)deinonychus.hangOffsetYaw);
            float xRot = MathUtils.rad((float)deinonychus.hangOffsetPitch);
            e.getPoseStack().m_252880_(MathUtils.sin((float)yRot) * width, 0.0f, MathUtils.cos((float)yRot) * width);
            e.getPoseStack().m_252781_(Axis.f_252436_.m_252961_(yRot));
            RenderUtils.mulPoseCentered((PoseStack)e.getPoseStack(), (Quaternionf)Axis.f_252529_.m_252961_(-xRot), (float)(-width / 2.0f), (float)0.0f, (float)(-width / 2.0f));
            e.setCanceled(true);
        }
        if ((renderer = Minecraft.m_91087_().m_91290_().m_114382_(vehicle)) instanceof BedrockLivingRenderer && (model = (bedrockLivingRenderer = (BedrockLivingRenderer)renderer).getModel(vehicle)) instanceof TDEEntityModel) {
            TDEEntityModel tdeModel = (TDEEntityModel)model;
            e.setCanceled(tdeModel.applyPassengerRotation(vehicle, e.getEntity(), e.getPoseStack(), e.getBodyRotation()));
        }
    }

    @SubscribeEvent
    public static void onKeyInput(InputEvent.InteractionKeyMappingTriggered e) {
        LocalPlayer player = Minecraft.m_91087_().f_91074_;
        if (player != null && player.m_20202_() instanceof KeyInputMob) {
            if (e.isAttack()) {
                e.setSwingHand(false);
                e.setCanceled(true);
            }
            if (e.isUseItem()) {
                e.setSwingHand(false);
                e.setCanceled(true);
            }
        }
    }

    @SubscribeEvent
    public static void onFov(ComputeFovModifierEvent e) {
        Minecraft minecraft = Minecraft.m_91087_();
        if (e.getPlayer().m_21211_().m_150930_((Item)TDEItems.INSPECTING_SPYGLASS.get()) && minecraft.f_91066_.m_92176_().m_90612_()) {
            e.setNewFovModifier(0.3f);
        }
    }

    @SubscribeEvent
    public static void onRenderTab(CreativeTabRenderEvent e) {
        if (e.getTab() == TDECreativeTabs.THE_DAWN_ERA.get()) {
            float time = (float)Blaze3D.m_83640_();
            float animSpeed = 0.75f;
            float scale = 0.1225f + MathUtils.abs((float)MathUtils.sin((float)(time * 4.0f * animSpeed))) / 40.0f;
            int iconWidth = 160;
            int iconHeight = 90;
            PoseStack poseStack = new PoseStack();
            poseStack.m_85836_();
            Matrix4f matrix4f = new Matrix4f().translate(0.0f, -MathUtils.sin((float)(time * 8.0f * animSpeed)), 0.0f).translate((float)(e.getX() + 7), (float)(e.getY() + 5), 0.0f).scale(scale, scale, scale).rotateZ(MathUtils.cos((float)(time * 2.0f * animSpeed)) / 10.0f).translate((float)(-iconWidth / 2), (float)(-iconHeight / 2), 0.0f);
            poseStack.m_252931_(matrix4f);
            TDERenderUtils.blit(poseStack, new Rect2f(8.0f, 0.0f, (float)iconWidth, (float)iconHeight), new Rect2f(0.0f, 0.0f, (float)iconWidth, (float)iconHeight), new AVector2f(256.0f, 256.0f), dawnEraIcon, Color.WHITE);
            poseStack.m_85849_();
        }
    }

    private static void input(Entity entity, InputType type, int key, int action) {
        if (entity instanceof KeyInputMob) {
            KeyInputMob keyInputMob = (KeyInputMob)entity;
            block4: for (InputKey inputKey : keyInputMob.getInputMap().getKeys()) {
                if (inputKey.getInputType() != type || inputKey.getButtonId().getId() != key) continue;
                switch (action) {
                    case 1: {
                        inputKey.setPressed(true);
                        LevelEventHandler.playServerEvent((Level)entity.m_9236_(), (BlockPos)entity.m_20183_(), (LevelEvent)TDELevelEvents.EVENT_MOB_INPUT, (PacketArgument[])new PacketArgument[]{PacketArgument.valInt((int)entity.m_19879_()), PacketArgument.valInt((int)inputKey.getId()), PacketArgument.valBool((boolean)true)});
                        continue block4;
                    }
                    case 0: {
                        inputKey.setPressed(false);
                        LevelEventHandler.playServerEvent((Level)entity.m_9236_(), (BlockPos)entity.m_20183_(), (LevelEvent)TDELevelEvents.EVENT_MOB_INPUT, (PacketArgument[])new PacketArgument[]{PacketArgument.valInt((int)entity.m_19879_()), PacketArgument.valInt((int)inputKey.getId()), PacketArgument.valBool((boolean)false)});
                    }
                }
            }
        }
    }

    private static int toKey(int key) {
        switch (key) {
            case 0: {
                return 0;
            }
            case 1: {
                return 1;
            }
            case 2: {
                return 2;
            }
        }
        return -1;
    }
}

