/*
 * Decompiled with CFR 0.152.
 */
package ru.xishnikus.thedawnera.client.event;

import com.mojang.blaze3d.platform.Lighting;
import com.mojang.blaze3d.vertex.PoseStack;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.HeadedModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.renderer.ItemInHandRenderer;
import net.minecraft.client.renderer.ItemModelShaper;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.entity.layers.CustomHeadLayer;
import net.minecraft.client.resources.model.ModelManager;
import net.minecraft.client.resources.model.ModelResourceLocation;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.HumanoidArm;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.ModelEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import ru.astemir.astemirlib.client.event.ItemRenderEvent;
import ru.xishnikus.thedawnera.common.item.TDEItems;
import ru.xishnikus.thedawnera.common.utils.TDEItemUtils;

public class ItemEventListener {
    private static final ModelResourceLocation INSPECTING_SPYGLASS_IN_HAND_MODEL = new ModelResourceLocation("dawnera", "inspecting_spyglass_in_hand", "inventory");
    private static final ModelResourceLocation INSPECTING_SPYGLASS_MODEL = new ModelResourceLocation("dawnera", "inspecting_spyglass", "inventory");
    private static final ModelResourceLocation DIPLORANG_IN_HAND_MODEL = new ModelResourceLocation("dawnera", "diplorang_in_hand", "inventory");
    private static final ModelResourceLocation DIPLORANG_MODEL = new ModelResourceLocation("dawnera", "diplorang", "inventory");
    private static final ModelResourceLocation STRUTHIOMIMUS_FEATHER = new ModelResourceLocation("dawnera", "struthiomimus_feather", "inventory");
    private static final ModelResourceLocation DODO_FEATHER = new ModelResourceLocation("dawnera", "dodo_feather", "inventory");

    private static void renderInspectingSpyglass(ItemInHandRenderer renderer, ModelPart modelPart, LivingEntity livingEntity, ItemStack itemStack, HumanoidArm humanoidArm, PoseStack poseStack, MultiBufferSource bufferSource, int packedLight) {
        poseStack.m_85836_();
        float f = modelPart.f_104203_;
        modelPart.f_104203_ = Mth.m_14036_((float)modelPart.f_104203_, (float)-0.5235988f, (float)1.5707964f);
        modelPart.m_104299_(poseStack);
        modelPart.f_104203_ = f;
        CustomHeadLayer.m_174483_((PoseStack)poseStack, (boolean)false);
        boolean flag = humanoidArm == HumanoidArm.LEFT;
        poseStack.m_252880_((flag ? -2.5f : 2.5f) / 16.0f, -0.0625f, 0.0f);
        renderer.m_269530_(livingEntity, itemStack, ItemDisplayContext.HEAD, false, poseStack, bufferSource, packedLight);
        poseStack.m_85849_();
    }

    @Mod.EventBusSubscriber(modid="dawnera", bus=Mod.EventBusSubscriber.Bus.FORGE, value={Dist.CLIENT})
    public static class ForgeEvents {
        @SubscribeEvent
        public static <T extends EntityModel> void onRenderInHand(ItemRenderEvent.InPlayerHandRender e) {
            ItemStack itemStack = e.getItemStack();
            LivingEntity livingEntity = e.getLivingEntity();
            if (itemStack.m_150930_((Item)TDEItems.INSPECTING_SPYGLASS.get()) && livingEntity.m_21211_() == itemStack && livingEntity.f_20913_ == 0) {
                ItemEventListener.renderInspectingSpyglass(e.getItemInHandRenderer(), ((HeadedModel)e.getModel()).m_5585_(), livingEntity, itemStack, e.getArm(), e.getPoseStack(), e.getBufferSource(), e.getPackedLight());
                e.setCanceled(true);
            }
        }

        @SubscribeEvent
        public static void onModifyItemRender(ItemRenderEvent.ModifyRenderModel e) {
            ItemDisplayContext displayContext = e.getDisplayContext();
            ItemStack itemStack = e.getItemStack();
            ItemModelShaper modelShaper = e.getItemModelShaper();
            ModelManager modelManager = modelShaper.m_109393_();
            if (itemStack.m_150930_(Items.f_42402_)) {
                if (TDEItemUtils.isItemVariationId(itemStack, "dawnera:struthiomimus")) {
                    e.setModel(modelManager.m_119422_(STRUTHIOMIMUS_FEATHER));
                } else if (TDEItemUtils.isItemVariationId(itemStack, "dawnera:dodo")) {
                    e.setModel(modelManager.m_119422_(DODO_FEATHER));
                }
            }
            if (displayContext == ItemDisplayContext.GUI || displayContext == ItemDisplayContext.GROUND || displayContext == ItemDisplayContext.FIXED) {
                if (itemStack.m_150930_((Item)TDEItems.INSPECTING_SPYGLASS.get())) {
                    if (displayContext == ItemDisplayContext.GUI) {
                        Lighting.m_84930_();
                    }
                    e.setModel(modelManager.m_119422_(INSPECTING_SPYGLASS_MODEL));
                } else if (itemStack.m_150930_((Item)TDEItems.DIPLORANG.get())) {
                    if (displayContext == ItemDisplayContext.GUI) {
                        Lighting.m_84930_();
                    }
                    e.setModel(modelManager.m_119422_(DIPLORANG_MODEL));
                }
            }
        }

        @SubscribeEvent
        public static void onModifyItemModel(ItemRenderEvent.ModifyItemModel e) {
            ItemModelShaper modelShaper = e.getItemModelShaper();
            ModelManager modelManager = modelShaper.m_109393_();
            ItemStack itemStack = e.getItemStack();
            if (itemStack.m_150930_((Item)TDEItems.INSPECTING_SPYGLASS.get())) {
                e.setResultModel(modelManager.m_119422_(INSPECTING_SPYGLASS_IN_HAND_MODEL));
            } else if (itemStack.m_150930_((Item)TDEItems.DIPLORANG.get())) {
                e.setResultModel(modelManager.m_119422_(DIPLORANG_IN_HAND_MODEL));
            }
        }
    }

    @Mod.EventBusSubscriber(modid="dawnera", bus=Mod.EventBusSubscriber.Bus.MOD, value={Dist.CLIENT})
    public static class ModEvents {
        @SubscribeEvent
        public static void onBake(ModelEvent.RegisterAdditional e) {
            e.register((ResourceLocation)DIPLORANG_IN_HAND_MODEL);
            e.register((ResourceLocation)INSPECTING_SPYGLASS_IN_HAND_MODEL);
            e.register((ResourceLocation)STRUTHIOMIMUS_FEATHER);
            e.register((ResourceLocation)DODO_FEATHER);
        }
    }
}

