/*
 * Decompiled with CFR 0.152.
 */
package ru.xishnikus.thedawnera.client.gui;

import com.mojang.blaze3d.vertex.PoseStack;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.common.ForgeConfigSpec;
import ru.astemir.astemirlib.common.math.AVector2f;
import ru.astemir.astemirlib.common.math.Color;
import ru.astemir.astemirlib.common.math.Rect2f;
import ru.xishnikus.thedawnera.client.gui.DinoBarSprite;
import ru.xishnikus.thedawnera.client.render.TDEFonts;
import ru.xishnikus.thedawnera.client.render.TDERenderUtils;
import ru.xishnikus.thedawnera.common.entity.entity.base.BaseAnimal;
import ru.xishnikus.thedawnera.common.entity.input.InputKey;
import ru.xishnikus.thedawnera.common.entity.input.InputType;
import ru.xishnikus.thedawnera.common.entity.input.KeyInputMob;
import ru.xishnikus.thedawnera.common.io.config.TDEClientConfig;

public class DinoGuiRenderer {
    private static ResourceLocation rightMouseButton = new ResourceLocation("dawnera", "textures/gui/misc/right_mouse_button.png");
    private static ResourceLocation leftMouseButton = new ResourceLocation("dawnera", "textures/gui/misc/left_mouse_button.png");
    private static ResourceLocation keyButton = new ResourceLocation("dawnera", "textures/gui/misc/keyboard_button.png");
    private static ResourceLocation spaceButton = new ResourceLocation("dawnera", "textures/gui/misc/space_button.png");
    private static ResourceLocation bars = new ResourceLocation("dawnera", "textures/gui/bars.png");

    public static void renderGui(Player player, GuiGraphics graphics, BaseAnimal vehicle, int screenWidth, int screenHeight) {
        PoseStack poseStack = graphics.m_280168_();
        int x = (Integer)((ForgeConfigSpec.IntValue)TDEClientConfig.DINOSAUR_GUI.getA()).get();
        int y = (Integer)((ForgeConfigSpec.IntValue)TDEClientConfig.DINOSAUR_GUI.getB()).get();
        DinoGuiRenderer.renderBar(graphics, poseStack, DinoBarSprite.BAR_HEALTH, DinoBarSprite.BACKGROUND_HEALTH, DinoBarSprite.ICON_HEALTH, vehicle.m_21223_() / vehicle.m_21233_(), x, y, screenWidth, screenHeight);
        DinoGuiRenderer.renderBar(graphics, poseStack, DinoBarSprite.BAR_HUNGER, DinoBarSprite.BACKGROUND_HUNGER, DinoBarSprite.ICON_HUNGER, vehicle.getHunger() / vehicle.getMaxHunger(), x - 20, y, screenWidth, screenHeight);
        DinoGuiRenderer.renderBar(graphics, poseStack, DinoBarSprite.BAR_ENERGY, DinoBarSprite.BACKGROUND_ENERGY, DinoBarSprite.ICON_ENERGY, vehicle.getEnergy() / vehicle.getMaxEnergy(), x - 40, y, screenWidth, screenHeight);
    }

    public static void renderControls(Player player, GuiGraphics guiGraphics, int screenWidth, int screenHeight) {
        Entity entity = player.m_20202_();
        if (entity instanceof KeyInputMob) {
            KeyInputMob keyInputMob = (KeyInputMob)entity;
            int linesCount = 0;
            for (InputKey key : keyInputMob.getInputMap().getKeys()) {
                if (key.getInputType() == InputType.MOUSE) {
                    DinoGuiRenderer.renderMouseButton(guiGraphics, key, screenWidth, screenHeight, linesCount);
                }
                ++linesCount;
            }
        }
    }

    private static void renderBar(GuiGraphics graphics, PoseStack poseStack, DinoBarSprite sprite, DinoBarSprite bgSprite, DinoBarSprite iconSprite, float percentage, int x, int y, int screenWidth, int screenHeight) {
        AVector2f textureSize = new AVector2f(256.0f, 256.0f);
        String barText = "%.0f".formatted(Float.valueOf(percentage * 100.0f)) + "%";
        int finalX = screenWidth - x;
        int finalY = screenHeight - y;
        int width = 13;
        int height = 60;
        TDERenderUtils.blit(poseStack, new Rect2f((float)finalX, (float)finalY, (float)width, (float)height), new Rect2f((float)bgSprite.getUvX(), (float)bgSprite.getUvY(), (float)bgSprite.getTextureWidth(), (float)bgSprite.getTextureHeight()), textureSize, bars, Color.WHITE);
        graphics.m_280588_(finalX, (int)((float)finalY + ((float)height - percentage * (float)height)), finalX + width, finalY + height);
        TDERenderUtils.blit(poseStack, new Rect2f((float)finalX, (float)finalY, (float)width, (float)height), new Rect2f((float)sprite.getUvX(), (float)sprite.getUvY(), (float)sprite.getTextureWidth(), (float)sprite.getTextureHeight()), textureSize, bars, Color.WHITE);
        graphics.m_280618_();
        TDERenderUtils.drawCenteredString(graphics, TDEFonts.PIXELATED_FONT.getFont(), barText, finalX + 7, finalY + 30, Color.GREEN.rgb(), false);
        TDERenderUtils.blit(poseStack, new Rect2f((float)(finalX + 6), (float)(finalY + 55), (float)iconSprite.getTextureWidth(), (float)iconSprite.getTextureHeight()), new Rect2f((float)iconSprite.getUvX(), (float)iconSprite.getUvY(), (float)iconSprite.getTextureWidth(), (float)iconSprite.getTextureHeight()), textureSize, bars, Color.WHITE);
    }

    private static void renderMouseButton(GuiGraphics graphics, InputKey key, int screenWidth, int screenHeight, int line) {
        int y = -65;
        float cooldownProgress = 0.0f;
        TDERenderUtils.blit(graphics.m_280168_(), new Rect2f((float)(screenWidth - 60), (float)(y + line * 20 + screenHeight), 20.0f, 20.0f), new Rect2f(0.0f, 0.0f, 20.0f, 20.0f), new AVector2f(20.0f, 20.0f), key.getButtonId() == InputKey.Id.MOUSE_BUTTON_LEFT ? leftMouseButton : rightMouseButton, key.isDown() && cooldownProgress == 0.0f ? new Color(0.9f, 0.9f, 0.9f, 0.5f) : Color.WHITE);
        graphics.m_280430_(Minecraft.m_91087_().f_91062_, (Component)Component.m_237115_((String)("key.dawnera." + key.getName())), screenWidth - 40, y + 30 + line * 20 - 20 + screenHeight, Color.WHITE.rgb());
    }
}

