/*
 * Decompiled with CFR 0.152.
 */
package ru.xishnikus.thedawnera.client.gui;

import com.google.common.base.Predicates;
import java.util.function.Predicate;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.boss.enderdragon.EnderDragon;
import net.minecraft.world.entity.projectile.ProjectileUtil;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.Vec3;
import ru.astemir.astemirlib.common.math.Color;
import ru.xishnikus.thedawnera.common.entity.data.GenderType;
import ru.xishnikus.thedawnera.common.entity.entity.base.BaseAnimal;
import ru.xishnikus.thedawnera.common.item.TDEItems;

public class InspectingSpyGlassRenderer {
    public static final String NAME = "inspecting.dawnera.name";
    public static final String GENDER = "inspecting.dawnera.gender";
    public static final String HEALTH = "inspecting.dawnera.health";
    public static final String HUNGER = "inspecting.dawnera.hunger";
    public static final String STAMINA = "inspecting.dawnera.stamina";
    private static final ResourceLocation inspectingSpyglassScope = new ResourceLocation("dawnera", "textures/misc/inspecting_spyglass_scope.png");
    private static float scopeScale = 0.0f;

    public static void renderInspectingSpyglass(GuiGraphics guiGraphics, int screenWidth, int screenHeight) {
        Minecraft minecraft = Minecraft.m_91087_();
        float deltaFrame = minecraft.m_91297_();
        scopeScale = Mth.m_14179_((float)(0.5f * deltaFrame), (float)scopeScale, (float)1.125f);
        if (minecraft.f_91066_.m_92176_().m_90612_()) {
            if (minecraft.f_91074_.m_21211_().m_150930_((Item)TDEItems.INSPECTING_SPYGLASS.get())) {
                LivingEntity livingEntity;
                Entity entity;
                float f = Math.min(screenWidth, screenHeight);
                float f1 = Math.min((float)screenWidth / f, (float)screenHeight / f) * scopeScale;
                int i = Mth.m_14143_((float)(f * f1));
                int j = Mth.m_14143_((float)(f * f1));
                int k = (screenWidth - i) / 2;
                int l = (screenHeight - j) / 2;
                int i1 = k + i;
                int j1 = l + j;
                guiGraphics.m_280398_(inspectingSpyglassScope, k, l, -90, 0.0f, 0.0f, i, j, i, j);
                guiGraphics.m_285795_(RenderType.m_286086_(), 0, j1, screenWidth, screenHeight, -90, -16777216);
                guiGraphics.m_285795_(RenderType.m_286086_(), 0, 0, screenWidth, l, -90, -16777216);
                guiGraphics.m_285795_(RenderType.m_286086_(), 0, l, k, j1, -90, -16777216);
                guiGraphics.m_285795_(RenderType.m_286086_(), i1, l, screenWidth, j1, -90, -16777216);
                Vec3 vec3 = minecraft.f_91074_.m_20299_(0.0f);
                Vec3 vec31 = minecraft.f_91074_.m_20252_(1.0f);
                Vec3 vec32 = vec3.m_82520_(vec31.f_82479_ * 32.0, vec31.f_82480_ * 32.0, vec31.f_82481_ * 32.0);
                AABB aabb = minecraft.f_91074_.m_20191_().m_82369_(vec31.m_82490_(32.0)).m_82377_(2.0, 2.0, 2.0);
                EntityHitResult hitResult = ProjectileUtil.m_37304_((Level)minecraft.f_91073_, (Entity)minecraft.f_91074_, (Vec3)vec3, (Vec3)vec32, (AABB)aabb, (Predicate)Predicates.alwaysTrue());
                if (hitResult != null && scopeScale > 1.0f && (entity = hitResult.m_82443_()) instanceof LivingEntity && minecraft.f_91074_.m_142582_((Entity)(livingEntity = (LivingEntity)entity))) {
                    BaseAnimal baseAnimal;
                    Font font = Minecraft.m_91087_().f_91062_;
                    GenderType genderType = GenderType.UNKNOWN;
                    if (livingEntity instanceof BaseAnimal) {
                        baseAnimal = (BaseAnimal)livingEntity;
                        genderType = baseAnimal.getGender();
                    }
                    if (livingEntity instanceof EnderDragon) {
                        genderType = GenderType.FEMALE;
                    }
                    guiGraphics.m_280653_(font, (Component)Component.m_237115_((String)NAME).m_7220_((Component)Component.m_237113_((String)": ")).m_7220_((Component)Component.m_237115_((String)livingEntity.m_6095_().toString())), screenWidth / 2, screenHeight / 2 - 96, Color.GREEN.rgb());
                    guiGraphics.m_280653_(font, (Component)Component.m_237115_((String)GENDER).m_7220_((Component)Component.m_237113_((String)": ")).m_7220_((Component)Component.m_237115_((String)genderType.getId())), screenWidth / 2, screenHeight / 2 - 84, Color.GREEN.rgb());
                    guiGraphics.m_280653_(font, (Component)Component.m_237115_((String)HEALTH).m_7220_((Component)Component.m_237113_((String)": ")).m_7220_((Component)Component.m_237113_((String)(livingEntity.m_21223_() + "/" + livingEntity.m_21233_()))), screenWidth / 2, screenHeight / 2 - 72, Color.GREEN.rgb());
                    if (livingEntity instanceof BaseAnimal) {
                        baseAnimal = (BaseAnimal)livingEntity;
                        guiGraphics.m_280653_(font, (Component)Component.m_237115_((String)HUNGER).m_7220_((Component)Component.m_237113_((String)": ")).m_7220_((Component)Component.m_237113_((String)(baseAnimal.getHunger() + "/" + baseAnimal.getMaxHunger()))), screenWidth / 2, screenHeight / 2 - 60, Color.GREEN.rgb());
                        guiGraphics.m_280653_(font, (Component)Component.m_237115_((String)STAMINA).m_7220_((Component)Component.m_237113_((String)": ")).m_7220_((Component)Component.m_237113_((String)(baseAnimal.getEnergy() + "/" + baseAnimal.getMaxEnergy()))), screenWidth / 2, screenHeight / 2 - 48, Color.GREEN.rgb());
                    }
                }
            } else {
                scopeScale = 0.5f;
            }
        }
    }
}

