/*
 * Decompiled with CFR 0.152.
 */
package ru.xishnikus.thedawnera.client.gui.widget;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.BufferUploader;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.narration.NarrationElementOutput;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.network.chat.Component;
import net.minecraft.util.Mth;
import org.joml.Matrix4f;
import org.joml.Matrix4fc;
import ru.astemir.astemirlib.common.math.Color;
import ru.astemir.astemirlib.common.math.MathUtils;
import ru.xishnikus.thedawnera.client.render.AdvancedRenderer;
import ru.xishnikus.thedawnera.client.render.TDEFonts;

public class TDERadialMenu
extends AbstractWidget {
    private List<Option> children;
    private float radiusIn;
    private float radiusOut;
    public float scaleX = 1.0f;
    public float scaleY = 1.0f;
    private AdvancedRenderer.BlendOptions blendOptions = AdvancedRenderer.blending().build();

    public TDERadialMenu(int x, int y, float radiusIn, float radiusOut, List<Option> children) {
        super(x, y, (int)radiusOut, (int)radiusOut, (Component)Component.m_237119_());
        this.children = children;
        this.radiusIn = radiusIn;
        this.radiusOut = radiusOut;
    }

    protected void m_87963_(GuiGraphics graphics, int mouseX, int mouseY, float partialTick) {
        int i;
        PoseStack poseStack = graphics.m_280168_();
        poseStack.m_85836_();
        Matrix4f matrix = poseStack.m_85850_().m_252922_();
        matrix.translate((float)this.m_252754_(), (float)this.m_252907_(), 0.0f);
        matrix.scale(this.scaleX, this.scaleY, 1.0f);
        matrix.translate((float)(-this.m_252754_()), (float)(-this.m_252907_()), 0.0f);
        this.blendOptions.begin();
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.setShader(GameRenderer::m_172811_);
        BufferBuilder bufferbuilder = Tesselator.m_85913_().m_85915_();
        bufferbuilder.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85815_);
        double a = Math.toDegrees(Math.atan2(mouseY - this.m_252907_(), mouseX - this.m_252754_()));
        double d = Math.sqrt(Math.pow(mouseX - this.m_252754_(), 2.0) + Math.pow(mouseY - this.m_252907_(), 2.0));
        float diff = 0.0025f;
        if (a < (double)((-0.5f / (float)this.children.size() + 0.25f) * 360.0f)) {
            a += 360.0;
        }
        int selectedItem = -1;
        for (i = 0; i < this.children.size(); ++i) {
            float startAngle = (((float)i - 0.5f) / (float)this.children.size() + 0.25f + diff) * 360.0f;
            float endAngle = (((float)i + 0.5f) / (float)this.children.size() + 0.25f - diff) * 360.0f;
            if (!(a >= (double)startAngle) || !(a < (double)endAngle) || !(d >= (double)this.radiusIn) || !(d < (double)this.radiusOut)) continue;
            selectedItem = i;
            break;
        }
        for (i = 0; i < this.children.size(); ++i) {
            Option option = this.children.get(i);
            option.selected = selectedItem == i;
            float startAngle = (((float)i - 0.5f) / (float)this.children.size() + 0.25f + diff) * 360.0f;
            float endAngle = (((float)i + 0.5f) / (float)this.children.size() + 0.25f - diff) * 360.0f;
            float textAngle = ((float)i / (float)this.children.size() + 0.25f) * 2.0f * (float)Math.PI;
            option.draw(matrix, bufferbuilder, this.m_252754_(), this.m_252907_(), 0.0f, this.radiusIn, this.radiusOut, startAngle, endAngle, textAngle, partialTick);
        }
        BufferUploader.m_231202_((BufferBuilder.RenderedBuffer)bufferbuilder.m_231175_());
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.blendOptions.end();
        poseStack.m_85849_();
    }

    public boolean m_6375_(double x, double y, int type) {
        for (Option child : this.children) {
            if (!child.selected) continue;
            child.runnable.run();
            this.m_7435_(Minecraft.m_91087_().m_91106_());
            return true;
        }
        return false;
    }

    protected void m_168797_(NarrationElementOutput output) {
    }

    public List<Option> getChildren() {
        return this.children;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static Option.Builder option() {
        return new Option.Builder();
    }

    public static class Option {
        private List<Component> components;
        private Runnable runnable;
        public Color textColor;
        public boolean selected;
        private float radiusSelected = 0.0f;

        public Option(List<Component> components, Runnable runnable, Color textColor) {
            this.components = components;
            this.runnable = runnable;
            this.textColor = textColor;
        }

        public void draw(Matrix4f matrix, BufferBuilder bufferbuilder, float x, float y, float zOffset, float radiusIn, float radiusOut, float startAngle, float endAngle, float textAngle, float partialTick) {
            Color color;
            if (this.selected) {
                this.radiusSelected = MathUtils.lerp((float)this.radiusSelected, (float)8.0f, (float)partialTick);
                color = Color.BLACK.alpha(0.3f);
            } else {
                this.radiusSelected = MathUtils.lerp((float)this.radiusSelected, (float)0.0f, (float)partialTick);
                color = Color.BLACK.alpha(0.4f);
            }
            this.drawSegment(matrix, bufferbuilder, x, y, zOffset, radiusIn, radiusOut + this.radiusSelected, startAngle, endAngle, color);
            this.drawSegment(matrix, bufferbuilder, x, y, zOffset, radiusIn, radiusIn + 1.0f, startAngle, endAngle, this.textColor.alpha(0.6f));
            for (int i = 0; i < this.components.size(); ++i) {
                Component component = this.components.get(i);
                Objects.requireNonNull(TDEFonts.MINECRAFT_FONT.getFont());
                int lineHeight = 9;
                AdvancedRenderer.drawText(new Matrix4f((Matrix4fc)matrix), TDEFonts.MINECRAFT_FONT, component, x + (radiusIn + radiusOut) * 0.6f * (float)Math.cos(textAngle), y + (float)(lineHeight * i) + (radiusIn + radiusOut) * 0.6f * (float)Math.sin(textAngle), 1.0f + this.radiusSelected / 32.0f, 1.0f + this.radiusSelected / 32.0f, 0.0f, zOffset, true, false, this.textColor);
            }
        }

        private void drawSegment(Matrix4f matrix, BufferBuilder buffer, float x, float y, float zOffset, float radiusIn, float radiusOut, float startAngle, float endAngle, Color color) {
            float difference = endAngle - startAngle;
            int sections = Math.max(1, Mth.m_14167_((float)(difference / 5.0f)));
            startAngle = (float)Math.toRadians(startAngle);
            endAngle = (float)Math.toRadians(endAngle);
            difference = endAngle - startAngle;
            for (int i = 0; i < sections; ++i) {
                float fromAngle = startAngle + (float)i / (float)sections * difference;
                float toAngle = startAngle + (float)(i + 1) / (float)sections * difference;
                buffer.m_252986_(matrix, x + radiusOut * (float)Math.cos(fromAngle), y + radiusOut * (float)Math.sin(fromAngle), zOffset).m_193479_(color.rgba()).m_5752_();
                buffer.m_252986_(matrix, x + radiusIn * (float)Math.cos(fromAngle), y + radiusIn * (float)Math.sin(fromAngle), zOffset).m_193479_(color.rgba()).m_5752_();
                buffer.m_252986_(matrix, x + radiusIn * (float)Math.cos(toAngle), y + radiusIn * (float)Math.sin(toAngle), zOffset).m_193479_(color.rgba()).m_5752_();
                buffer.m_252986_(matrix, x + radiusOut * (float)Math.cos(toAngle), y + radiusOut * (float)Math.sin(toAngle), zOffset).m_193479_(color.rgba()).m_5752_();
            }
        }

        public static class Builder {
            private Runnable runnable = () -> {};
            private Color color = Color.WHITE;

            public Builder execute(Runnable runnable) {
                this.runnable = runnable;
                return this;
            }

            public Builder color(Color color) {
                this.color = color;
                return this;
            }

            public Option build(List<Component> components) {
                return new Option(components, this.runnable, this.color);
            }
        }
    }

    public static class Builder {
        private List<Option> children = new ArrayList<Option>();
        private float radiusIn;
        private float radiusOut;
        private int x;
        private int y;

        public Builder create(int x, int y, float radiusIn, float radiusOut) {
            this.x = x;
            this.y = y;
            this.radiusIn = radiusIn;
            this.radiusOut = radiusOut;
            return this;
        }

        public Builder addOption(Option option) {
            this.children.add(option);
            return this;
        }

        public TDERadialMenu build() {
            return new TDERadialMenu(this.x, this.y, this.radiusIn, this.radiusOut, this.children);
        }
    }
}

