/*
 * Decompiled with CFR 0.152.
 */
package ru.xishnikus.thedawnera.client.misc;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.resources.ResourceLocation;
import ru.xishnikus.thedawnera.client.misc.ModelResource;
import ru.xishnikus.thedawnera.client.render.entity.TDEEntityModel;
import ru.xishnikus.thedawnera.common.entity.data.GenderType;
import ru.xishnikus.thedawnera.common.entity.entity.base.BaseAnimal;

public class MobModelResources<T extends BaseAnimal> {
    private List<ModelResource<T>> resources = new ArrayList<ModelResource<T>>();
    private ModelResource<T> defaultResource;

    public MobModelResources(ModelResource<T> defaultResource) {
        this.defaultResource = defaultResource;
    }

    public MobModelResources<T> add(ModelResource<T> resource) {
        this.resources.add(resource);
        return this;
    }

    private ModelResource<T> chooseResource(T entity) {
        if (entity != null) {
            for (ModelResource<T> resource : this.resources) {
                if (!resource.checkName(entity) || !resource.checkVariation(entity)) continue;
                return resource;
            }
        }
        return this.defaultResource;
    }

    public TDEEntityModel<T> chooseModel(T entity) {
        ModelResource<T> resource = this.chooseResource(entity);
        if (entity != null) {
            if (resource.getBabyModel() != null && entity.m_6162_()) {
                return resource.getBabyModel();
            }
            if (resource.getFemaleModel() != null && ((BaseAnimal)((Object)entity)).getGender() == GenderType.FEMALE) {
                return resource.getFemaleModel();
            }
        }
        return resource.getDefaultModel();
    }

    public ResourceLocation chooseTexture(T entity) {
        ModelResource<T> resource = this.chooseResource(entity);
        if (entity != null) {
            if (resource.getBabyTexture() != null && entity.m_6162_()) {
                return resource.getBabyTexture();
            }
            if (resource.getFemaleTexture() != null && ((BaseAnimal)((Object)entity)).getGender() == GenderType.FEMALE) {
                return resource.getFemaleTexture();
            }
        }
        return resource.getDefaultTexture();
    }
}

