/*
 * Decompiled with CFR 0.152.
 */
package ru.xishnikus.thedawnera.client.misc;

import net.minecraft.resources.ResourceLocation;
import ru.xishnikus.thedawnera.client.render.entity.TDEEntityModel;
import ru.xishnikus.thedawnera.common.entity.data.MobVariation;
import ru.xishnikus.thedawnera.common.entity.entity.base.BaseAnimal;
import ru.xishnikus.thedawnera.common.utils.TDEUtils;

public class ModelResource<T extends BaseAnimal> {
    private TDEEntityModel<T> defaultModel;
    private TDEEntityModel<T> femaleModel;
    private TDEEntityModel<T> babyModel;
    private ResourceLocation defaultTexture;
    private ResourceLocation femaleTexture;
    private ResourceLocation babyTexture;
    private String customNameCondition;
    private MobVariation variationCondition;

    public ModelResource(TDEEntityModel<T> defaultModel, TDEEntityModel<T> babyModel, ResourceLocation defaultTexture, ResourceLocation babyTexture) {
        this.defaultModel = defaultModel;
        this.babyModel = babyModel;
        this.defaultTexture = defaultTexture;
        this.babyTexture = babyTexture;
    }

    public ModelResource(TDEEntityModel<T> defaultModel, TDEEntityModel<T> babyModel, ResourceLocation defaultTexture, ResourceLocation femaleTexture, ResourceLocation babyTexture) {
        this.defaultModel = defaultModel;
        this.babyModel = babyModel;
        this.defaultTexture = defaultTexture;
        this.femaleTexture = femaleTexture;
        this.babyTexture = babyTexture;
    }

    public ModelResource(TDEEntityModel<T> defaultModel, TDEEntityModel<T> femaleModel, TDEEntityModel<T> babyModel, ResourceLocation defaultTexture, ResourceLocation femaleTexture, ResourceLocation babyTexture) {
        this.defaultModel = defaultModel;
        this.femaleModel = femaleModel;
        this.babyModel = babyModel;
        this.defaultTexture = defaultTexture;
        this.femaleTexture = femaleTexture;
        this.babyTexture = babyTexture;
    }

    public ModelResource(TDEEntityModel<T> defaultModel, ResourceLocation defaultTexture) {
        this.defaultModel = defaultModel;
        this.defaultTexture = defaultTexture;
    }

    public ModelResource<T> customNameCondition(String name) {
        this.customNameCondition = name;
        return this;
    }

    public ModelResource<T> mobVariationCondition(MobVariation variation) {
        this.variationCondition = variation;
        return this;
    }

    public boolean checkVariation(T entity) {
        if (this.variationCondition != null) {
            return this.variationCondition == ((BaseAnimal)((Object)entity)).getVariation();
        }
        return true;
    }

    public boolean checkName(T entity) {
        if (this.customNameCondition != null) {
            return TDEUtils.isEntityNamedAs(entity, this.customNameCondition);
        }
        return true;
    }

    public TDEEntityModel<T> getDefaultModel() {
        return this.defaultModel;
    }

    public TDEEntityModel<T> getFemaleModel() {
        return this.femaleModel;
    }

    public TDEEntityModel<T> getBabyModel() {
        return this.babyModel;
    }

    public ResourceLocation getDefaultTexture() {
        return this.defaultTexture;
    }

    public ResourceLocation getFemaleTexture() {
        return this.femaleTexture;
    }

    public ResourceLocation getBabyTexture() {
        return this.babyTexture;
    }
}

