/*
 * Decompiled with CFR 0.152.
 */
package ru.xishnikus.thedawnera.client.misc;

import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.util.RandomSource;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.ViewportEvent;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import ru.astemir.astemirlib.common.math.MathUtils;
import ru.xishnikus.thedawnera.common.io.config.TDEClientConfig;

@Mod.EventBusSubscriber(modid="dawnera", bus=Mod.EventBusSubscriber.Bus.FORGE, value={Dist.CLIENT})
public class ShakeController {
    private static float shakeTicks = 0.0f;
    private static float shakePower = 0.0f;

    public static void updateScreenShake(ViewportEvent.ComputeCameraAngles e) {
        LocalPlayer player;
        if (!((Boolean)TDEClientConfig.SCREEN_SHAKE.get()).booleanValue()) {
            return;
        }
        if (shakeTicks > 0.0f && ((player = Minecraft.m_91087_().f_91074_).m_20202_() != null ? player.m_20202_().m_20096_() : player.m_20096_())) {
            RandomSource random = player.m_217043_();
            float f1 = random.m_188501_();
            float f2 = random.m_188501_();
            e.getCamera().m_90568_((double)(f1 * 0.1f * (shakePower / 5.0f)), (double)(f2 * 0.1f * (shakePower / 5.0f)), 0.0);
        }
    }

    @SubscribeEvent
    public static void onTick(TickEvent.ClientTickEvent e) {
        if (e.phase == TickEvent.Phase.START) {
            if (!Minecraft.m_91087_().m_91104_() && shakeTicks > 0.0f) {
                shakeTicks -= 5.0f;
            } else {
                shakePower = 0.0f;
            }
        }
    }

    public static void shake(float ticks, float power) {
        shakeTicks = ticks;
        shakePower = shakePower == 0.0f ? power : MathUtils.clamp((float)(shakePower + power / 4.0f), (float)0.0f, (float)3.0f);
    }
}

