/*
 * Decompiled with CFR 0.152.
 */
package ru.xishnikus.thedawnera.client.particle;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import net.minecraft.client.Camera;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.particle.DustParticleBase;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.particle.ParticleProvider;
import net.minecraft.client.particle.ParticleRenderType;
import net.minecraft.client.particle.SpriteSet;
import net.minecraft.core.particles.DustParticleOptionsBase;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.joml.Matrix4f;
import org.joml.Vector3f;
import ru.astemir.astemirlib.common.math.MathUtils;
import ru.astemir.astemirlib.common.math.RandomUtils;
import ru.xishnikus.thedawnera.client.particle.TDEParticleRenderType;
import ru.xishnikus.thedawnera.common.io.config.TDEClientConfig;
import ru.xishnikus.thedawnera.common.misc.TDESoundEvents;
import ru.xishnikus.thedawnera.common.particle.BloodParticleOptions;

public class DripBloodParticle
extends DustParticleBase<BloodParticleOptions> {
    private final SpriteSet sprites;
    private boolean landed;
    private float scale;
    private final int maxStay = (Integer)TDEClientConfig.MAX_BLOOD_STAY.get();
    private final boolean showBlood = (Boolean)TDEClientConfig.SHOW_BLOOD.get();
    private float randomY;

    public DripBloodParticle(ClientLevel level, double x, double y, double z, double speedX, double speedY, double speedZ, BloodParticleOptions options, SpriteSet spriteSet) {
        super(level, x, y, z, 0.0, 0.0, 0.0, (DustParticleOptionsBase)options, spriteSet);
        this.sprites = spriteSet;
        this.f_107215_ = speedX;
        this.f_107216_ = speedY;
        this.f_107217_ = speedZ;
        this.f_107225_ = this.maxStay;
        this.f_172258_ = 0.9f;
        this.f_107663_ = RandomUtils.randomFloat((float)0.1f, (float)0.15f) * 2.0f;
        this.f_107226_ = this.f_107663_ / 2.0f;
        this.scale = 0.1f;
        this.f_107230_ = RandomUtils.randomFloat((float)0.95f, (float)1.0f);
        this.m_107250_(this.f_107663_, this.f_107663_);
        this.m_108337_(this.sprites.m_5819_(RandomUtils.randomInt((int)0, (int)4), 7));
    }

    public void m_5989_() {
        this.f_107209_ = this.f_107212_;
        this.f_107210_ = this.f_107213_;
        this.f_107211_ = this.f_107214_;
        if (this.f_107225_-- <= 0) {
            this.m_107274_();
        } else {
            this.f_107216_ -= (double)this.f_107226_;
            this.m_6257_(this.f_107215_, this.f_107216_, this.f_107217_);
            this.f_107215_ *= (double)0.98f;
            this.f_107216_ *= (double)0.98f;
            this.f_107217_ *= (double)0.98f;
            if (this.f_107218_ && !this.landed) {
                this.f_107215_ = 0.0;
                this.f_107217_ = 0.0;
                this.landed = true;
                this.scale = this.f_107663_;
                this.randomY = RandomUtils.randomInt((int)0, (int)180);
                if (RandomUtils.doWithChance((float)10.0f)) {
                    this.f_107208_.m_7785_(this.f_107212_, this.f_107213_, this.f_107214_, (SoundEvent)TDESoundEvents.BLOOD_LAND.get(), SoundSource.AMBIENT, RandomUtils.randomFloat((float)0.1f, (float)0.25f), RandomUtils.randomFloat((float)1.8f, (float)2.0f), false);
                }
                this.f_107663_ = RandomUtils.randomFloat((float)0.1f, (float)0.3f);
                this.m_108337_(this.sprites.m_5819_(RandomUtils.randomInt((int)5, (int)8), 7));
            }
            if (this.landed && this.f_107225_ <= 100) {
                this.m_107271_(MathUtils.lerp((float)this.f_107230_, (float)0.0f, (float)0.05f));
            }
        }
    }

    public void m_5744_(VertexConsumer vertexConsumer, Camera camera, float partialTick) {
        float ageInTicks = (float)(this.maxStay - this.f_107225_) + partialTick;
        if (this.landed) {
            this.scale = Math.min(this.f_107663_ * 2.0f + ageInTicks / 20.0f, 2.0f);
        }
        float yRot = (float)(Mth.m_14136_((double)this.f_107215_, (double)(-this.f_107217_)) * 57.2957763671875);
        float xRot = (float)(Mth.m_14136_((double)this.f_107216_, (double)MathUtils.sqrt((float)((float)(this.f_107215_ * this.f_107215_ + this.f_107217_ * this.f_107217_)))) * 57.2957763671875);
        Vector3f[] vertices = new Vector3f[]{new Vector3f(-1.0f, -1.0f, 0.0f), new Vector3f(-1.0f, 1.0f, 0.0f), new Vector3f(1.0f, 1.0f, 0.0f), new Vector3f(1.0f, -1.0f, 0.0f)};
        PoseStack poseStack = new PoseStack();
        if (this.f_107218_) {
            poseStack.m_252880_(0.0f, 0.05f, 0.0f);
        }
        poseStack.m_85837_(Mth.m_14139_((double)partialTick, (double)this.f_107209_, (double)this.f_107212_) - camera.m_90583_().m_7096_(), Mth.m_14139_((double)partialTick, (double)this.f_107210_, (double)this.f_107213_) - camera.m_90583_().m_7098_(), Mth.m_14139_((double)partialTick, (double)this.f_107211_, (double)this.f_107214_) - camera.m_90583_().m_7094_());
        poseStack.m_85841_(this.m_5902_(partialTick) * this.scale, this.m_5902_(partialTick), this.m_5902_(partialTick) * this.scale);
        if (this.f_107218_) {
            poseStack.m_252781_(Axis.f_252436_.m_252977_(yRot + this.randomY));
            poseStack.m_252781_(Axis.f_252529_.m_252977_(xRot));
        } else {
            poseStack.m_252781_(Axis.f_252436_.m_252977_(-camera.m_90590_() + yRot));
            poseStack.m_252781_(Axis.f_252529_.m_252977_(xRot / 2.0f));
        }
        Matrix4f matrix4f = poseStack.m_85850_().m_252922_();
        vertexConsumer.m_252986_(matrix4f, vertices[0].x(), vertices[0].y(), vertices[0].z()).m_7421_(this.m_5952_(), this.m_5950_()).m_85950_(this.f_107227_, this.f_107228_, this.f_107229_, this.f_107230_).m_85969_(this.m_6355_(partialTick)).m_5752_();
        vertexConsumer.m_252986_(matrix4f, vertices[1].x(), vertices[1].y(), vertices[1].z()).m_7421_(this.m_5952_(), this.m_5951_()).m_85950_(this.f_107227_, this.f_107228_, this.f_107229_, this.f_107230_).m_85969_(this.m_6355_(partialTick)).m_5752_();
        vertexConsumer.m_252986_(matrix4f, vertices[2].x(), vertices[2].y(), vertices[2].z()).m_7421_(this.m_5970_(), this.m_5951_()).m_85950_(this.f_107227_, this.f_107228_, this.f_107229_, this.f_107230_).m_85969_(this.m_6355_(partialTick)).m_5752_();
        vertexConsumer.m_252986_(matrix4f, vertices[3].x(), vertices[3].y(), vertices[3].z()).m_7421_(this.m_5970_(), this.m_5950_()).m_85950_(this.f_107227_, this.f_107228_, this.f_107229_, this.f_107230_).m_85969_(this.m_6355_(partialTick)).m_5752_();
    }

    public float m_5902_(float partialTick) {
        return this.f_107663_;
    }

    public ParticleRenderType m_7556_() {
        if (!this.showBlood) {
            return ParticleRenderType.f_107434_;
        }
        return TDEParticleRenderType.PARTICLE_NO_CULL_NO_DEPTH_MASK;
    }

    @OnlyIn(value=Dist.CLIENT)
    public static class Provider
    implements ParticleProvider<BloodParticleOptions> {
        private final SpriteSet sprites;

        public Provider(SpriteSet spriteSet) {
            this.sprites = spriteSet;
        }

        public Particle createParticle(BloodParticleOptions options, ClientLevel level, double x, double y, double z, double speedX, double speedY, double speedZ) {
            return new DripBloodParticle(level, x, y, z, speedX, speedY, speedZ, options, this.sprites);
        }
    }
}

