/*
 * Decompiled with CFR 0.152.
 */
package ru.xishnikus.thedawnera.client.render;

import com.google.common.base.Suppliers;
import com.mojang.blaze3d.Blaze3D;
import com.mojang.blaze3d.font.TrueTypeGlyphProvider;
import com.mojang.blaze3d.platform.TextureUtil;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.BufferUploader;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexFormat;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.font.FontSet;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.ShaderInstance;
import net.minecraft.client.renderer.texture.AbstractTexture;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.ResourceManager;
import org.joml.Matrix4f;
import org.lwjgl.stb.STBTTFontinfo;
import org.lwjgl.stb.STBTruetype;
import ru.astemir.astemirlib.common.math.Color;

public interface AdvancedRenderer {
    public static void drawSprite(PoseStack poseStack, Sprite sprite, float x, float y, float scaleX, float scaleY, float rotation, float zOffset, Color color) {
        AdvancedRenderer.drawSprite(poseStack.m_85850_().m_252922_(), sprite, x, y, scaleX, scaleY, rotation, zOffset, color);
    }

    public static void drawSprite(Matrix4f matrix, Sprite sprite, float x, float y, float scaleX, float scaleY, float rotation, float zOffset, Color color) {
        sprite.drawTexture(matrix.translate(x, y, 0.0f).rotateZ(rotation).scale(scaleX, scaleY, 1.0f), zOffset, color);
    }

    public static void drawText(PoseStack poseStack, TTFFont font, Component component, float x, float y, float scaleX, float scaleY, float rotation, float zOffset, boolean centered, boolean renderShadow, Color color) {
        AdvancedRenderer.drawText(poseStack.m_85850_().m_252922_(), font, component, x, y, scaleX, scaleY, rotation, zOffset, centered, renderShadow, color);
    }

    public static void drawText(Matrix4f matrix, TTFFont fontConfigured, Component component, float x, float y, float scaleX, float scaleY, float rotation, float zOffset, boolean centered, boolean renderShadow, Color color) {
        if (component == null) {
            return;
        }
        Font font = fontConfigured.getFont();
        MultiBufferSource.BufferSource bufferSource = Minecraft.m_91087_().m_91269_().m_110104_();
        RenderSystem.disableDepthTest();
        font.m_272077_(component, centered ? (float)(-font.m_92852_((FormattedText)component) / 2) : 0.0f, 0.0f, color.rgb(), renderShadow, matrix.translate(x, y, zOffset).rotateZ(rotation).scale(scaleX, scaleY, 1.0f), (MultiBufferSource)bufferSource, Font.DisplayMode.NORMAL, 0, 0xF000F0);
        RenderSystem.enableDepthTest();
    }

    public static Sprite.Builder sprite(Texture texture, float width, float height) {
        return new Sprite.Builder().create(texture, width, height);
    }

    public static Texture.Builder texture(float width, float height, ResourceLocation ... paths) {
        return new Texture.Builder().create(new Size(width, height), paths);
    }

    public static BlendOptions.Builder blending() {
        return new BlendOptions.Builder();
    }

    public static Rect rect(float x0, float y0, float x1, float y1) {
        return new Rect(x0, y0, x1, y1);
    }

    public static class Sprite {
        private Texture texture;
        private Size size;
        private UV uv;
        private boolean centered;
        private BlendOptions blendOptions;
        private Supplier<ShaderInstance> shader;

        public Sprite(Texture texture, Size size, UV uv, boolean centered, BlendOptions blendOptions, Supplier<ShaderInstance> shader) {
            this.texture = texture;
            this.size = size;
            this.uv = uv;
            this.centered = centered;
            this.blendOptions = blendOptions;
            this.shader = shader;
        }

        public void drawTexture(Matrix4f matrix, float zOffset, Color color) {
            float pX1 = 0.0f;
            float pY1 = 0.0f;
            float pX2 = this.size.width;
            float pY2 = this.size.height;
            if (this.centered) {
                pX1 -= this.size.width / 2.0f;
                pX2 -= this.size.width / 2.0f;
                pY1 -= this.size.height / 2.0f;
                pY2 -= this.size.height / 2.0f;
            }
            this.blendOptions.begin();
            RenderSystem.setShaderColor((float)color.r, (float)color.g, (float)color.b, (float)color.a);
            RenderSystem.setShader(this.shader);
            this.shader.get().m_173356_("iTime").m_5985_((float)Blaze3D.m_83640_());
            this.texture.begin();
            BufferBuilder bufferbuilder = Tesselator.m_85913_().m_85915_();
            bufferbuilder.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85817_);
            bufferbuilder.m_252986_(matrix, pX1, pY2, zOffset).m_7421_(this.uv.minU, this.uv.maxV).m_5752_();
            bufferbuilder.m_252986_(matrix, pX2, pY2, zOffset).m_7421_(this.uv.maxU, this.uv.maxV).m_5752_();
            bufferbuilder.m_252986_(matrix, pX2, pY1, zOffset).m_7421_(this.uv.maxU, this.uv.minV).m_5752_();
            bufferbuilder.m_252986_(matrix, pX1, pY1, zOffset).m_7421_(this.uv.minU, this.uv.minV).m_5752_();
            BufferUploader.m_231202_((BufferBuilder.RenderedBuffer)bufferbuilder.m_231175_());
            this.texture.end();
            RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            this.blendOptions.end();
        }

        public static class Builder {
            private Texture texture;
            private Size size;
            private UV uv;
            private BlendOptions blendOptions = BlendOptions.DEFAULT;
            private Supplier<ShaderInstance> shader = GameRenderer::m_172817_;
            private boolean centered = false;

            public Builder create(Texture texture, float width, float height) {
                this.texture = texture;
                this.size = new Size(width, height);
                this.uv = new UV(0.0f, 0.0f, 1.0f, 1.0f);
                return this;
            }

            public Builder uv(Rect rect) {
                float minU = rect.x0 / this.texture.size.width;
                float minV = rect.y0 / this.texture.size.height;
                float maxU = (rect.x0 + rect.x1) / this.texture.size.width;
                float maxV = (rect.y0 + rect.y1) / this.texture.size.height;
                this.uv = new UV(minU, minV, maxU, maxV);
                return this;
            }

            public Builder blend(BlendOptions blendOptions) {
                this.blendOptions = blendOptions;
                return this;
            }

            public Builder centered() {
                this.centered = true;
                return this;
            }

            public Builder shader(Supplier<ShaderInstance> shader) {
                this.shader = shader;
                return this;
            }

            public Sprite build() {
                return new Sprite(this.texture, this.size, this.uv, this.centered, this.blendOptions, this.shader);
            }
        }
    }

    public static class TTFFont {
        private Supplier<Font> font;
        private float fontSize;

        public TTFFont(Supplier<Font> font, float fontSize) {
            this.font = font;
            this.fontSize = fontSize;
        }

        public Font getFont() {
            return this.font.get();
        }

        public float getFontSize() {
            return this.fontSize;
        }

        public static TTFFont createFromTTF(ResourceLocation location, float fontSize, float oversample, float shiftX, float shiftY) {
            ResourceManager resourceManager = Minecraft.m_91087_().m_91098_();
            FontSet fontSet = new FontSet(Minecraft.m_91087_().f_90987_, location);
            STBTTFontinfo fontInfo = STBTTFontinfo.malloc();
            try {
                InputStream inputstream = resourceManager.m_215595_(location);
                ByteBuffer bytebuffer = TextureUtil.readResource((InputStream)inputstream);
                bytebuffer.flip();
                if (!STBTruetype.stbtt_InitFont((STBTTFontinfo)fontInfo, (ByteBuffer)bytebuffer)) {
                    throw new IOException("Invalid ttf");
                }
                fontSet.f_95055_.add(new TrueTypeGlyphProvider(bytebuffer, fontInfo, fontSize, oversample, shiftX, shiftY, ""));
                return new TTFFont((Supplier<Font>)Suppliers.memoize(() -> new Font(a -> fontSet, true)), fontSize);
            }
            catch (IOException e) {
                return null;
            }
        }
    }

    public static class Texture {
        private ResourceLocation[] paths;
        private Size size;
        private double speed;
        private boolean blur;
        private boolean mipmap;

        public Texture(ResourceLocation[] paths, Size size, float speed, boolean blur, boolean mipmap) {
            this.paths = paths;
            this.speed = speed;
            this.size = size;
            this.blur = blur;
            this.mipmap = mipmap;
        }

        public ResourceLocation getPath() {
            if (this.paths.length > 1) {
                double factor = 1.0 / this.speed;
                int index = (int)(Blaze3D.m_83640_() / factor % (double)this.paths.length * factor / factor);
                if (index == this.paths.length) {
                    index = 0;
                }
                return this.paths[index];
            }
            return this.paths[0];
        }

        public void begin() {
            ResourceLocation path = this.getPath();
            RenderSystem.setShaderTexture((int)0, (ResourceLocation)path);
            AbstractTexture texture = Minecraft.m_91087_().f_90987_.m_118506_(path);
            texture.setBlurMipmap(this.blur, this.mipmap);
        }

        public void end() {
            ResourceLocation path = this.getPath();
            AbstractTexture texture = Minecraft.m_91087_().f_90987_.m_118506_(path);
            texture.restoreLastBlurMipmap();
        }

        public static class Builder {
            private ResourceLocation[] paths;
            private Size size;
            private float speed = 1.0f;
            private boolean blur;
            private boolean mipmap;

            public Builder create(Size size, ResourceLocation ... paths) {
                this.paths = paths;
                this.size = size;
                return this;
            }

            public Builder blur() {
                this.blur = true;
                return this;
            }

            public Builder mipmap() {
                this.mipmap = true;
                return this;
            }

            public Builder speed(float speed) {
                this.speed = speed;
                return this;
            }

            public Texture build() {
                return new Texture(this.paths, this.size, this.speed, this.blur, this.mipmap);
            }
        }
    }

    public record Size(float width, float height) {
        public static final Size ZERO = new Size(0.0f, 0.0f);
    }

    public static class BlendOptions {
        public static final BlendOptions DEFAULT = new BlendOptions(false);
        private boolean blendEnabled;

        public BlendOptions(boolean blendEnabled) {
            this.blendEnabled = blendEnabled;
        }

        public void begin() {
            if (this.blendEnabled) {
                RenderSystem.enableBlend();
                RenderSystem.defaultBlendFunc();
            }
        }

        public void end() {
            if (this.blendEnabled) {
                RenderSystem.disableBlend();
                RenderSystem.defaultBlendFunc();
            }
        }

        public static class Builder {
            private boolean blendEnabled = false;

            public void enabled() {
                this.blendEnabled = true;
            }

            public BlendOptions build() {
                return new BlendOptions(this.blendEnabled);
            }
        }
    }

    public record Rect(float x0, float y0, float x1, float y1) {
    }

    public record UV(float minU, float minV, float maxU, float maxV) {
    }
}

