/*
 * Decompiled with CFR 0.152.
 */
package ru.xishnikus.thedawnera.client.render;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.BufferUploader;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexFormat;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.resources.ResourceLocation;
import org.joml.Matrix4f;
import ru.astemir.astemirlib.common.math.AVector2f;
import ru.astemir.astemirlib.common.math.Color;
import ru.astemir.astemirlib.common.math.Rect2f;

public class TDERenderUtils {
    public static void drawCenteredString(GuiGraphics graphics, Font font, String text, int x, int y, int color, boolean background) {
        graphics.m_280056_(font, text, x - font.m_92895_(text) / 2, y, color, background);
    }

    public static void blit(PoseStack pPoseStack, Rect2f rectangle, Rect2f uvRect, AVector2f textureSize, ResourceLocation texture, Color color) {
        TDERenderUtils.innerBlit(pPoseStack, rectangle.getX(), rectangle.getX() + rectangle.getWidth(), rectangle.getY(), rectangle.getY() + rectangle.getHeight(), 0.0f, uvRect.getWidth(), uvRect.getHeight(), uvRect.getX(), uvRect.getY(), textureSize.getX(), textureSize.getY(), texture, color);
    }

    private static void innerBlit(PoseStack pPoseStack, float pX1, float pX2, float pY1, float pY2, float pBlitOffset, float pUWidth, float pVHeight, float pUOffset, float pVOffset, float pTextureWidth, float pTextureHeight, ResourceLocation texture, Color color) {
        TDERenderUtils.innerBlit(pPoseStack.m_85850_().m_252922_(), pX1, pX2, pY1, pY2, pBlitOffset, pUOffset / pTextureWidth, (pUOffset + pUWidth) / pTextureWidth, pVOffset / pTextureHeight, (pVOffset + pVHeight) / pTextureHeight, texture, color);
    }

    private static void innerBlit(Matrix4f pMatrix, float pX1, float pX2, float pY1, float pY2, float pBlitOffset, float pMinU, float pMaxU, float pMinV, float pMaxV, ResourceLocation texture, Color color) {
        RenderSystem.enableBlend();
        RenderSystem.defaultBlendFunc();
        RenderSystem.setShader(GameRenderer::m_172817_);
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)texture);
        BufferBuilder bufferbuilder = Tesselator.m_85913_().m_85915_();
        bufferbuilder.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85817_);
        RenderSystem.setShaderColor((float)color.r, (float)color.g, (float)color.b, (float)color.a);
        bufferbuilder.m_252986_(pMatrix, pX1, pY2, pBlitOffset).m_7421_(pMinU, pMaxV).m_5752_();
        bufferbuilder.m_252986_(pMatrix, pX2, pY2, pBlitOffset).m_7421_(pMaxU, pMaxV).m_5752_();
        bufferbuilder.m_252986_(pMatrix, pX2, pY1, pBlitOffset).m_7421_(pMaxU, pMinV).m_5752_();
        bufferbuilder.m_252986_(pMatrix, pX1, pY1, pBlitOffset).m_7421_(pMinU, pMinV).m_5752_();
        BufferUploader.m_231202_((BufferBuilder.RenderedBuffer)bufferbuilder.m_231175_());
        RenderSystem.disableBlend();
        RenderSystem.defaultBlendFunc();
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
    }

    public static void fillColor(PoseStack pPoseStack, Rect2f rect, Color color) {
        TDERenderUtils.innerFill(pPoseStack.m_85850_().m_252922_(), rect.getX(), rect.getY(), rect.getX() + rect.getWidth(), rect.getY() + rect.getHeight(), color);
    }

    private static void innerFill(Matrix4f pMatrix, float pMinX, float pMinY, float pMaxX, float pMaxY, Color color) {
        if (pMinX < pMaxX) {
            float i = pMinX;
            pMinX = pMaxX;
            pMaxX = i;
        }
        if (pMinY < pMaxY) {
            float j = pMinY;
            pMinY = pMaxY;
            pMaxY = j;
        }
        BufferBuilder bufferbuilder = Tesselator.m_85913_().m_85915_();
        RenderSystem.enableBlend();
        RenderSystem.defaultBlendFunc();
        RenderSystem.setShader(GameRenderer::m_172811_);
        bufferbuilder.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85815_);
        bufferbuilder.m_252986_(pMatrix, pMinX, pMaxY, 0.0f).m_85950_(color.r, color.g, color.b, color.a).m_5752_();
        bufferbuilder.m_252986_(pMatrix, pMaxX, pMaxY, 0.0f).m_85950_(color.r, color.g, color.b, color.a).m_5752_();
        bufferbuilder.m_252986_(pMatrix, pMaxX, pMinY, 0.0f).m_85950_(color.r, color.g, color.b, color.a).m_5752_();
        bufferbuilder.m_252986_(pMatrix, pMinX, pMinY, 0.0f).m_85950_(color.r, color.g, color.b, color.a).m_5752_();
        BufferUploader.m_231202_((BufferBuilder.RenderedBuffer)bufferbuilder.m_231175_());
        RenderSystem.disableBlend();
    }
}

