/*
 * Decompiled with CFR 0.152.
 */
package ru.xishnikus.thedawnera.client.render.entity;

import com.mojang.blaze3d.vertex.PoseStack;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.core.particles.BlockParticleOption;
import net.minecraft.core.particles.ItemParticleOption;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import org.joml.Vector3f;
import ru.astemir.astemirlib.client.bedrock.model.BedrockEntityModel;
import ru.astemir.astemirlib.client.bedrock.renderer.EntityRenderData;
import ru.astemir.astemirlib.client.event.HumanoidPoseEvent;
import ru.astemir.astemirlib.common.math.AVector3f;
import ru.astemir.astemirlib.common.math.MathUtils;
import ru.astemir.astemirlib.common.math.RandomUtils;
import ru.xishnikus.thedawnera.client.render.entity.TDEPassengerLayer;
import ru.xishnikus.thedawnera.common.entity.entity.base.BaseAnimal;
import ru.xishnikus.thedawnera.common.io.config.TDEClientConfig;
import ru.xishnikus.thedawnera.common.particle.TDEParticleTypes;

public abstract class TDEEntityModel<T extends Entity>
extends BedrockEntityModel<T> {
    public TDEEntityModel(ResourceLocation model, ResourceLocation animations) {
        super(model, animations);
        this.addLayer(new TDEPassengerLayer(this));
    }

    public void renderPassenger(T entity, LivingEntity passenger) {
    }

    public boolean applyPassengerRotation(T entity, LivingEntity passenger, PoseStack poseStack, float passengerRotation) {
        return true;
    }

    public void applyPassengerPose(T entity, LivingEntity passenger, HumanoidPoseEvent event, float ageInTicks, float partialTick) {
    }

    protected float clamp(float value, float min, float max) {
        return MathUtils.clamp((float)value, (float)min, (float)max);
    }

    protected float deg(float value) {
        return MathUtils.deg((float)value);
    }

    protected float rad(float value) {
        return MathUtils.rad((float)value);
    }

    protected float sin(float value) {
        return MathUtils.sin((float)value);
    }

    protected float cos(float value) {
        return MathUtils.cos((float)value);
    }

    public static ResourceLocation textureLocation(String mobName, String textureName) {
        return new ResourceLocation("dawnera", "textures/entity/" + mobName + "/" + textureName);
    }

    public static ResourceLocation modelLocation(String mobName, String modelName) {
        return new ResourceLocation("dawnera", "geo/entity/" + mobName + "/" + modelName);
    }

    public static ResourceLocation animationsLocation(String mobName, String animationName) {
        return new ResourceLocation("dawnera", "animations/entity/" + mobName + "/" + animationName);
    }

    public RenderType getRenderType(T object, ResourceLocation texture) {
        return RenderType.m_110458_((ResourceLocation)texture);
    }

    public void renderRoarParticles(LivingEntity entity, BedrockEntityModel model, EntityRenderData entityRenderData, String bone, AVector3f offset, float minRadius, float radiusMultiplier, int distance) {
        if (!Minecraft.m_91087_().m_91104_() && ((Boolean)TDEClientConfig.SHOW_ROAR_PARTICLES.get()).booleanValue()) {
            PoseStack particlePoseStack = model.getBonePose(entityRenderData, entity, bone);
            AVector3f renderRot = model.getBoneRotation(entityRenderData, entity, bone);
            float radius = minRadius + MathUtils.abs((float)MathUtils.sin((float)(entityRenderData.ageInTicks / 4.0f))) * radiusMultiplier;
            float f1 = MathUtils.cos((float)entityRenderData.ageInTicks) / 4.0f;
            float f2 = MathUtils.sin((float)entityRenderData.ageInTicks) / 4.0f;
            particlePoseStack.m_85837_((double)offset.x, (double)offset.y - 0.5 - (double)(radius / 2.0f), (double)(offset.z - radius));
            for (int i = 0; i < distance; ++i) {
                particlePoseStack.m_252880_(-MathUtils.cos((float)entityRenderData.ageInTicks) * radius, MathUtils.sin((float)entityRenderData.ageInTicks) * radius, (float)(-i) * 0.6f);
                AVector3f vec = AVector3f.from((Vector3f)particlePoseStack.m_85850_().m_252922_().getTranslation(new Vector3f()));
                entity.m_9236_().m_7106_((ParticleOptions)TDEParticleTypes.WIND.get(), (double)(vec.x + RandomUtils.randomFloat((float)-0.1f, (float)0.1f)), (double)(vec.y + RandomUtils.randomFloat((float)-0.1f, (float)0.1f)), (double)(vec.z + RandomUtils.randomFloat((float)-0.1f, (float)0.1f)), (double)(renderRot.x + f1 * radius / 2.0f), (double)(renderRot.y + f2 * radius / 2.0f), (double)(renderRot.z + f1 * radius / 2.0f));
            }
        }
    }

    public void renderRoarParticles(LivingEntity entity, BedrockEntityModel model, EntityRenderData entityRenderData, String bone, float minRadius, float radiusMultiplier, int distance) {
        this.renderRoarParticles(entity, model, entityRenderData, bone, new AVector3f(0.0f, 0.0f, 0.0f), minRadius, radiusMultiplier, distance);
    }

    public void renderSpitParticles(LivingEntity entity, BedrockEntityModel model, EntityRenderData entityRenderData, String bone) {
        if (!Minecraft.m_91087_().m_91104_()) {
            PoseStack particlePoseStack = model.getBonePose(entityRenderData, entity, bone);
            AVector3f renderRot = model.getBoneRotation(entityRenderData, entity, bone);
            particlePoseStack.m_252880_(0.0f, 0.0f, -0.5f);
            AVector3f vec = AVector3f.from((Vector3f)particlePoseStack.m_85850_().m_252922_().getTranslation(new Vector3f()));
            entity.m_9236_().m_7106_((ParticleOptions)TDEParticleTypes.SPIT.get(), (double)(vec.x + RandomUtils.randomFloat((float)-0.4f, (float)0.4f)), (double)(vec.y + RandomUtils.randomFloat((float)-0.5f, (float)0.5f)), (double)(vec.z + RandomUtils.randomFloat((float)-0.4f, (float)0.4f)), (double)(renderRot.x / 2.0f + RandomUtils.randomFloat((float)-0.1f, (float)0.1f)), (double)RandomUtils.randomFloat((float)0.1f, (float)0.25f), (double)(renderRot.z / 2.0f + RandomUtils.randomFloat((float)-0.1f, (float)0.1f)));
        }
    }

    public void renderFoodParticles(BaseAnimal entity, BedrockEntityModel model, EntityRenderData entityRenderData, String bone) {
        this.renderFoodParticles(entity, model, entityRenderData, new AVector3f(0.0f, 0.0f, 0.0f), new AVector3f(0.4f, 0.5f, 0.4f), 5, bone);
    }

    /*
     * Enabled aggressive block sorting
     */
    public void renderFoodParticles(BaseAnimal entity, BedrockEntityModel model, EntityRenderData entityRenderData, AVector3f offset, AVector3f radius, int rate, String bone) {
        if (Minecraft.m_91087_().m_91104_()) return;
        if (entity.f_19797_ % rate != 0) return;
        ItemStack itemStack = entity.getLastEatenFood();
        if (itemStack == null) return;
        PoseStack particlePoseStack = model.getBonePose(entityRenderData, (LivingEntity)entity, bone);
        AVector3f renderRot = model.getBoneRotation(entityRenderData, (LivingEntity)entity, bone);
        particlePoseStack.m_252880_(offset.x, offset.y, offset.z - 0.5f);
        AVector3f vec = AVector3f.from((Vector3f)particlePoseStack.m_85850_().m_252922_().getTranslation(new Vector3f()));
        Item item = itemStack.m_41720_();
        if (item instanceof BlockItem) {
            BlockItem blockItem = (BlockItem)item;
            if (itemStack.getFoodProperties((LivingEntity)entity) == null) {
                entity.m_9236_().m_7106_((ParticleOptions)new BlockParticleOption(ParticleTypes.f_123794_, blockItem.m_40614_().m_49966_()), (double)(vec.x + RandomUtils.randomFloat((float)(-radius.x), (float)radius.x)), (double)(vec.y + RandomUtils.randomFloat((float)(-radius.y), (float)radius.y)), (double)(vec.z + RandomUtils.randomFloat((float)(-radius.z), (float)radius.z)), (double)(renderRot.x / 8.0f + RandomUtils.randomFloat((float)-0.1f, (float)0.1f)), (double)RandomUtils.randomFloat((float)0.1f, (float)0.25f), (double)(renderRot.z / 8.0f + RandomUtils.randomFloat((float)-0.1f, (float)0.1f)));
                return;
            }
        }
        entity.m_9236_().m_7106_((ParticleOptions)new ItemParticleOption(ParticleTypes.f_123752_, itemStack), (double)(vec.x + RandomUtils.randomFloat((float)-0.2f, (float)0.2f)), (double)(vec.y + RandomUtils.randomFloat((float)-0.2f, (float)0.2f)), (double)(vec.z + RandomUtils.randomFloat((float)-0.2f, (float)0.2f)), (double)(renderRot.x / 8.0f + RandomUtils.randomFloat((float)-0.1f, (float)0.1f)), (double)RandomUtils.randomFloat((float)0.1f, (float)0.25f), (double)(renderRot.z / 8.0f + RandomUtils.randomFloat((float)-0.1f, (float)0.1f)));
    }
}

