/*
 * Decompiled with CFR 0.152.
 */
package ru.xishnikus.thedawnera.client.render.entity;

import com.mojang.blaze3d.vertex.PoseStack;
import java.util.function.Function;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.animal.Animal;
import ru.astemir.astemirlib.client.bedrock.model.BedrockEntityModel;
import ru.astemir.astemirlib.client.bedrock.renderer.BedrockLivingRenderer;
import ru.xishnikus.thedawnera.client.render.entity.TDEEntityModel;
import ru.xishnikus.thedawnera.common.entity.entity.base.BaseAnimal;

public abstract class TDELivingRenderer<T extends LivingEntity>
extends BedrockLivingRenderer<T> {
    private float defaultShadowRadius;

    public TDELivingRenderer(EntityRendererProvider.Context context, float shadowRadius) {
        super(context, shadowRadius);
        this.defaultShadowRadius = shadowRadius;
    }

    public void setupScale(T entity, BedrockEntityModel<T> model, PoseStack poseStack, float partialTick) {
        super.setupScale(entity, model, poseStack, partialTick);
        if (entity instanceof BaseAnimal) {
            BaseAnimal baseAnimal = (BaseAnimal)((Object)entity);
            if (entity.m_6162_()) {
                float scale = baseAnimal.getAgeScale(partialTick);
                this.f_114477_ = this.defaultShadowRadius * scale;
                poseStack.m_85841_(scale, scale, scale);
            }
        }
    }

    public static <T extends LivingEntity> TDELivingRenderer<T> createDefaultRenderer(EntityRendererProvider.Context context, final Function<T, TDEEntityModel<T>> baseModel, float shadowRadius, float shadowStrength) {
        TDELivingRenderer renderer = new TDELivingRenderer<T>(context, shadowRadius){

            public BedrockEntityModel<T> getModel(T entity) {
                return (BedrockEntityModel)baseModel.apply(entity);
            }
        };
        renderer.f_114478_ = shadowStrength;
        return renderer;
    }

    public static <T extends LivingEntity> TDELivingRenderer<T> createRendererGendered(EntityRendererProvider.Context context, final Function<T, TDEEntityModel<T>> baseModel, final Function<T, TDEEntityModel<T>> babyModel, float shadowRadius, float shadowStrength) {
        TDELivingRenderer renderer = new TDELivingRenderer<T>(context, shadowRadius){

            public BedrockEntityModel<T> getModel(T entity) {
                Animal animal;
                if (entity instanceof Animal && (animal = (Animal)entity).m_6162_()) {
                    return (BedrockEntityModel)babyModel.apply(entity);
                }
                return (BedrockEntityModel)baseModel.apply(entity);
            }
        };
        renderer.f_114478_ = shadowStrength;
        return renderer;
    }
}

