/*
 * Decompiled with CFR 0.152.
 */
package ru.xishnikus.thedawnera.client.render.entity;

import com.mojang.blaze3d.vertex.PoseStack;
import java.util.function.Function;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LightLayer;
import net.minecraft.world.phys.Vec3;
import ru.astemir.astemirlib.client.SmoothValue;
import ru.astemir.astemirlib.client.bedrock.animation.Animated;
import ru.astemir.astemirlib.client.bedrock.model.BedrockModel;
import ru.astemir.astemirlib.client.bedrock.model.BedrockModelLayer;
import ru.astemir.astemirlib.common.math.Color;
import ru.astemir.astemirlib.common.world.WorldUtils;
import ru.xishnikus.thedawnera.client.render.TDERenderTypes;

public class TDENightEyesLayer<T extends Entity>
extends BedrockModelLayer<T> {
    private Function<T, SmoothValue<Double>> eyesAlpha;
    private ResourceLocation texture;

    public TDENightEyesLayer(BedrockModel<T> model, ResourceLocation texture, Function<T, SmoothValue<Double>> eyesAlpha) {
        super(model);
        this.texture = texture;
        this.eyesAlpha = eyesAlpha;
    }

    public void render(T object, PoseStack poseStack, MultiBufferSource bufferSource, int packedLight, int packedOverlay) {
        this.renderModel((Animated)object, poseStack, bufferSource, 0x9600000, OverlayTexture.f_118083_);
    }

    public Color getColor(T object) {
        SmoothValue<Double> eyeAlpha = this.eyesAlpha.apply(object);
        if (this.isDarkOrNight(WorldUtils.blockPos((Vec3)object.m_146892_()), object.m_9236_())) {
            eyeAlpha.setTo((Object)1.0);
        } else {
            eyeAlpha.setTo((Object)0.0);
        }
        double f1 = (Double)eyeAlpha.get(Minecraft.m_91087_().getPartialTick());
        return new Color(1.0f, 1.0f, 1.0f, (float)f1);
    }

    public RenderType getRenderType(T object, ResourceLocation texture) {
        return TDERenderTypes.eyesTransparent(texture);
    }

    private boolean isDarkOrNight(BlockPos blockPos, Level level) {
        long roundedTime = level.m_46468_() % 24000L;
        boolean night = roundedTime >= 13000L && roundedTime <= 22000L;
        int i = level.m_45517_(LightLayer.SKY, blockPos);
        int j = level.m_45517_(LightLayer.BLOCK, blockPos);
        int brightness = night ? j : Math.max(i, j);
        return brightness >= 1 && brightness < 10;
    }

    public ResourceLocation getTexture(T object) {
        return this.texture;
    }
}

