/*
 * Decompiled with CFR 0.152.
 */
package ru.xishnikus.thedawnera.client.render.entity.mobs;

import com.mojang.blaze3d.vertex.PoseStack;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemDisplayContext;
import ru.astemir.astemirlib.client.RenderUtils;
import ru.astemir.astemirlib.client.bedrock.animation.Animation;
import ru.astemir.astemirlib.client.bedrock.animation.data.AnimationBlending;
import ru.astemir.astemirlib.client.bedrock.animation.data.Animator;
import ru.astemir.astemirlib.client.bedrock.model.BedrockModel;
import ru.astemir.astemirlib.client.bedrock.model.BedrockModelLayer;
import ru.astemir.astemirlib.client.bedrock.renderer.EntityRenderData;
import ru.astemir.astemirlib.common.math.AVector3f;
import ru.astemir.astemirlib.common.math.EasingType;
import ru.astemir.astemirlib.common.math.InterpolationType;
import ru.xishnikus.thedawnera.client.misc.MobModelResources;
import ru.xishnikus.thedawnera.client.misc.ModelResource;
import ru.xishnikus.thedawnera.client.render.entity.TDEEntityModel;
import ru.xishnikus.thedawnera.client.render.entity.TDELivingRenderer;
import ru.xishnikus.thedawnera.common.entity.entity.ground.EntityDeinonychus;

public class DeinonychusModel
extends TDEEntityModel<EntityDeinonychus> {
    private static final String ID = "deinonychus";
    private static final DeinonychusModel MODEL = new DeinonychusModel(DeinonychusModel.modelLocation("deinonychus", "geo.json"), DeinonychusModel.animationsLocation("deinonychus", "animation.json"));
    private static final DeinonychusModel BABY_MODEL = new DeinonychusModel(DeinonychusModel.modelLocation("deinonychus", "geo_baby.json"), DeinonychusModel.animationsLocation("deinonychus", "animation_baby.json"));
    private static final MobModelResources<EntityDeinonychus> modelResources = new MobModelResources<EntityDeinonychus>(new ModelResource<EntityDeinonychus>(MODEL, BABY_MODEL, DeinonychusModel.textureLocation("deinonychus", "male.png"), DeinonychusModel.textureLocation("deinonychus", "female.png"), DeinonychusModel.textureLocation("deinonychus", "baby.png")));

    public DeinonychusModel(ResourceLocation model, ResourceLocation animations) {
        super(model, animations);
        this.addLayer((BedrockModelLayer)new BedrockModelLayer<EntityDeinonychus>((BedrockModel)this){

            public void render(EntityDeinonychus entity, PoseStack poseStack, MultiBufferSource bufferSource, int packedLight, int packedOverlay) {
                if (entity.actionController.is(entity.actionEat) && entity.getLastEatenFood() != null) {
                    if (entity.m_6162_()) {
                        PoseStack itemPoseStack = RenderUtils.fromPose((PoseStack.Pose)this.getModel().getPart("wing2").getLastPose());
                        itemPoseStack.m_85837_(0.1, (double)-0.2f, (double)-0.3f);
                        this.renderItem((Entity)entity, entity.getLastEatenFood(), ItemDisplayContext.GROUND, itemPoseStack, bufferSource, packedLight);
                    } else {
                        PoseStack itemPoseStack = RenderUtils.fromPose((PoseStack.Pose)this.getModel().getPart("finger3").getLastPose());
                        itemPoseStack.m_252880_(0.0f, -0.3f, -0.1f);
                        this.renderItem((Entity)entity, entity.getLastEatenFood(), ItemDisplayContext.GROUND, itemPoseStack, bufferSource, packedLight);
                    }
                }
            }
        });
    }

    public void animate(Animator animator, EntityDeinonychus entity, EntityRenderData entityRenderData) {
        Animation animation = animator.getAnimation("animation.model.idle");
        if (this.isMoving((LivingEntity)entity, -0.1f, 0.1f, entityRenderData.partialTick)) {
            animation = animator.getAnimation("animation.model.walk");
        }
        if (this.isMoving((LivingEntity)entity, -0.5f, 0.5f, entityRenderData.partialTick)) {
            animation = animator.getAnimation("animation.model.run");
        }
        if (entity.isJumpState()) {
            animation = animator.getAnimation("animation.model.fall");
        }
        if (entity.m_20069_()) {
            animation = animator.getAnimation("animation.model.swim");
        }
        if (entity.actionController.is(entity.actionEat)) {
            animation = animator.getAnimation("animation.model.eat");
        }
        if (entity.actionController.is(entity.actionScream)) {
            animation = animator.getAnimation("animation.model.roar1");
        }
        if (entity.actionController.is(entity.actionCall)) {
            animation = animator.getAnimation("animation.model.roar2");
        }
        if (entity.actionController.is(entity.actionAttackBite)) {
            animation = animator.getAnimation("animation.model.attack1");
        }
        if (entity.actionController.is(entity.actionAttackClaw)) {
            animation = animator.getAnimation("animation.model.attack2");
        }
        if (entity.actionController.is(entity.actionAttackLeg)) {
            animation = animator.getAnimation("animation.model.attack3");
        }
        if (entity.actionController.is(entity.actionOpen)) {
            animation = animator.getAnimation("animation.model.open");
        }
        if (entity.actionController.is(entity.actionClean)) {
            animation = animator.getAnimation("animation.model.clean");
        }
        if (entity.actionController.is(entity.actionJump)) {
            animation = animator.getAnimation("animation.model.jump");
        }
        if (entity.actionController.is(entity.actionLand)) {
            animation = animator.getAnimation("animation.model.land");
        }
        if (entity.actionController.is(entity.actionDown)) {
            animation = animator.getAnimation("animation.model.down");
        }
        if (entity.stateController.is(entity.actionRest)) {
            animation = animator.getAnimation("animation.model.rest");
        }
        if (entity.actionController.is(entity.actionStartSleeping)) {
            animation = animator.getAnimation("animation.model.fall_asleep");
        }
        if (entity.stateController.is(entity.actionSleep)) {
            animation = animator.getAnimation("animation.model.sleep");
        }
        if (entity.actionController.is(entity.actionWakeUp)) {
            animation = animator.getAnimation("animation.model.wake_up");
        }
        if (entity.actionController.is(entity.actionUp)) {
            animation = animator.getAnimation("animation.model.up");
        }
        if (entity.m_20202_() != null) {
            animation = animator.getAnimation("animation.model.hang");
        }
        float yaw = entityRenderData.entityYaw;
        float bodyRotDeviation = ((Double)entity.bodyRotDeviation.get(entityRenderData.partialTick)).floatValue();
        animator.getTransform("neck").setLookAt(this.clamp(yaw, -30.0f, 30.0f), entityRenderData.entityPitch);
        animator.getTransform("body").setLookAt(this.clamp(-bodyRotDeviation * 2.0f, -20.0f, 20.0f), 0.0f);
        animator.setAnimation(animation, AnimationBlending.create((InterpolationType)InterpolationType.CATMULLROM, (EasingType)EasingType.NONE, (double)0.15f), 1.0, 1);
        if (entity.actionController.is(entity.actionEat) && entity.actionController.getTicks() < 40) {
            this.renderFoodParticles(entity, this, entityRenderData, new AVector3f(0.0f, 0.0f, 0.25f), new AVector3f(0.2f, 0.2f, 0.2f), 7, "head");
        }
    }

    public ResourceLocation getTexture(EntityDeinonychus entity) {
        return modelResources.chooseTexture(entity);
    }

    public static TDELivingRenderer<EntityDeinonychus> createRenderer(EntityRendererProvider.Context context) {
        return TDELivingRenderer.createRendererGendered(context, mob -> modelResources.chooseModel((EntityDeinonychus)mob), mob -> modelResources.chooseModel((EntityDeinonychus)mob), 0.4f, 1.0f);
    }
}

