/*
 * Decompiled with CFR 0.152.
 */
package ru.xishnikus.thedawnera.client.render.entity.mobs;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import java.util.function.Function;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import ru.astemir.astemirlib.client.SmoothValue;
import ru.astemir.astemirlib.client.bedrock.animation.Animated;
import ru.astemir.astemirlib.client.bedrock.animation.Animation;
import ru.astemir.astemirlib.client.bedrock.animation.data.AnimationBlending;
import ru.astemir.astemirlib.client.bedrock.animation.data.Animator;
import ru.astemir.astemirlib.client.bedrock.animation.data.PartTransform;
import ru.astemir.astemirlib.client.bedrock.model.BedrockModel;
import ru.astemir.astemirlib.client.bedrock.renderer.EntityRenderData;
import ru.astemir.astemirlib.common.math.AVector3f;
import ru.astemir.astemirlib.common.math.Color;
import ru.astemir.astemirlib.common.math.EasingType;
import ru.astemir.astemirlib.common.math.InterpolationType;
import ru.astemir.astemirlib.common.math.MathUtils;
import ru.xishnikus.thedawnera.client.misc.MobModelResources;
import ru.xishnikus.thedawnera.client.misc.ModelResource;
import ru.xishnikus.thedawnera.client.render.entity.TDEEntityModel;
import ru.xishnikus.thedawnera.client.render.entity.TDELivingRenderer;
import ru.xishnikus.thedawnera.client.render.entity.TDENightEyesLayer;
import ru.xishnikus.thedawnera.common.entity.data.MobVariation;
import ru.xishnikus.thedawnera.common.entity.entity.ground.EntityDimorphodon;

public class DimorphodonModel
extends TDEEntityModel<EntityDimorphodon> {
    private static final String ID = "dimorphodon";
    private static final DimorphodonModel MODEL = new DimorphodonModel(DimorphodonModel.modelLocation("dimorphodon", "geo.json"), DimorphodonModel.animationsLocation("dimorphodon", "animation.json"), false);
    private static final DimorphodonModel BABY_MODEL = new DimorphodonModel(DimorphodonModel.modelLocation("dimorphodon", "geo_baby.json"), DimorphodonModel.animationsLocation("dimorphodon", "animation_baby.json"), true);
    private static final MobModelResources<EntityDimorphodon> modelResources = new MobModelResources<EntityDimorphodon>(new ModelResource<EntityDimorphodon>(MODEL, BABY_MODEL, DimorphodonModel.textureLocation("dimorphodon", "male_0.png"), DimorphodonModel.textureLocation("dimorphodon", "female_0.png"), DimorphodonModel.textureLocation("dimorphodon", "baby_0.png"))).add(new ModelResource<EntityDimorphodon>(MODEL, BABY_MODEL, DimorphodonModel.textureLocation("dimorphodon", "male_1.png"), DimorphodonModel.textureLocation("dimorphodon", "female_1.png"), DimorphodonModel.textureLocation("dimorphodon", "baby_1.png")).mobVariationCondition(MobVariation.DESERT));

    public DimorphodonModel(ResourceLocation model, ResourceLocation animations, boolean isBaby) {
        super(model, animations);
        if (isBaby) {
            this.addLayer(new TDENightEyesLayer<EntityDimorphodon>((BedrockModel<EntityDimorphodon>)this, DimorphodonModel.textureLocation(ID, "eyes_baby.png"), (Function<EntityDimorphodon, SmoothValue<Double>>)((Function<EntityDimorphodon, SmoothValue>)EntityDimorphodon::getEyesAlpha)));
        } else {
            this.addLayer(new TDENightEyesLayer<EntityDimorphodon>((BedrockModel<EntityDimorphodon>)this, DimorphodonModel.textureLocation(ID, "eyes.png"), (Function<EntityDimorphodon, SmoothValue<Double>>)((Function<EntityDimorphodon, SmoothValue>)EntityDimorphodon::getEyesAlpha)));
        }
    }

    public void animate(Animator animator, EntityDimorphodon entity, EntityRenderData entityRenderData) {
        Animation animation = animator.getAnimation("animation.model.idle");
        if (entity.isDancing()) {
            animation = animator.getAnimation("animation.model.flex");
        }
        if (this.isMoving((LivingEntity)entity, -0.1f, 0.1f, entityRenderData.partialTick)) {
            animation = animator.getAnimation("animation.model.walk");
        }
        if (this.isMoving((LivingEntity)entity, -0.5f, 0.5f, entityRenderData.partialTick)) {
            animation = animator.getAnimation("animation.model.run");
        }
        if (entity.m_20069_()) {
            animation = animator.getAnimation("animation.model.swim");
        }
        if (entity.getAttachmentFacing() != Direction.DOWN) {
            animation = animator.getAnimation("animation.model.clim_idle");
            if (this.isMoving((LivingEntity)entity, -0.05f, 0.05f, entityRenderData.partialTick)) {
                animation = animator.getAnimation("animation.model.clim");
            }
        }
        if (entity.actionController.is(entity.actionEat)) {
            animation = animator.getAnimation("animation.model.eat");
        }
        if (entity.actionController.is(entity.actionScream)) {
            animation = animator.getAnimation("animation.model.scream");
        }
        if (entity.actionController.is(entity.actionAttack)) {
            animation = animation.merge(animator.getAnimation("animation.model.attack"));
        }
        if (entity.actionController.is(entity.actionDown)) {
            animation = animator.getAnimation("animation.model.down");
        }
        if (entity.stateController.is(entity.actionRest)) {
            animation = animator.getAnimation("animation.model.rest");
        }
        if (entity.actionController.is(entity.actionStartSleeping)) {
            animation = animator.getAnimation("animation.model.fall_asleep");
        }
        if (entity.stateController.is(entity.actionSleep)) {
            animation = animator.getAnimation("animation.model.sleep");
        }
        if (entity.actionController.is(entity.actionWakeUp)) {
            animation = animator.getAnimation("animation.model.wake_up");
        }
        if (entity.actionController.is(entity.actionUp)) {
            animation = animator.getAnimation("animation.model.up");
        }
        if (entity.isFlying()) {
            animation = entity.f_19797_ % 80 < 20 ? animator.getAnimation("animation.model.fly(not_used)") : animator.getAnimation("animation.model.plans");
        }
        Direction attachmentDir = entity.getAttachmentFacing();
        Direction prevAttachment = entity.getPreviousAttachmentDirection();
        PartTransform mainTransform = animator.getTransform("Dimorphodon");
        AVector3f climbRot = new AVector3f(0.0f, 0.0f, 0.0f);
        if (entity.isClimbing()) {
            float f = climbRot.z = entity.m_20184_().f_82480_ < 0.0 ? 180.0f : 0.0f;
            if (attachmentDir != Direction.DOWN) {
                climbRot.x = -90.0f;
            }
            if (attachmentDir == Direction.UP) {
                climbRot.x = -180.0f;
                climbRot.y = prevAttachment.m_122435_() + 90.0f;
            }
        }
        mainTransform.setCustomRotation(Mth.m_14189_((float)(entityRenderData.partialTick / 20.0f), (float)mainTransform.getCustomRotation().x, (float)climbRot.x), Mth.m_14189_((float)(entityRenderData.partialTick / 20.0f), (float)mainTransform.getCustomRotation().y, (float)climbRot.y), Mth.m_14189_((float)(entityRenderData.partialTick / 20.0f), (float)mainTransform.getCustomRotation().z, (float)climbRot.z));
        animator.getTransform("head").setLookAt(entityRenderData.entityYaw, 0.0f);
        animator.setAnimation(animation, AnimationBlending.create((InterpolationType)InterpolationType.CATMULLROM, (EasingType)EasingType.NONE, (double)0.1f), 1.0, 1);
        if (entity.actionController.is(entity.actionEat) && entity.actionController.getTicks() > 20) {
            this.renderFoodParticles(entity, this, entityRenderData, new AVector3f(0.0f, -0.1f, 0.0f), new AVector3f(0.1f, 0.2f, 0.1f), 8, "head");
        }
    }

    public void renderFinal(BedrockModel model, EntityDimorphodon object, PoseStack poseStack, MultiBufferSource bufferSource, int packedLight, int packedOverlay, Color color) {
        float delta = Minecraft.m_91087_().m_91296_();
        float ageInTicks = (float)object.f_19797_ + delta;
        poseStack.m_85836_();
        if (object.isFlying()) {
            EntityRenderData renderData = EntityRenderData.prepare((Entity)object, (float)delta);
            poseStack.m_252781_(Axis.f_252529_.m_252961_(this.rad(-renderData.entityPitch)));
            poseStack.m_252781_(Axis.f_252403_.m_252961_(MathUtils.sin((float)(ageInTicks / 10.0f)) / 4.0f));
        }
        super.renderFinal(model, (Animated)object, poseStack, bufferSource, packedLight, packedOverlay, color);
        poseStack.m_85849_();
    }

    public ResourceLocation getTexture(EntityDimorphodon entity) {
        return modelResources.chooseTexture(entity);
    }

    public static TDELivingRenderer<EntityDimorphodon> createRenderer(EntityRendererProvider.Context context) {
        return TDELivingRenderer.createRendererGendered(context, mob -> modelResources.chooseModel((EntityDimorphodon)mob), mob -> modelResources.chooseModel((EntityDimorphodon)mob), 0.3f, 1.0f);
    }
}

