/*
 * Decompiled with CFR 0.152.
 */
package ru.xishnikus.thedawnera.client.render.entity.mobs;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.LivingEntity;
import ru.astemir.astemirlib.client.bedrock.animation.Animated;
import ru.astemir.astemirlib.client.bedrock.animation.Animation;
import ru.astemir.astemirlib.client.bedrock.animation.data.AnimationBlending;
import ru.astemir.astemirlib.client.bedrock.animation.data.Animator;
import ru.astemir.astemirlib.client.bedrock.animation.data.PartTransform;
import ru.astemir.astemirlib.client.bedrock.renderer.EntityRenderData;
import ru.astemir.astemirlib.common.action.ActionState;
import ru.astemir.astemirlib.common.math.AVector3f;
import ru.astemir.astemirlib.common.math.Color;
import ru.astemir.astemirlib.common.math.EasingType;
import ru.astemir.astemirlib.common.math.InterpolationType;
import ru.xishnikus.thedawnera.client.misc.MobModelResources;
import ru.xishnikus.thedawnera.client.misc.ModelResource;
import ru.xishnikus.thedawnera.client.render.entity.TDEEntityModel;
import ru.xishnikus.thedawnera.client.render.entity.TDELivingRenderer;
import ru.xishnikus.thedawnera.common.entity.entity.water.EntityDiplocaulus;

public class DiplocaulusModel
extends TDEEntityModel<EntityDiplocaulus> {
    private static final String ID = "diplocaulus";
    private static final DiplocaulusModel MODEL = new DiplocaulusModel(DiplocaulusModel.modelLocation("diplocaulus", "geo.json"), DiplocaulusModel.animationsLocation("diplocaulus", "animation.json"));
    private static final DiplocaulusModel BABY_MODEL = new DiplocaulusModel(DiplocaulusModel.modelLocation("diplocaulus", "geo_baby.json"), DiplocaulusModel.animationsLocation("diplocaulus", "animation_baby.json"));
    private static final MobModelResources<EntityDiplocaulus> modelResources = new MobModelResources<EntityDiplocaulus>(new ModelResource<EntityDiplocaulus>(MODEL, BABY_MODEL, DiplocaulusModel.textureLocation("diplocaulus", "male.png"), DiplocaulusModel.textureLocation("diplocaulus", "female.png"), DiplocaulusModel.textureLocation("diplocaulus", "baby.png")));

    public DiplocaulusModel(ResourceLocation model, ResourceLocation animations) {
        super(model, animations);
    }

    public void animate(Animator animator, EntityDiplocaulus entity, EntityRenderData entityRenderData) {
        Animation animation;
        Animation animation2 = animation = entity.isMad() ? animator.getAnimation("animation.model.idle2") : animator.getAnimation("animation.model.idle");
        if (this.isMoving((LivingEntity)entity, -0.05f, 0.05f, entityRenderData.partialTick)) {
            Animation animation3 = animation = entity.isMad() ? animator.getAnimation("animation.model.walk2") : animator.getAnimation("animation.model.walk");
        }
        if (entity.m_20069_()) {
            animation = animator.getAnimation("animation.model.swim");
        }
        if (entity.actionController.is(entity.actionScream)) {
            animation = animator.getAnimation("animation.model.scream");
        }
        if (entity.actionController.is(entity.actionAttack)) {
            animation = animator.getAnimation("animation.model.attack1");
        }
        if (entity.actionController.is(entity.actionAttackInWater)) {
            animation = animator.getAnimation("animation.model.attack2");
        }
        if (entity.actionController.is(entity.actionEat)) {
            animation = animator.getAnimation("animation.model.eat1");
        }
        if (entity.actionController.is(entity.actionEatInWater)) {
            animation = animator.getAnimation("animation.model.eat2");
        }
        float bodyRotDeviation = ((Double)entity.bodyRotDeviation.get(entityRenderData.partialTick)).floatValue();
        float madness = ((Double)entity.madness.get(Minecraft.m_91087_().getPartialTick())).floatValue();
        PartTransform diplocaulusTransform = animator.getTransform("Diplocaulus");
        if (entity.m_20069_()) {
            diplocaulusTransform.setCustomRotation(this.clamp(entityRenderData.entityPitch, -90.0f, 90.0f), entityRenderData.entityYaw, 0.0f);
        } else {
            diplocaulusTransform.setCustomRotation(diplocaulusTransform.getCustomRotation().interpolate(new AVector3f(0.0f, 0.0f, 0.0f), InterpolationType.LINEAR, entityRenderData.partialTick));
        }
        if (madness > 0.0f) {
            diplocaulusTransform.setCustomScale(1.0f + madness / 4.0f, 1.0f + madness / 4.0f, 1.0f + madness / 4.0f);
        } else {
            diplocaulusTransform.setCustomScale(1.0f, 1.0f, 1.0f);
        }
        animator.getTransform("head").setCustomRotation(this.clamp(entityRenderData.entityPitch, -10.0f, 10.0f), bodyRotDeviation, 0.0f);
        animator.getTransform("body").setCustomRotation(0.0f, -bodyRotDeviation, 0.0f);
        animator.getTransform("tail1").setCustomRotation(0.0f, -bodyRotDeviation * 2.0f, 0.0f);
        animator.getTransform("tail2").setCustomRotation(0.0f, -bodyRotDeviation * 3.0f, 0.0f);
        animator.setAnimation(animation, AnimationBlending.create((InterpolationType)InterpolationType.CATMULLROM, (EasingType)EasingType.NONE, (double)0.15f), 1.0, 1);
        if (entity.actionController.is(new ActionState[]{entity.actionEat, entity.actionEatInWater}) && entity.actionController.getTicks() < 40) {
            this.renderFoodParticles(entity, this, entityRenderData, new AVector3f(0.0f, 0.0f, 0.25f), new AVector3f(0.2f, 0.2f, 0.2f), 7, "head");
        }
    }

    public Color getColor(EntityDiplocaulus object) {
        float madness = ((Double)object.madness.get(Minecraft.m_91087_().getPartialTick())).floatValue();
        if (madness > 0.0f) {
            return Color.WHITE.interpolate(new Color(0.5f, 0.0f, 0.0f, 1.0f), InterpolationType.LINEAR, madness);
        }
        return super.getColor((Animated)object);
    }

    public void m_7695_(PoseStack poseStack, VertexConsumer vertexConsumer, int light, int overlay, float red, float green, float blue, float alpha) {
        super.m_7695_(poseStack, vertexConsumer, light, overlay, red, green, blue, alpha);
    }

    public ResourceLocation getTexture(EntityDiplocaulus entity) {
        return modelResources.chooseTexture(entity);
    }

    public static TDELivingRenderer<EntityDiplocaulus> createRenderer(EntityRendererProvider.Context context) {
        return TDELivingRenderer.createRendererGendered(context, mob -> modelResources.chooseModel((EntityDiplocaulus)((Object)mob)), mob -> modelResources.chooseModel((EntityDiplocaulus)((Object)mob)), 0.3f, 1.0f);
    }
}

