/*
 * Decompiled with CFR 0.152.
 */
package ru.xishnikus.thedawnera.client.render.entity.mobs;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.LivingEntity;
import ru.astemir.astemirlib.client.bedrock.animation.Animation;
import ru.astemir.astemirlib.client.bedrock.animation.data.AnimationBlending;
import ru.astemir.astemirlib.client.bedrock.animation.data.Animator;
import ru.astemir.astemirlib.client.bedrock.renderer.EntityRenderData;
import ru.astemir.astemirlib.common.math.AVector3f;
import ru.astemir.astemirlib.common.math.EasingType;
import ru.astemir.astemirlib.common.math.InterpolationType;
import ru.xishnikus.thedawnera.client.misc.MobModelResources;
import ru.xishnikus.thedawnera.client.misc.ModelResource;
import ru.xishnikus.thedawnera.client.render.entity.TDEEntityModel;
import ru.xishnikus.thedawnera.client.render.entity.TDELivingRenderer;
import ru.xishnikus.thedawnera.common.entity.entity.ground.EntityDodo;

public class DodoModel
extends TDEEntityModel<EntityDodo> {
    private static final String ID = "dodo";
    private static final DodoModel MODEL = new DodoModel(DodoModel.modelLocation("dodo", "geo.json"), DodoModel.animationsLocation("dodo", "animation.json"));
    private static final DodoModel BABY_MODEL = new DodoModel(DodoModel.modelLocation("dodo", "geo_baby.json"), DodoModel.animationsLocation("dodo", "animation_baby.json"));
    private static final MobModelResources<EntityDodo> modelResources = new MobModelResources<EntityDodo>(new ModelResource<EntityDodo>(MODEL, BABY_MODEL, DodoModel.textureLocation("dodo", "male.png"), DodoModel.textureLocation("dodo", "female.png"), DodoModel.textureLocation("dodo", "baby.png"))).add(new ModelResource<EntityDodo>(MODEL, BABY_MODEL, DodoModel.textureLocation("dodo", "pizza.png"), DodoModel.textureLocation("dodo", "pizza.png"), DodoModel.textureLocation("dodo", "baby.png")).customNameCondition("Pizza"));

    public DodoModel(ResourceLocation model, ResourceLocation animations) {
        super(model, animations);
    }

    public void animate(Animator animator, EntityDodo entity, EntityRenderData entityRenderData) {
        Animation animation = animator.getAnimation("animation.model.idle");
        if (this.isMoving((LivingEntity)entity, -0.1f, 0.1f, entityRenderData.partialTick)) {
            animation = animator.getAnimation("animation.model.walk");
        }
        if (this.isMoving((LivingEntity)entity, -0.5f, 0.5f, entityRenderData.partialTick)) {
            animation = animator.getAnimation("animation.model.run");
        }
        if (entity.m_20069_()) {
            animation = animator.getAnimation("animation.model.swim");
        }
        if (entity.actionController.is(entity.actionEat)) {
            animation = animator.getAnimation("animation.model.eat");
        }
        if (entity.actionController.is(entity.actionScream)) {
            animation = animator.getAnimation("animation.model.scream");
        }
        if (entity.actionController.is(entity.actionDown)) {
            animation = animator.getAnimation("animation.model.down");
        }
        if (entity.stateController.is(entity.actionRest)) {
            animation = animator.getAnimation("animation.model.rest");
        }
        if (entity.actionController.is(entity.actionStartSleeping)) {
            animation = animator.getAnimation("animation.model.fall_asleep");
        }
        if (entity.stateController.is(entity.actionSleep)) {
            animation = animator.getAnimation("animation.model.sleep");
        }
        if (entity.actionController.is(entity.actionWakeUp)) {
            animation = animator.getAnimation("animation.model.wake_up");
        }
        if (entity.actionController.is(entity.actionUp)) {
            animation = animator.getAnimation("animation.model.up");
        }
        animator.getTransform("neck").setLookAt(this.clamp(entityRenderData.entityYaw, -30.0f, 30.0f), entityRenderData.entityPitch);
        animator.setAnimation(animation, AnimationBlending.create((InterpolationType)InterpolationType.CATMULLROM, (EasingType)EasingType.NONE, (double)0.15f), 1.0, 1);
        if (entity.actionController.is(entity.actionEat) && entity.actionController.getTicks() < 40) {
            this.renderFoodParticles(entity, this, entityRenderData, new AVector3f(0.0f, 0.0f, 0.25f), new AVector3f(0.2f, 0.2f, 0.2f), 7, "head");
        }
    }

    public void m_7695_(PoseStack poseStack, VertexConsumer vertexConsumer, int light, int overlay, float red, float green, float blue, float alpha) {
        super.m_7695_(poseStack, vertexConsumer, light, overlay, red, green, blue, alpha);
    }

    public ResourceLocation getTexture(EntityDodo entity) {
        return modelResources.chooseTexture(entity);
    }

    public static TDELivingRenderer<EntityDodo> createRenderer(EntityRendererProvider.Context context) {
        return TDELivingRenderer.createRendererGendered(context, mob -> modelResources.chooseModel((EntityDodo)((Object)mob)), mob -> modelResources.chooseModel((EntityDodo)((Object)mob)), 0.3f, 1.0f);
    }
}

